/*---------------------------------------------------------------------------
	MENULIB.H   -- menu managment system

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/

#if ! defined (_H_MENULIB_)
#define _H_MENULIB_

#define MN_NOSELECT			0	/* mn_read constant */
#define MN_TRANSMIT		0x01	/* Transmit if key pressed */
#define MN_CONDTRANS		0x02	/* Transmit if key pressed and specificed item selected */
#define MN_REMOVE			0x04	/* Remove the menu from screen */
#define MN_ABORT			0x08	/* Abort mn_read operation */
#define MN_BEEP			0x10	/* Beep if key pressed */

#define MN_USER_NOTHING		0
#define MN_USER_BREAK		1
#define MN_USER_CONTINUE	2

typedef enum {
	MN_NOMOVE,		/* Do not move                      */
	MN_UP,			/* Upward in the same column        */
	MN_DOWN,			/* Downward in the same column      */
	MN_RIGHT,		/* To the right on the same row     */
	MN_LEFT,			/* To the left on the same row      */
	MN_FIRST,		/* To the first item in the menu    */
	MN_LAST,			/* To the last item in the menu     */
	MN_NEXT,			/* To the next item in the menu     */
	MN_PREVIOUS,	/* To the previous item in the menu */
	MN_GOTO			/* To the a specific item           */
} MOTION;

typedef enum {
	MN_NOHICHAR,		/* No highlited characters, just simply menu */
	MN_FIRSTCHAR,		/* First character highlited        */
	MN_USERDEF,			/* User defined character highlited */
	MN_EDITITEM,		/* edit item in menu */
	MN_PROTECTITEM		/* Display only this position */
} ITEMTYPE;

typedef struct {
	unsigned int x,y;		/* Coordinates within menu window */
	char *itemstr;			/* Item string */
	ITEMTYPE itype;		/* type of item */
	int ipos;				/* Highlited character position(mn_read) */
								/* or max width edit field(mn_edit) */
								/* Valid only if itemtype == MN_EDITITEM */
	int (*userfunc)(int*,int*);
								/* user control function */
} ITEM;

typedef struct {
	int ch;				/* Character code           */
	int sc;				/* Scan code                */
	unsigned int itempos;		/* Item associated with key */
	MOTION barmove;	/* Bar move */
	unsigned int action;		/* action executed if key pressed */
} KEYDEF;

typedef struct IntKeyDefType KEYDEFLIST;
struct IntKeyDefType {
	KEYDEFLIST *nextkey;	/* Pointer to keys chain   */
	KEYDEF defkey;			/* Key binding definition  */
};

typedef struct {
	char *str;					/* Item string */
} LOTITEM;

typedef struct {
	unsigned int xleft,xtop;		/* Coordinates of Lotus description window */
	unsigned int width;				/* width of window      */
	unsigned char fillch;
	unsigned int Lfore,Lback;		/* Lotus menu attribute */
	unsigned int left,top;			/* position string inside window */
	int isframe;			/* If frame             */
	framestr framedef;	/* Frame characters     */
	unsigned int Ffore,Fback;		/* Frame attribute      */
} LOTUSDEF;

typedef struct {
	int xleft,xtop;
	int xright,xbottom;	/* outer co-ordinates of opposite corners */
	unsigned int Mfore,Mback;		/* Menu window attribute */
	unsigned char fillch;
	unsigned int Nfore,Nback;	/* Normal    bar attribute  */
	unsigned int Bfore,Bback;	/* Highlight bar attribute  */
	unsigned int Hfore,Hback;		/* Character attribute      */
	int isframe;			/* if frame            */
	framestr framedef;	/* only used if frame  */
	int Ffore,Fback;
} MENUDEF;

typedef struct MENUDESCTYPE *MENUTYPE;
typedef struct MENUDESCTYPE {	/* Internal menu descriptor */
	unsigned int guard;				/* Menu signature */
	WINTYPE winptr;		/* Menu window */
	int  curpos;			/* Current item */
	int  lastitemno;		/* Number of menu item */
	ITEM *itemptr;			/* Pointer to item array */
	unsigned int Nfore,Nback;		/* Menu attribute */
	unsigned int Bfore,Bback;		/* Highlight bar attribute */
	unsigned int Hfore,Hback;		/* Character attribute */
	int islotus;			/* If Lotus-style menu */
	WINTYPE lotwinptr;	/* Lotus window */
	unsigned int lleft,ltop; /* position lotus string inside window */
	LOTITEM *lotptr;		/* Pointer to array Lotus description strings */
	int lastkeyno;			/* Number of user key definition */
	KEYDEF *KeyRef;		/* Pointer to user defined key array */
	KEYDEFLIST *Keys;		/* Pointer to key list */
	} MENUDESC;

typedef struct MenuListLink *MenuListPtr;

typedef struct MenuListLink {
	MenuListPtr next;
	MENUTYPE menu;
} MENULIST;


MENUTYPE mn_create (MENUDEF *md, ITEM itemtab[], int sizeitemtab);
/*
 Create menu structure.
  md           Record structure which defines menu characteristics.
  itemtab      Array of ITEM which are items text characteristics.
  sizeitemtab  Number of items in tab.
  lstr         Pointer to ARRAY OF MenuStr which are Lotus description
					strings. Valid only if MD.islotus = TRUE , otherwise NIL.
 Return  menu handle.
*/

WINTYPE mn_setlotus (MENUTYPE m, LOTUSDEF *ld, LOTITEM lottab[]);
/*
  Definition the size and/or position of the Lotus description window.
     LD  Lotus description window defintion.

  Default Lotus description window
    X = 0 , Y = 24 , Width = 80 , No frame
*/

void mn_keys (MENUTYPE m, KEYDEF kd[], int size);
/*
 Add key binding to a menu.
  m       Menu handle.
  kd      Array of user key definition.
  size    Size of usey key definition array.
*/

int mn_rdmenu (MENUTYPE m, int *ch, int *sc);
/*
 Request user input for a menu.
    M     Menu handle.
    Ch    Character code and scan code key pressed
    Sc    that terminated  ReadMenu

 Return   Number selected item or  NOSELECT if key with
             Action = MN_ABORT or MN_REMOVE was pressed.
*/

void mn_remove (MENUTYPE m);
/*
  Removes menu from the screen.
    M   Menu handle.
*/

MENUTYPE mn_destroy(MENUTYPE m);
/*
  Release menu data strutures. Remove from screen if necessary.
    m   Menu handle.
*/


void mn_settitle (MENUTYPE m, char *title, TITLEMODE mode);
/*
  Updates the menu title whithin menu frame.
     m      Menu handle.
     title  New menu title.
     mode   Postion in the menu frame.
*/

void mn_setframe (MENUTYPE m, char *frame, unsigned int fore, unsigned int back);
/*
  Changes the frame around the specified menu.
    m      Menu handle.
    frame  Frame definition.
    fore   Frame attribute.
    back        -"-
*/

WINTYPE mn_win (MENUTYPE m);
/*
  Return menu window.
    M   Menu handle.
*/

void mn_exit (void);
/*
  destroy all menus
*/

#endif

