/*--------------------------------------------------------------------------
	CWIN.C

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/
#include <conio.h>

#include "winlib.h"
#include "keylib.h"
#include "utlib.h"

#define MAX_I		4

static WINTYPE w[MAX_I];

static WINDEF wd0 = { 5,5, 15,15,RED,LIGHTGRAY,' ',SET,SET,CLR,SET,
							"Ŀ",BLUE,LIGHTGRAY};
static WINDEF wd1 = { 8,8, 70,18,GREEN,LIGHTGRAY,'',SET,SET,CLR,SET,
							"Ŀ",BLACK,LIGHTGRAY};
static WINDEF wd2 = {20,2, 30,22,BLUE,LIGHTGRAY,'',SET,SET,CLR,SET,
							"Ŀ",RED,LIGHTGRAY};
static WINDEF wd3 = { 55,10,75,20,RED,LIGHTGRAY,'',SET,SET,CLR,SET,
							"Ŀ",BLACK,LIGHTGRAY};

static WINDEF FullScreenDef = {
	0,0,0,0,			/* Outer coordinates        */
	BLUE,BLACK,	/* Window attribute         */
	'',				/* Fill charcater           */
	CLR,				/* if cursor active         */
	SET,				/* if EOL wrap enabled      */
	CLR,				/* if window on view        */
	CLR,				/* If frame                 */
	{0},				/* Frame characters         */
	BLACK,BLACK		/* Frame attribute          */
	};

extern int cwin_error;

void main ()
{
int i;
int ln = 0;
int ch,sc;
int done;

	if (wn_init(&FullScreenDef,0) != 0)
		return;

	wn_directwrite(0,0,"ALA MA KOTA@",12,0x07);
	wn_directwritestr(0,1,"ALA MA KOTA@",12);
	wn_directwriteattr(0,2,12,0x70);

	wn_directwrite(68,24,"ALA MA KOTA@",12,0x07);

	w[0] = wn_open(&wd0);
	wn_settitle(w[0]," Zero ", TOPLEFTTITLE);
	for(i=0; i<1000; i++)
		wn_putch(i%24+'A');
	wn_gotoxy(2,3);
	wn_clreol();
	wn_putch(':');
	wn_insline();
	wn_putch('.');
	getch();

	w[1] = wn_open(&wd1);
	wn_settitle(w[1]," One ", BOTTOMCENTERTITLE);
	wn_cursoroff();
	for(i=0; i<1000; i++)
		wn_putch(i%24+'A');
	getch();

	w[2] = wn_open(&wd2);
	wn_setwrap(0);
	wn_settitle(w[2]," Two ", BOTTOMRIGHTTITLE);
	for(i=0; i<1000; i++)
		wn_putch(i%24+'A');
	getch();

	w[3] = wn_open(&wd3);
	wn_settitle(w[3]," Three ", BOTTOMLEFTTITLE);
	wn_cursoroff();
	for(i=0; i<1000; i++)
		wn_putch(i%24+'A');
	getch();

	wn_putbeneath(w[2],w[1]);

	i=0;
	wn_setframe(w[i],DDDDFrame,w[i]->wdef.Ffore,w[i]->wdef.Fback);
	wn_putontop(w[i]);
	ln=0;
	done=0;
	do
		{
		switch(kb_read(&ch,&sc))
			{
			case KB_N_LEFT:
				wn_move(-1,0);
				break;
			case KB_N_UP:
				wn_move(0,-1);
				break;
			case KB_N_RIGHT:
				wn_move(1,0);
				break;
			case KB_N_DOWN:
				wn_move(0,1);
				break;
			case KB_N_SPACE:
				ln++;
				wn_setframe(w[i],SSSSFrame,w[i]->wdef.Ffore,w[i]->wdef.Fback);
				if (++i >= MAX_I)
					i=0;
				wn_putontop(w[i]);
				wn_setframe(w[i],DDDDFrame,w[i]->wdef.Ffore,w[i]->wdef.Fback);
				if (ln%11 == 0)
					wn_clear();
				wn_printf("\n\rabcd\n\r = %d ; %d",i,ln);
				break;
			case KB_N_ESC:
				done = 1;
				break;
			}
		}
	while(!done);

	wn_close(w[0]);
	getch();
	wn_close(w[1]);
	getch();
	wn_close(w[2]);
	getch();
	wn_close(w[3]);
	getch();

	wn_exit();
}
