/*---------------------------------------------------------------------------
	STRLIB.C

	Version 1.00 (C)Copyright Andrew Trzeciak. 1993
*/

#include <string.h>
#include <ctype.h>

#include "strlib.h"

/*---------------------------------------------------------------------------

*/
char *strtrim (char *src)
{
register char *s,*d;

	s = d = src;
	while (*s && isspace(*s))	/* remove left spaces */
		s++;

	while (*s)	/* copy to end of str*/
		*d++ = *s++;
	*d = '\0';

	while (isspace(*(d-1)))		/* remove right spaces */
		d--;
	*d = '\0';

return src;
}

/*---------------------------------------------------------------------------

*/
char *strltrim (char *src)
{
register char *s,*d;

	s = d = src;
	while (*s && isspace(*s))	/* remove left spaces */
		s++;

	while (*s)	/* copy to end of str*/
		*d++ = *s++;
	*d = '\0';

return src;
}

/*---------------------------------------------------------------------------

*/
char *strrtrim (char *src)
{
register char *s,*d;

	s = d = src;
	while (*s)	/* copy to end of str*/
		*d++ = *s++;
	*d = '\0';

	while (isspace(*(d-1)))		/* remove right spaces */
		d--;
	*d = '\0';

return src;
}

/*---------------------------------------------------------------------------
	strcenter
*/
char *strcenter (char *trg, char *src, int width)
{
char *psave = trg;
int left = (width-(int)strlen(src)+1)/2;

	while (left-- > 0 && width-- > 0)
		*trg++ = ' ';

	while (*src && width-- > 0)
		*trg++ = *src++;

	while (width-- > 0)
		*trg++ = ' ';
	*trg = '\0';

return psave;
}

/*---------------------------------------------------------------------------

*/
char *strpad (char *trg, char *src, int width)
{
char *psave = trg;

	while (*src && width--)
		*trg++ = *src++;

	while (width--)
		*trg++ = ' ';
	*trg = '\0';

return psave;
}

/*---------------------------------------------------------------------------
	strposch
*/
int strposch (register char *pstr, char ch)
{
int pos = 0;

	while (*pstr)
		{
		if (*pstr++ == ch)
			return pos;
		pos++;
		}

return -1;
}

/*---------------------------------------------------------------------------

*/
unsigned int strlast(char *str)
{
unsigned int pos;

	str += (pos = strlen(str)-1);
	while (isspace(*str--) && pos--)
		;
return pos;
}

/*---------------------------------------------------------------------------

*/
void strdelch (char *str,unsigned int num, unsigned int pos, unsigned int width)
{
	if (pos < width)
		{
		for (str += pos; pos+num < width; str++,pos++)
			*str = *(str+num);

		while (pos++ < width)
			*str++ = ' ';
		}
}

/*---------------------------------------------------------------------------

*/
void strinsch (char *str, int ch, unsigned int pos, unsigned int width)
{
int buf;

	if (pos < width)
		{
		for (str += pos; pos < width; pos++)
			{
			buf = *str;
			*str++ = ch;
			ch = buf;
			}
		}
}

/*---------------------------------------------------------------------------

*/
int strnotblank (char *src)
{
int i = 0;

	while (*src)
		{
		if (isalnum(*src))
			return i;
		src++;
		i++;
		}

return -1;
}

/*---------------------------------------------------------------------------

*/
int isfilech (int ch)
{

return isalnum(ch) || strposch("$&#@!%`'()-_^~",ch) >= 0;
}

