/*--------------------------------------------------------------------------
	EDITNAME.C

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/
#include <string.h>

#include <winlib.h>
#include <menulib.h>
#include <keylib.h>
#include <utlib.h>

static MENUDEF md = {
	0,0,0,0,				/* Outer coordinates        */
	WHITE,BLACK,		/* Menu attribute           */
	' ',					/* back ground fill char    */
	WHITE,BLACK,		/* Normal bar attribute     */
	BLACK,WHITE,		/* Highlight bar attribute  */
	LIGHTGRAY,BLACK,	/* Highlight char attribute */
	SET,					/* If frame                 */
	DDDDFrame,			/* Frame characters         */
	WHITE,BLACK			/* Frame attribute          */
	};

static KEYDEF mn_key[] = {
	{ KB_CH_N_UP,    KB_SC_N_UP,   0, MN_NOMOVE, 0 },
	{ KB_CH_N_DOWN,  KB_SC_N_DOWN, 0, MN_NOMOVE, 0 },
	{ KB_CH_N_PGUP,  KB_SC_N_PGUP, 0, MN_NOMOVE, 0 },
	{ KB_CH_S_PGDN,  KB_SC_S_PGDN, 0, MN_NOMOVE, 0 },
	{ KB_CH_N_TAB,   KB_SC_N_TAB,  0, MN_NOMOVE, 0 },
	{ KB_CH_S_TAB,   KB_SC_S_TAB,  0, MN_NOMOVE, 0 }
	};

/*---------------------------------------------------------------------------
	edit_name
*/
int EditName (int row, int col, char *prompt, char *name, int namesize)
{
MENUTYPE mn;
WINTYPE wsave;
ITEM mn_item[1];
int promptsize = strlen(prompt) + 2;
int result,ch,sc;

	wsave = wn_used();

	md.xleft    = col;
	md.xtop		= row;
	md.xright	= col + namesize + promptsize;
	md.xbottom	= row+2;

	mn_item[0].x = promptsize;
	mn_item[0].y = 1;
	mn_item[0].itemstr  = name;
	mn_item[0].itype    = MN_EDITITEM;
	mn_item[0].ipos     = namesize-1;
	mn_item[0].userfunc = 0;

	mn = mn_create(&md,mn_item,SIZETAB(mn_item));
	mn_keys(mn,mn_key,SIZETAB(mn_key));
	wn_gotoxy(2,1); wn_puts(prompt);
	result = !mn_rdmenu(mn,&ch,&sc);

	mn_destroy(mn);
	wn_use(wsave);

return result;
}

