/*--------------------------------------------------------------------------
	CMENU.C

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>

#include "winlib.h"
#include "menulib.h"
#include "keylib.h"
#include "utlib.h"


static MENUTYPE mn[3];

static MENUDEF md1 = {
	1,1,15,10,			/* Outer coordinates        */
	RED,LIGHTGRAY,		/* Menu attribute           */
	' ',					/* back ground fill char    */
	RED,LIGHTGRAY,		/* Normal bar attribute     */
	BLUE,LIGHTGREEN,	/* Highlight bar attribute  */
	RED,WHITE,			/* Highlight char attribute */
	SET,					/* If frame                 */
	DDDDFrame,			/* Frame characters         */
	BLUE,LIGHTGRAY		/* Frame attribute          */
	};

static MENUDEF md2 = {
	16,1,40,10,			/* Outer coordinates        */
	RED,LIGHTGRAY,		/* Menu attribute           */
	' ',					/* back ground fill char    */
	RED,LIGHTGRAY,		/* Normal bar attribute     */
	BLUE,LIGHTGREEN,	/* Highlight bar attribute  */
	RED,WHITE,			/* Highlight char attribute */
	SET,					/* If frame                 */
	DDDDFrame,			/* Frame characters         */
	BLUE,LIGHTGRAY		/* Frame attribute          */
	};

static MENUDEF md3 = {
	41,1,60,10,			/* Outer coordinates        */
	RED,LIGHTGRAY,		/* Menu attribute           */
	' ',					/* back ground fill char    */
	RED,LIGHTGRAY,		/* Normal bar attribute     */
	BLUE,LIGHTGREEN,	/* Highlight bar attribute  */
	RED,WHITE,			/* Highlight char attribute */
	SET,					/* If frame                 */
	DDDDFrame,			/* Frame characters         */
	BLUE,LIGHTGRAY		/* Frame attribute          */
	};

static ITEM mn1_items[] = {
	{ 1,1," One    ",MN_FIRSTCHAR,0,0},
	{ 1,2," tWo    ",MN_USERDEF  ,2,0},
	{ 1,3," Three  ",MN_FIRSTCHAR,0,0},
	{ 1,4," Four   ",MN_FIRSTCHAR,0,0}
	};

static ITEM mn2_items[] = {
	{1,1," 1 One    ",MN_FIRSTCHAR,0,0},
	{1,2," 2 Two    ",MN_FIRSTCHAR,0,0},
	{1,3," 3 Three  ",MN_FIRSTCHAR,0,0},
	{1,4," 4 Four   ",MN_FIRSTCHAR,0,0}
	};

static ITEM mn3_items[] = {
	{1,1," A One  ",MN_USERDEF,1,0},
	{1,2," B Two  ",MN_USERDEF,1,0},
	{1,3," C Three",MN_USERDEF,1,0},
	{1,4," D Four ",MN_USERDEF,1,0}
	};



LOTITEM mn1_lottab[] = {
	{"to jest test zero"},
	{"to jest test jeden"},
	{"to jest test dwa"},
	{"to jest test trzy"}
};

KEYDEF mn_key[] = {
	{ KB_CH_N_LEFT,   KB_SC_N_LEFT,  0, MN_NOMOVE, MN_REMOVE | MN_ABORT },
	{ KB_CH_N_RIGHT,  KB_SC_N_RIGHT, 0, MN_NOMOVE, MN_REMOVE | MN_ABORT }
	};

static WINDEF FullScreenDef = {
	0,0,0,0,			/* Outer coordinates        */
	LIGHTGRAY,BLACK,	/* Window attribute         */
	'',				/* Fill charcater           */
	CLR,				/* if cursor active         */
	SET,				/* if EOL wrap enabled      */
	CLR,				/* if window on view        */
	CLR,				/* If frame                 */
	{0},				/* Frame characters         */
	RED,LIGHTGRAY	/* Frame attribute          */
	};

static LOTUSDEF ld1 = {
	0,24,
	80,
	' ',
	RED,LIGHTGRAY,
	1,1,
	CLR,
	SSSSFrame,
	RED,LIGHTGRAY,
};

int EditName (int row, int col, char *prompt, char *name, int namesize);

#define DOSFNAME	8
typedef struct {
	char sel;
	char name[DOSFNAME+1];
	} FNAMETAB;

FNAMETAB *ftab;

int select_files (FNAMETAB *ftab, int size);

char fname[MAXPATH]="*.*";
int fpos;

void main (void)
{
int i,ch,sc;
int done,cnt;
int size=52;

	if (wn_init(&FullScreenDef,1) != 0)
		return;

	EditName(5,5,"File name: ",fname,40);

	ftab = ut_memalloc(size*sizeof(FNAMETAB));

	for (i=0; i<size; i++)
		{
		ftab[i].sel = 0;
		sprintf(ftab[i].name,"%-.5s%-.3d",strupr(fname),i);
		}
	select_files(ftab,size);


	mn[0] = mn_create(&md1,mn1_items,SIZETAB(mn1_items));
	mn_settitle(mn[0],"ONE",TOPCENTERTITLE);
	mn_setlotus (mn[0],&ld1,mn1_lottab);
	mn_keys (mn[0],mn_key,SIZETAB(mn_key));

	mn[1] = mn_create(&md2,mn2_items,SIZETAB(mn2_items));
	mn_settitle(mn[1],"TWO",BOTTOMCENTERTITLE);
	mn_keys (mn[1],mn_key,SIZETAB(mn_key));

	mn[2] = mn_create(&md3,mn3_items,SIZETAB(mn3_items));
	mn_settitle(mn[2],"THREE",BOTTOMLEFTTITLE);
	mn_keys (mn[2],mn_key,SIZETAB(mn_key));

	cnt = 0;
	do
		{
		done = mn_rdmenu(mn[cnt],&ch,&sc);
		if (done == MN_NOSELECT)
			{
			if (ch == KB_CH_N_ESC && sc == KB_SC_N_ESC)
				break;
			else 	if (ch == KB_CH_N_LEFT && sc == KB_SC_N_LEFT)
				{
				if (cnt > 0)
					cnt--;
				else
					cnt = SIZETAB(mn)-1;
				}
			else 	if (ch == KB_CH_N_RIGHT && sc == KB_SC_N_RIGHT)
				{
				if (cnt < SIZETAB(mn)-1)
					cnt++;
				else
					cnt = 0;
				}
			}
		}
	while (1);

	mn[0] = mn_destroy(mn[0]);
	mn[1] = mn_destroy(mn[1]);
	mn[2] = mn_destroy(mn[2]);

	wn_exit();
}


/*---------------------------------------------------------------------------


*/
int select_files (FNAMETAB *ftab, int size)
{
static MENUDEF mnseldef = {
	4,4,20,21,			/* Outer coordinates        */
	RED,LIGHTGRAY,		/* Menu attribute           */
	' ',					/* back ground fill char    */
	RED,LIGHTGRAY,		/* Normal bar attribute     */
	BLUE,LIGHTGREEN,	/* Highlight bar attribute  */
	RED,WHITE,			/* Highlight char attribute */
	SET,					/* If frame                 */
	DDDDFrame,			/* Frame characters         */
	BLUE,LIGHTGRAY		/* Frame attribute          */
	};
static KEYDEF mnsel_key[] = {
	{ KB_CH_N_PAD_PLUS, KB_SC_N_PAD_PLUS,  0, MN_NOMOVE, MN_TRANSMIT },
	{ KB_CH_N_PAD_MINUS,KB_SC_N_PAD_MINUS, 0, MN_NOMOVE, MN_TRANSMIT },
	{ KB_CH_N_PGDN,     KB_SC_N_PGDN,      0, MN_NOMOVE, MN_TRANSMIT },
	{ KB_CH_N_PGUP,     KB_SC_N_PGUP,      0, MN_NOMOVE, MN_TRANSMIT }
	};

MENUTYPE mnsel;
ITEM mnsel_items[16];
int last_item=SIZETAB(mnsel_items);
int pages=1;
int page_num=1;
int i,ch,sc;
int rcode,idx;

	if (size <= SIZETAB(mnsel_items))
		{
		rcode=last_item =  size;
		}
	else
		{
		pages = size/SIZETAB(mnsel_items);
		if ((last_item=size%SIZETAB(mnsel_items)) != 0)
			pages++;
		else
			last_item=SIZETAB(mnsel_items);
		rcode=SIZETAB(mnsel_items);
		}
	for (i=0; i<SIZETAB(mnsel_items); i++)
		{
		mnsel_items[i].x = 7;
		mnsel_items[i].y = i+1;
		mnsel_items[i].itemstr  = i<rcode ? ftab[i].name : 0;
		mnsel_items[i].itype    = MN_EDITITEM;
		mnsel_items[i].ipos     = DOSFNAME;
		mnsel_items[i].userfunc = 0;
		}

	mnsel = mn_create(&mnseldef,mnsel_items,pages>1?SIZETAB(mnsel_items):last_item);
	mn_settitle(mnsel,"SELECT",TOPCENTERTITLE);
	mn_keys (mnsel,mnsel_key,SIZETAB(mnsel_key));

	for (i=0; i<rcode; i++)
		{
		wn_gotoxy(1,i+1); wn_printf("%4d%c",i,ftab[i].sel ? '*' : ' ');
		}
	do
		{
		rcode = mn_rdmenu(mnsel,&ch,&sc);

		if (rcode == MN_NOSELECT)
			{
			if (ch == KB_CH_N_ESC && sc == KB_SC_N_ESC)
				{
				rcode = -1;
				break;
				}
			}
		else
			{
			if (ch == KB_CH_N_PGDN && sc == KB_SC_N_PGDN)
				{
				if (pages > 1 && page_num < pages)
					{
					mnsel->curpos = 0;
					mnsel->lastitemno =  ++page_num<pages?SIZETAB(mnsel_items):last_item;
					for (i=0; i<mnsel->lastitemno; i++)
						{
						idx = i+(page_num-1)*SIZETAB(mnsel_items);
						wn_gotoxy(1,i+1); wn_printf("%4d%c",idx,ftab[idx].sel ? '*' : ' ');

						mnsel_items[i].itemstr  = ftab[i+(page_num-1)*SIZETAB(mnsel_items)].name;
						}
					for (; i<SIZETAB(mnsel_items); i++)
						{
						wn_gotoxy(1,i+1); wn_clreol();
						}
					}
				}
			else if (ch == KB_CH_N_PGUP && sc == KB_SC_N_PGUP)
				{
				if (pages > 1 && page_num > 1)
					{
					--page_num;
					mnsel->curpos = 0;
					mnsel->lastitemno =  SIZETAB(mnsel_items);
					for (i=0; i<SIZETAB(mnsel_items); i++)
						{
						idx = i+(page_num-1)*SIZETAB(mnsel_items);
						wn_gotoxy(1,i+1); wn_printf("%4d%c",idx,ftab[idx].sel ? '*' : ' ');

						mnsel_items[i].itemstr  = ftab[i+(page_num-1)*SIZETAB(mnsel_items)].name;
						}
					}
				}
			else if (ch == KB_CH_N_PAD_PLUS && sc == KB_SC_N_PAD_PLUS)
				{
				wn_gotoxy(5,rcode); wn_putch('*');
				ftab[rcode-1+(page_num-1)*SIZETAB(mnsel_items)].sel = 1;

				}
			else 	if (ch == KB_CH_N_PAD_MINUS && sc == KB_SC_N_PAD_MINUS)
				{
				wn_gotoxy(5,rcode); wn_putch(' ');
				ftab[rcode-1+(page_num-1)*SIZETAB(mnsel_items)].sel = 0;
				}
			else if (ch == KB_CH_N_ENTER && sc == KB_SC_N_ENTER)
				{
				rcode = 0;
				break;
				}
			}
		}
	while (1);

	mnsel = mn_destroy(mnsel);

return rcode;
}
