/*---------------------------------------------------------------------------
	KEYLIB.H  -- file defining scan codes for keyboard managment.

	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/

#if ! defined (_H_KEYLIB_)
#define _H_KEYLIB_

int kb_ch2sc(int ch);
/*
	Gives scancode for the character ch
*/

unsigned int kb_read (int *ch, int *sc);
/*
	Wait for press key and read scancode & char.
*/

unsigned int kb_hit (int *ch, int *sc);
/*
	Test for press key and read scancode & char.
*/

unsigned int kb_place (int where, int ch, int sc);
/*
	put one keystroke to keyboard buffer
*/

unsigned int kb_flags (void);
/*
	Test for keyboard flags
*/

#endif

