#------------------------------------------------
#
#  C Window & Menu System
#
#  Version 1.0
#
#  (C) Copyright 1991,1992
#  All Rights Reserved
#
#  Andrew Trzeciak
#  PO Box 1521
#  Lombard IL 60148-8521
#
#------------------------------------------------

.AUTODEPEND

.PATH.c   = C
.PATH.asm = ASM
.PATH.obj = OBJ

#------------------------------------------------
# change model here
# 
# put just one first small letter model name (case sensitive)
# 
# <t,s,c,m,l,h>
# 
# 
# 
# 
MODEL = l

# *Implicit Rules*

.c.obj:
  tcc +cwin.cfg -m$(MODEL) -n$(.PATH.obj) $<

.asm.obj:
  tasm /Q /T /ML /D__$(MODEL)__ $<,$(.PATH.obj)\$&

# *List Macros*

LIB_dependencies =  \
  cwin.cfg \
  cwin.mak \
  cwin.rsp \
  keylib.obj \
  menulib.obj \
  strlib.obj \
  utlib.obj \
  winlib.obj \
  bufwrt.obj \
  bufwrtat.obj \
  bufwrtst.obj \
  kbflag.obj \
  kbhit.obj \
  kbplace.obj \
  kbread.obj \
  scrlib.obj \
  wordfill.obj \
  wordmove.obj

# *Explicit Rules*
cwin$(MODEL).lib: $(LIB_dependencies)
  del cwin$(MODEL).lib
  tlib cwin$(MODEL) @cwin.rsp

# *Individual File Dependencies*
strlib.obj:   strlib.c cwin.mak strlib.h
keylib.obj:   keylib.c cwin.mak keylib.h
utlib.obj:    utlib.c  cwin.mak utlib.h
winlib.obj:   winlib.c cwin.mak winlib.h utlib.h scrlib.h
menulib.obj:  menulib.c cwin.mak  menulib.h winlib.h utlib.h keylib.h strlib.h scrlib.h
bufwrt.obj:   bufwrt.asm cwin.mak  
bufwrtat.obj: bufwrtat.asm cwin.mak 
bufwrtst.obj: bufwrtst.asm cwin.mak 
kbflag.obj:   kbflag.asm cwin.mak 
kbhit.obj:    kbhit.asm cwin.mak 
kbplace.obj:  kbplace.asm cwin.mak 
kbread.obj:   kbread.asm cwin.mak 
scrlib.obj:   scrlib.asm cwin.mak scrlib.h 
wordfill.obj: wordfill.asm cwin.mak 
wordmove.obj: wordmove.asm cwin.mak 

# *Library list file
cwin.rsp: cwin.mak
 copy &&|
+ obj\bufwrt.obj &
+ obj\bufwrtat.obj &
+ obj\bufwrtst.obj &
+ obj\kbflag.obj &
+ obj\kbhit.obj &
+ obj\kbplace.obj &
+ obj\kbread.obj &
+ obj\scrlib.obj &
+ obj\wordfill.obj &
+ obj\wordmove.obj &
+ obj\keylib.obj &
+ obj\strlib.obj &
+ obj\utlib.obj &
+ obj\winlib.obj &
+ obj\menulib.obj
| cwin.rsp

# *Compiler Configuration File*
cwin.cfg: cwin.mak
  copy &&|
-c 
-f-
-ff-
-G
-O
-Z
-k-
-rd
-w
-IC:\TC\INCLUDE
| cwin.cfg

