/*---------------------------------------------------------------------------
	UTLIB.C  -- utility function, macros & constans

	Version 1.00 (C)Copyright Andrew Trzeciak. 1993
*/
#include <alloc.h>
#include <stdlib.h>

#include "utlib.h"

#pragma inline

int cwin_error = CW_OKAY;

/*---------------------------------------------------------------------------

*/
void *ut_memalloc (unsigned int size)
{
void *ptr;

	if ((ptr = malloc(size)) == NULL)
		{
		cwin_error = CW_ALLOC_ERR;
		ut_fatalerror ();
		}
return ptr;
}

/*---------------------------------------------------------------------------

*/
void ut_memfree (void *ptr)
{
	if (ptr == NULL)
		{
		cwin_error = CW_FREE_ERR;
		ut_fatalerror ();
		}
	free(ptr);
}

/*---------------------------------------------------------------------------

*/
static void bios_setpos (unsigned char col, unsigned char row)
{
	_DX = (row<<8)+col;
	asm push dx;
	asm mov	ah,0x0F;		/* get video status */
	asm int	0x10;
	asm pop  dx;
	asm mov	ah,0x02;		/* set cursor position */
	asm int	0x10;
}

/*---------------------------------------------------------------------------

*/
static void bios_getpos (unsigned char *col, unsigned char *row)
{
	asm push bp;
	asm mov	ah,0x0F;		/* get video status */
	asm int	0x10;
	asm mov	ah,0x02;		/* set cursor position */
	asm int	0x10;
	asm pop  bp;
	asm mov  al,dl;
	*col = _AL;
	asm mov  al,dh;
	*row = _AL;
}

/*---------------------------------------------------------------------------

*/
static void bios_wrtch (char c)
{
	asm mov  al,c;
	asm push ax;
	asm mov	ah,0x0F;		/* get video status */
	asm int	0x10;
	asm pop  ax;
	asm mov  ah,0x09;
   asm mov  bl,0x07;
	asm mov  cx,1;
	asm int  0x10;
}

/*---------------------------------------------------------------------------

*/
static void bios_wrtstr (char *str)
{
unsigned char col, row;

	while (*str)
		{
		bios_wrtch(*str++);
		bios_getpos(&col, &row);
		if (++col > 79)
			{
			col = 0;
			if (++row > 25)
				row = 0;
			}
		bios_setpos(col, row);
		}
}


/*---------------------------------------------------------------------------

*/
void ut_fatalerror (void)
{
static const char bin2hex[] = {"0123456789ABCDEF"};
char *ptr;

	if (cwin_error == CW_OKAY)
		return;

	switch (cwin_error)
		{
		case CW_OPEN_ERR:
			ptr = "FILE OPEN";
			break;
		case CW_READ_ERR:
			ptr = "READ FILE";
			break;
		case CW_WRITE_ERR:
			ptr = "WRITE FILE";
			break;
		case CW_DISKFULL_ERR:
			ptr = "DISK FULL";
			break;
		case CW_ALLOC_ERR:
			ptr = "ALLOCATION MEMORY";
			break;
		case CW_FREE_ERR:
			ptr = "FREE MEMORY";
			break;
		case CW_WINHANDLE_ERR:
			ptr = "INVALID WINDOW HANDLE";
			break;
		case CW_MENUHANDLE_ERR:
			ptr = "INVALID MENU HANDLE";
			break;
		default:
			ptr = "CODE (XXXXh) UNKNOWN";
			*(ptr+6) = bin2hex[((unsigned)cwin_error>>12) & 0x0F];
			*(ptr+7) = bin2hex[((unsigned)cwin_error>>8 ) & 0x0F];
			*(ptr+8) = bin2hex[((unsigned)cwin_error>>4 ) & 0x0F];
			*(ptr+9) = bin2hex[((unsigned)cwin_error	  ) & 0x0F];
			break;
		}

	bios_setpos(0,0);
	bios_wrtstr(ptr);
	bios_wrtstr(" ERROR");

exit(cwin_error);
}
