/*---------------------------------------------------------------------------
	BIOSKEYS.H  -- file defining scan codes for keyboard managment.

	The key names that follow are made of components:

	Example:

	The character code for shift-down-arrow is:

		KB_CH_N_DOWN
		KB_SC_S_DOWN
		KB_CH_C_DOWN
		KB_SC_A_DOWN
		^  ^  ^ ^
		|  |  | |
		|  |  | +----- Key name.
		|  |  | 
		|  |  +----------- Can be : N  for normal.
		|  |                        S  for shifted.
		|  |                        C  for control.
		|  |                        A  for alt.
		|  |
		|  +-------------- CH  for char code (int constants).
		|                  SC  for scan code (int constants).
		|
		+------------------ This is a keyboard definition.
	or
		KB_N_DOWN
		KB_S_DOWN
		KB_C_DOWN
		KB_A_DOWN
		^  ^ ^
		|  | |
		|  | +-------- Key name.
		|  | 
		|  +--------------- Can be : N  for normal.
		|                            S  for shifted.
		|                            C  for control.
		|                            A  for alt.
		|
		+------------------ This is a keyboard definition.


	Version 1.0

	(C) Copyright 1992
	All Rights Reserved

	Andrew Trzeciak
	PO Box 1521
	Lombard IL 60148-8521
*/

#if ! defined (_H_BIOSKEYS_)
#define _H_BIOSKEYS_

/*===========================================================================
	function keys
*/
#define KB_SC_N_F1           0x3B
#define KB_CH_N_F1              0
#define KB_N_F1              0x3B00
#define KB_SC_S_F1           0x54
#define KB_CH_S_F1              0
#define KB_S_F1              0x5400
#define KB_SC_C_F1           0x5E
#define KB_CH_C_F1              0
#define KB_C_F1              0x5E00
#define KB_SC_A_F1           0x68
#define KB_CH_A_F1              0
#define KB_A_F1              0x6800

#define KB_SC_N_F2           0x3C
#define KB_CH_N_F2              0
#define KB_N_F2              0x3C00
#define KB_SC_S_F2           0x55
#define KB_CH_S_F2              0
#define KB_S_F2              0x5500
#define KB_SC_C_F2           0x5F
#define KB_CH_C_F2              0
#define KB_C_F2              0x5F00
#define KB_SC_A_F2           0x69
#define KB_CH_A_F2              0
#define KB_A_F2              0x6900

#define KB_SC_N_F3           0x3D
#define KB_CH_N_F3              0
#define KB_N_F3              0x3D00
#define KB_SC_S_F3           0x56
#define KB_CH_S_F3              0
#define KB_S_F3              0x5600
#define KB_SC_C_F3           0x60
#define KB_CH_C_F3              0
#define KB_C_F3              0x6000
#define KB_SC_A_F3           0x6A
#define KB_CH_A_F3              0
#define KB_A_F3              0x6A00

#define KB_SC_N_F4           0x3E
#define KB_CH_N_F4              0
#define KB_N_F4              0x3E00
#define KB_SC_S_F4           0x57
#define KB_CH_S_F4              0
#define KB_S_F4              0x5700
#define KB_SC_C_F4           0x61
#define KB_CH_C_F4              0
#define KB_C_F4              0x6100
#define KB_SC_A_F4           0x6B
#define KB_CH_A_F4              0
#define KB_A_F4              0x6B00

#define KB_SC_N_F5           0x3F
#define KB_CH_N_F5              0
#define KB_N_F5              0x3F00
#define KB_SC_S_F5           0x58
#define KB_CH_S_F5              0
#define KB_S_F5              0x5800
#define KB_SC_C_F5           0x62
#define KB_CH_C_F5              0
#define KB_C_F5              0x6200
#define KB_SC_A_F5           0x6C
#define KB_CH_A_F5              0
#define KB_A_F5              0x6C00

#define KB_SC_N_F6           0x40
#define KB_CH_N_F6              0
#define KB_N_F6              0x4000
#define KB_SC_S_F6           0x59
#define KB_CH_S_F6              0
#define KB_S_F6              0x5900
#define KB_SC_C_F6           0x63
#define KB_CH_C_F6              0
#define KB_C_F6              0x6300
#define KB_SC_A_F6           0x6D
#define KB_CH_A_F6              0
#define KB_A_F6              0x6D00

#define KB_SC_N_F7           0x41
#define KB_CH_N_F7              0
#define KB_N_F7              0x4100
#define KB_SC_S_F7           0x5A
#define KB_CH_S_F7              0
#define KB_S_F7              0x5A00
#define KB_SC_C_F7           0x64
#define KB_CH_C_F7              0
#define KB_C_F7              0x6400
#define KB_SC_A_F7           0x6E
#define KB_CH_A_F7              0
#define KB_A_F7              0x6E00

#define KB_SC_N_F8           0x42
#define KB_CH_N_F8              0
#define KB_N_F8              0x4200
#define KB_SC_S_F8           0x5B
#define KB_CH_S_F8              0
#define KB_S_F8              0x5B00
#define KB_SC_C_F8           0x65
#define KB_CH_C_F8              0
#define KB_C_F8              0x6500
#define KB_SC_A_F8           0x6F
#define KB_CH_A_F8              0
#define KB_A_F8              0x6F00

#define KB_SC_N_F9           0x43
#define KB_CH_N_F9              0
#define KB_N_F9              0x4300
#define KB_SC_S_F9           0x5C
#define KB_CH_S_F9              0
#define KB_S_F9              0x5C00
#define KB_SC_C_F9           0x66
#define KB_CH_C_F9              0
#define KB_C_F9              0x6600
#define KB_SC_A_F9           0x70
#define KB_CH_A_F9              0
#define KB_A_F9              0x7000

#define KB_SC_N_F10          0x44
#define KB_CH_N_F10             0
#define KB_N_F10             0x4400
#define KB_SC_S_F10          0x5D
#define KB_CH_S_F10             0
#define KB_S_F10             0x5D00
#define KB_SC_C_F10          0x67
#define KB_CH_C_F10             0
#define KB_C_F10             0x6700
#define KB_SC_A_F10          0x71
#define KB_CH_A_F10             0
#define KB_A_F10             0x7100

#define KB_SC_N_F11          0x85
#define KB_CH_N_F11             0
#define KB_N_F11             0x8500
#define KB_SC_S_F11          0x87
#define KB_CH_S_F11             0
#define KB_S_F11             0x8700
#define KB_SC_C_F11          0x89
#define KB_CH_C_F11             0
#define KB_C_F11             0x8900
#define KB_SC_A_F11          0x8B
#define KB_CH_A_F11             0
#define KB_A_F11             0x8B00

#define KB_SC_N_F12          0x86
#define KB_CH_N_F12             0
#define KB_N_F12             0x8600
#define KB_SC_S_F12          0x88
#define KB_CH_S_F12             0
#define KB_S_F12             0x8800
#define KB_SC_C_F12          0x8A
#define KB_CH_C_F12             0
#define KB_C_F12             0x8A00
#define KB_SC_A_F12          0x8C
#define KB_CH_A_F12             0
#define KB_A_F12             0x8C00


/*===========================================================================

*/
#define KB_SC_N_BACKSPACE    0x0E
#define KB_CH_N_BACKSPACE    0x08
#define KB_N_BACKSPACE       0x0E08
#define KB_SC_S_BACKSPACE    0x0E
#define KB_CH_S_BACKSPACE    0x08
#define KB_S_BACKSPACE       0x0E08
#define KB_SC_C_BACKSPACE    0x0E
#define KB_CH_C_BACKSPACE    0x7F
#define KB_C_BACKSPACE       0x0E7F
#define KB_SC_A_BACKSPACE    0x0E
#define KB_CH_A_BACKSPACE       0
#define KB_A_BACKSPACE       0x0E00

#define KB_SC_N_TAB          0x0F
#define KB_CH_N_TAB          0x09
#define KB_N_TAB             0x0F09
#define KB_SC_S_TAB          0x0F
#define KB_CH_S_TAB             0
#define KB_S_TAB             0x0F00
#define KB_SC_C_TAB          0x94
#define KB_CH_C_TAB             0
#define KB_C_TAB             0x9400
#define KB_SC_A_TAB          0xA5
#define KB_CH_A_TAB             0
#define KB_A_TAB             0xA500

#define KB_SC_N_ENTER        0x1C
#define KB_CH_N_ENTER        0x0D
#define KB_N_ENTER           0x1C0D
#define KB_SC_S_ENTER        0x1C
#define KB_CH_S_ENTER        0x0D
#define KB_S_ENTER           0x1C0D
#define KB_SC_C_ENTER        0x1C
#define KB_CH_C_ENTER        0x0A
#define KB_C_ENTER           0x1C0A
#define KB_SC_A_ENTER        0x1C
#define KB_CH_A_ENTER           0
#define KB_A_ENTER           0x1C00

#define KB_SC_N_ESC          0x01
#define KB_CH_N_ESC          0x1B
#define KB_N_ESC             0x011B
#define KB_SC_S_ESC          0x01
#define KB_CH_S_ESC          0x1B
#define KB_S_ESC             0x011B
#define KB_SC_C_ESC          0x01
#define KB_CH_C_ESC          0x1B
#define KB_C_ESC             0x011B
#define KB_SC_A_ESC          0x01
#define KB_CH_A_ESC             0
#define KB_A_ESC             0x0100

#define KB_SC_N_SPACE        0x39
#define KB_CH_N_SPACE        0x20
#define KB_N_SPACE           0x3920
#define KB_SC_S_SPACE        0x39
#define KB_CH_S_SPACE        0x20
#define KB_S_SPACE           0x3920
#define KB_SC_C_SPACE        0x39
#define KB_CH_C_SPACE        0x20
#define KB_C_SPACE           0x3920
#define KB_SC_A_SPACE        0x39
#define KB_CH_A_SPACE        0x20
#define KB_A_SPACE           0x3920

#define KB_SC_N_QUOTE        0x28
#define KB_CH_N_QUOTE        0x27
#define KB_N_QUOTE           0x2827
#define KB_SC_S_QUOTE        0x28
#define KB_CH_S_QUOTE        0x22
#define KB_S_QUOTE           0x2822
#define KB_SC_A_QUOTE        0x28
#define KB_CH_A_QUOTE           0
#define KB_A_QUOTE           0x2800

#define KB_SC_N_COMMA        0x33
#define KB_CH_N_COMMA        0x2C
#define KB_N_COMMA           0x332C
#define KB_SC_S_COMMA        0x33
#define KB_CH_S_COMMA        0x3C
#define KB_S_COMMA           0x333C
#define KB_SC_A_COMMA        0x33
#define KB_CH_A_COMMA           0
#define KB_A_COMMA           0x3300

#define KB_SC_N_MINUS        0x0C
#define KB_CH_N_MINUS        0x2D
#define KB_N_MINUS           0x0C2D
#define KB_SC_S_MINUS        0x0C
#define KB_CH_S_MINUS        0x5F
#define KB_S_MINUS           0x0C5F
#define KB_SC_C_MINUS        0x0C
#define KB_CH_C_MINUS        0x1F
#define KB_C_MINUS           0x0C1F
#define KB_SC_A_MINUS        0x82
#define KB_CH_A_MINUS           0
#define KB_A_MINUS           0x8200

#define KB_SC_N_PERIOD       0x34
#define KB_CH_N_PERIOD       0x2E
#define KB_N_PERIOD          0x342E
#define KB_SC_S_PERIOD       0x34
#define KB_CH_S_PERIOD       0x3E
#define KB_S_PERIOD          0x343E
#define KB_SC_A_PERIOD       0x34
#define KB_CH_A_PERIOD          0
#define KB_A_PERIOD          0x3400

#define KB_SC_N_SLASH        0x35
#define KB_CH_N_SLASH        0x2F
#define KB_N_SLASH           0x352F
#define KB_SC_S_SLASH        0x35
#define KB_CH_S_SLASH        0x3F
#define KB_S_SLASH           0x353F
#define KB_SC_A_SLASH        0x35
#define KB_CH_A_SLASH           0
#define KB_A_SLASH           0x3500

#define KB_SC_N_SEMI         0x27
#define KB_CH_N_SEMI         0x3B
#define KB_N_SEMI            0x273B
#define KB_SC_S_SEMI         0x27
#define KB_CH_S_SEMI         0x3A
#define KB_S_SEMI            0x273A
#define KB_SC_A_SEMI         0x27
#define KB_CH_A_SEMI            0
#define KB_A_SEMI            0x2700

#define KB_SC_N_EQUALS       0x0D
#define KB_CH_N_EQUALS       0x3D
#define KB_N_EQUALS          0x0D3D
#define KB_SC_S_EQUALS       0x0D
#define KB_CH_S_EQUALS       0x2B
#define KB_S_EQUALS          0x0D2B
#define KB_SC_A_EQUALS       0x83
#define KB_CH_A_EQUALS          0
#define KB_A_EQUALS          0x8300

#define KB_SC_N_LBRACKET     0x1A
#define KB_CH_N_LBRACKET     0x5B
#define KB_N_LBRACKET        0x1A5B
#define KB_SC_S_LBRACKET     0x1A
#define KB_CH_S_LBRACKET     0x7B
#define KB_S_LBRACKET        0x1A7B
#define KB_SC_C_LBRACKET     0x1A
#define KB_CH_C_LBRACKET     0x1B
#define KB_C_LBRACKET        0x1A1B
#define KB_SC_A_LBRACKET     0x1A
#define KB_CH_A_LBRACKET        0
#define KB_A_LBRACKET        0x1A00

#define KB_SC_N_BACKSLASH    0x2B
#define KB_CH_N_BACKSLASH    0x5C
#define KB_N_BACKSLASH       0x2B5C
#define KB_SC_S_BACKSLASH    0x2B
#define KB_CH_S_BACKSLASH    0x7C
#define KB_S_BACKSLASH       0x2B7C
#define KB_SC_C_BACKSLASH    0x2B
#define KB_CH_C_BACKSLASH    0x1C
#define KB_C_BACKSLASH       0x2B1C
#define KB_SC_A_BACKSLASH    0x2B
#define KB_CH_A_BACKSLASH       0
#define KB_A_BACKSLASH       0x2B00

#define KB_SC_N_RBRACKET     0x1B
#define KB_CH_N_RBRACKET     0x5D
#define KB_N_RBRACKET        0x1B5D
#define KB_SC_S_RBRACKET     0x1B
#define KB_CH_S_RBRACKET     0x7D
#define KB_S_RBRACKET        0x1B7D
#define KB_SC_C_RBRACKET     0x1B
#define KB_CH_C_RBRACKET     0x1D
#define KB_C_RBRACKET        0x1B1D
#define KB_SC_A_RBRACKET     0x1B
#define KB_CH_A_RBRACKET        0
#define KB_A_RBRACKET        0x1B00

#define KB_SC_N_BACKQUOTE    0x29
#define KB_CH_N_BACKQUOTE    0x60
#define KB_N_BACKQUOTE       0x2960
#define KB_SC_S_BACKQUOTE    0x29
#define KB_CH_S_BACKQUOTE    0x7E
#define KB_S_BACKQUOTE       0x297E
#define KB_SC_A_BACKQUOTE    0x29
#define KB_CH_A_BACKQUOTE       0
#define KB_A_BACKQUOTE       0x2900

/*===========================================================================

*/
#define KB_SC_N_0            0x0B
#define KB_CH_N_0            0x30
#define KB_N_0               0x0B30
#define KB_SC_S_0            0x0B
#define KB_CH_S_0            0x29
#define KB_S_0               0x0B29
#define KB_SC_A_0            0x81
#define KB_CH_A_0               0
#define KB_A_0               0x8100

#define KB_SC_N_1            0x02
#define KB_CH_N_1            0x31
#define KB_N_1               0x0231
#define KB_SC_S_1            0x02
#define KB_CH_S_1            0x21
#define KB_S_1               0x0221
#define KB_SC_A_1            0x78
#define KB_CH_A_1               0
#define KB_A_1               0x7800

#define KB_SC_N_2            0x03
#define KB_CH_N_2            0x32
#define KB_N_2               0x0332
#define KB_SC_S_2            0x03
#define KB_CH_S_2            0x40
#define KB_S_2               0x0340
#define KB_SC_C_2            0x03
#define KB_CH_C_2               0
#define KB_C_2               0x0300
#define KB_SC_A_2            0x79
#define KB_CH_A_2               0
#define KB_A_2               0x7900

#define KB_SC_N_3            0x04
#define KB_CH_N_3            0x33
#define KB_N_3               0x0433
#define KB_SC_S_3            0x04
#define KB_CH_S_3            0x23
#define KB_S_3               0x0423
#define KB_SC_A_3            0x7A
#define KB_CH_A_3               0
#define KB_A_3               0x7A00

#define KB_SC_N_4            0x05
#define KB_CH_N_4            0x34
#define KB_N_4               0x0534
#define KB_SC_S_4            0x05
#define KB_CH_S_4            0x24
#define KB_S_4               0x0524
#define KB_SC_A_4            0x7B
#define KB_CH_A_4               0
#define KB_A_4               0x7B00

#define KB_SC_N_5            0x06
#define KB_CH_N_5            0x35
#define KB_N_5               0x0635
#define KB_SC_S_5            0x06
#define KB_CH_S_5            0x25
#define KB_S_5               0x0625
#define KB_SC_A_5            0x7C
#define KB_CH_A_5               0
#define KB_A_5               0x7C00

#define KB_SC_N_6            0x07
#define KB_CH_N_6            0x36
#define KB_N_6               0x0736
#define KB_SC_S_6            0x07
#define KB_CH_S_6            0x5E
#define KB_S_6               0x075E
#define KB_SC_C_6            0x07
#define KB_CH_C_6            0x1E
#define KB_C_6               0x071E
#define KB_SC_A_6            0x7D
#define KB_CH_A_6               0
#define KB_A_6               0x7D00

#define KB_SC_N_7            0x08
#define KB_CH_N_7            0x37
#define KB_N_7               0x0837
#define KB_SC_S_7            0x08
#define KB_CH_S_7            0x26
#define KB_S_7               0x0826
#define KB_SC_A_7            0x7E
#define KB_CH_A_7               0
#define KB_A_7               0x7E00

#define KB_SC_N_8            0x09
#define KB_CH_N_8            0x38
#define KB_N_8               0x0938
#define KB_SC_S_8            0x09
#define KB_CH_S_8            0x2A
#define KB_S_8               0x092A
#define KB_SC_A_8            0x7F
#define KB_CH_A_8               0
#define KB_A_8               0x7F00

#define KB_SC_N_9            0x0A
#define KB_CH_N_9            0x39
#define KB_N_9               0x0A39
#define KB_SC_S_9            0x0A
#define KB_CH_S_9            0x28
#define KB_S_9               0x0A28
#define KB_SC_A_9            0x80
#define KB_CH_A_9               0
#define KB_A_9               0x8000

/*===========================================================================

*/
#define KB_SC_N_A            0x1E
#define KB_CH_N_A            0x61
#define KB_N_A               0x1E61
#define KB_SC_S_A            0x1E
#define KB_CH_S_A            0x41
#define KB_S_A               0x1E41
#define KB_SC_C_A            0x1E
#define KB_CH_C_A            0x01
#define KB_C_A               0x1E01
#define KB_SC_A_A            0x1E
#define KB_CH_A_A               0
#define KB_A_A               0x1E00

#define KB_SC_N_B            0x30
#define KB_CH_N_B            0x62
#define KB_N_B               0x3062
#define KB_SC_S_B            0x30
#define KB_CH_S_B            0x42
#define KB_S_B               0x3042
#define KB_SC_C_B            0x30
#define KB_CH_C_B            0x02
#define KB_C_B               0x3002
#define KB_SC_A_B            0x30
#define KB_CH_A_B               0
#define KB_A_B               0x3000

#define KB_SC_N_C            0x2E
#define KB_CH_N_C            0x63
#define KB_N_C               0x2E63
#define KB_SC_S_C            0x2E
#define KB_CH_S_C            0x43
#define KB_S_C               0x2E43
#define KB_SC_C_C            0x2E
#define KB_CH_C_C            0x03
#define KB_C_C               0x2E03
#define KB_SC_A_C            0x2E
#define KB_CH_A_C               0
#define KB_A_C               0x2E00

#define KB_SC_N_D            0x20
#define KB_CH_N_D            0x64
#define KB_N_D               0x2064
#define KB_SC_S_D            0x20
#define KB_CH_S_D            0x44
#define KB_S_D               0x2044
#define KB_SC_C_D            0x20
#define KB_CH_C_D            0x04
#define KB_C_D               0x2004
#define KB_SC_A_D            0x20
#define KB_CH_A_D               0
#define KB_A_D               0x2000

#define KB_SC_N_E            0x12
#define KB_CH_N_E            0x65
#define KB_N_E               0x1265
#define KB_SC_S_E            0x12
#define KB_CH_S_E            0x45
#define KB_S_E               0x1245
#define KB_SC_C_E            0x12
#define KB_CH_C_E            0x05
#define KB_C_E               0x1205
#define KB_SC_A_E            0x12
#define KB_CH_A_E               0
#define KB_A_E               0x1200

#define KB_SC_N_F            0x21
#define KB_CH_N_F            0x66
#define KB_N_F               0x2166
#define KB_SC_S_F            0x21
#define KB_CH_S_F            0x46
#define KB_S_F               0x2146
#define KB_SC_C_F            0x21
#define KB_CH_C_F            0x06
#define KB_C_F               0x2106
#define KB_SC_A_F            0x21
#define KB_CH_A_F               0
#define KB_A_F               0x2100

#define KB_SC_N_G            0x22
#define KB_CH_N_G            0x67
#define KB_N_G               0x2267
#define KB_SC_S_G            0x22
#define KB_CH_S_G            0x47
#define KB_S_G               0x2247
#define KB_SC_C_G            0x22
#define KB_CH_C_G            0x07
#define KB_C_G               0x2207
#define KB_SC_A_G            0x22
#define KB_CH_A_G               0
#define KB_A_G               0x2200

#define KB_SC_N_H            0x23
#define KB_CH_N_H            0x68
#define KB_N_H               0x2368
#define KB_SC_S_H            0x23
#define KB_CH_S_H            0x48
#define KB_S_H               0x2348
#define KB_SC_C_H            0x23
#define KB_CH_C_H            0x08
#define KB_C_H               0x2308
#define KB_SC_A_H            0x23
#define KB_CH_A_H               0
#define KB_A_H               0x2300

#define KB_SC_N_I            0x17
#define KB_CH_N_I            0x69
#define KB_N_I               0x1769
#define KB_SC_S_I            0x17
#define KB_CH_S_I            0x49
#define KB_S_I               0x1749
#define KB_SC_C_I            0x17
#define KB_CH_C_I            0x09
#define KB_C_I               0x1709
#define KB_SC_A_I            0x17
#define KB_CH_A_I               0
#define KB_A_I               0x1700

#define KB_SC_N_J            0x24
#define KB_CH_N_J            0x6A
#define KB_N_J               0x246A
#define KB_SC_S_J            0x24
#define KB_CH_S_J            0x4A
#define KB_S_J               0x244A
#define KB_SC_C_J            0x24
#define KB_CH_C_J            0x0A
#define KB_C_J               0x240A
#define KB_SC_A_J            0x24
#define KB_CH_A_J               0
#define KB_A_J               0x2400

#define KB_SC_N_K            0x25
#define KB_CH_N_K            0x6B
#define KB_N_K               0x256B
#define KB_SC_S_K            0x25
#define KB_CH_S_K            0x4B
#define KB_S_K               0x254B
#define KB_SC_C_K            0x25
#define KB_CH_C_K            0x0B
#define KB_C_K               0x250B
#define KB_SC_A_K            0x25
#define KB_CH_A_K               0
#define KB_A_K               0x2500

#define KB_SC_N_L            0x26
#define KB_CH_N_L            0x6C
#define KB_N_L               0x266C
#define KB_SC_S_L            0x26
#define KB_CH_S_L            0x4C
#define KB_S_L               0x264C
#define KB_SC_C_L            0x26
#define KB_CH_C_L            0x0C
#define KB_C_L               0x260C
#define KB_SC_A_L            0x26
#define KB_CH_A_L               0
#define KB_A_L               0x2600

#define KB_SC_N_M            0x32
#define KB_CH_N_M            0x6D
#define KB_N_M               0x326D
#define KB_SC_S_M            0x32
#define KB_CH_S_M            0x4D
#define KB_S_M               0x324D
#define KB_SC_C_M            0x32
#define KB_CH_C_M            0x0D
#define KB_C_M               0x320D
#define KB_SC_A_M            0x32
#define KB_CH_A_M               0
#define KB_A_M               0x3200

#define KB_SC_N_N            0x31
#define KB_CH_N_N            0x6E
#define KB_N_N               0x316E
#define KB_SC_S_N            0x31
#define KB_CH_S_N            0x4E
#define KB_S_N               0x314E
#define KB_SC_C_N            0x31
#define KB_CH_C_N            0x0E
#define KB_C_N               0x310E
#define KB_SC_A_N            0x31
#define KB_CH_A_N               0
#define KB_A_N               0x3100

#define KB_SC_N_O            0x18
#define KB_CH_N_O            0x6F
#define KB_N_O               0x186F
#define KB_SC_S_O            0x18
#define KB_CH_S_O            0x4F
#define KB_S_O               0x184F
#define KB_SC_C_O            0x18
#define KB_CH_C_O            0x0F
#define KB_C_O               0x180F
#define KB_SC_A_O            0x18
#define KB_CH_A_O               0
#define KB_A_O               0x1800

#define KB_SC_N_P            0x19
#define KB_CH_N_P            0x70
#define KB_N_P               0x1970
#define KB_SC_S_P            0x19
#define KB_CH_S_P            0x50
#define KB_S_P               0x1950
#define KB_SC_C_P            0x19
#define KB_CH_C_P            0x10
#define KB_C_P               0x1910
#define KB_SC_A_P            0x19
#define KB_CH_A_P               0
#define KB_A_P               0x1900

#define KB_SC_N_Q            0x10
#define KB_CH_N_Q            0x71
#define KB_N_Q               0x1071
#define KB_SC_S_Q            0x10
#define KB_CH_S_Q            0x51
#define KB_S_Q               0x1051
#define KB_SC_C_Q            0x10
#define KB_CH_C_Q            0x11
#define KB_C_Q               0x1011
#define KB_SC_A_Q            0x10
#define KB_CH_A_Q               0
#define KB_A_Q               0x1000

#define KB_SC_N_R            0x13
#define KB_CH_N_R            0x72
#define KB_N_R               0x1372
#define KB_SC_S_R            0x13
#define KB_CH_S_R            0x52
#define KB_S_R               0x1352
#define KB_SC_C_R            0x13
#define KB_CH_C_R            0x12
#define KB_C_R               0x1312
#define KB_SC_A_R            0x13
#define KB_CH_A_R               0
#define KB_A_R               0x1300

#define KB_SC_N_S            0x1F
#define KB_CH_N_S            0x73
#define KB_N_S               0x1F73
#define KB_SC_S_S            0x1F
#define KB_CH_S_S            0x53
#define KB_S_S               0x1F53
#define KB_SC_C_S            0x1F
#define KB_CH_C_S            0x13
#define KB_C_S               0x1F13
#define KB_SC_A_S            0x1F
#define KB_CH_A_S               0
#define KB_A_S               0x1F00

#define KB_SC_N_T            0x14
#define KB_CH_N_T            0x74
#define KB_N_T               0x1474
#define KB_SC_S_T            0x14
#define KB_CH_S_T            0x54
#define KB_S_T               0x1454
#define KB_SC_C_T            0x14
#define KB_CH_C_T            0x14
#define KB_C_T               0x1414
#define KB_SC_A_T            0x14
#define KB_CH_A_T               0
#define KB_A_T               0x1400

#define KB_SC_N_U            0x16
#define KB_CH_N_U            0x75
#define KB_N_U               0x1675
#define KB_SC_S_U            0x16
#define KB_CH_S_U            0x55
#define KB_S_U               0x1655
#define KB_SC_C_U            0x16
#define KB_CH_C_U            0x15
#define KB_C_U               0x1615
#define KB_SC_A_U            0x16
#define KB_CH_A_U               0
#define KB_A_U               0x1600

#define KB_SC_N_V            0x2F
#define KB_CH_N_V            0x76
#define KB_N_V               0x2F76
#define KB_SC_S_V            0x2F
#define KB_CH_S_V            0x56
#define KB_S_V               0x2F56
#define KB_SC_C_V            0x2F
#define KB_CH_C_V            0x16
#define KB_C_V               0x2F16
#define KB_SC_A_V            0x2F
#define KB_CH_A_V               0
#define KB_A_V               0x2F00

#define KB_SC_N_W            0x11
#define KB_CH_N_W            0x77
#define KB_N_W               0x1177
#define KB_SC_S_W            0x11
#define KB_CH_S_W            0x57
#define KB_S_W               0x1157
#define KB_SC_C_W            0x11
#define KB_CH_C_W            0x17
#define KB_C_W               0x1117
#define KB_SC_A_W            0x11
#define KB_CH_A_W               0
#define KB_A_W               0x1100

#define KB_SC_N_X            0x2D
#define KB_CH_N_X            0x78
#define KB_N_X               0x2D78
#define KB_SC_S_X            0x2D
#define KB_CH_S_X            0x58
#define KB_S_X               0x2D58
#define KB_SC_C_X            0x2D
#define KB_CH_C_X            0x18
#define KB_C_X               0x2D18
#define KB_SC_A_X            0x2D
#define KB_CH_A_X               0
#define KB_A_X               0x2D00

#define KB_SC_N_Y            0x15
#define KB_CH_N_Y            0x79
#define KB_N_Y               0x1579
#define KB_SC_S_Y            0x15
#define KB_CH_S_Y            0x59
#define KB_S_Y               0x1559
#define KB_SC_C_Y            0x15
#define KB_CH_C_Y            0x19
#define KB_C_Y               0x1519
#define KB_SC_A_Y            0x15
#define KB_CH_A_Y               0
#define KB_A_Y               0x1500

#define KB_SC_N_Z            0x2C
#define KB_CH_N_Z            0x7A
#define KB_N_Z               0x2C7A
#define KB_SC_S_Z            0x2C
#define KB_CH_S_Z            0x5A
#define KB_S_Z               0x2C5A
#define KB_SC_C_Z            0x2C
#define KB_CH_C_Z            0x1A
#define KB_C_Z               0x2C1A
#define KB_SC_A_Z            0x2C
#define KB_CH_A_Z               0
#define KB_A_Z               0x2C00


/*===========================================================================
	pad keys
*/
#define KB_SC_N_UP           0x48
#define KB_CH_N_UP              0
#define KB_N_UP              0x4800
#define KB_SC_S_UP           0x48
#define KB_CH_S_UP           0x38
#define KB_S_UP              0x4838
#define KB_SC_C_UP           0x8D
#define KB_CH_C_UP              0
#define KB_C_UP              0x8D00

#define KB_SC_N_DOWN         0x50
#define KB_CH_N_DOWN            0
#define KB_N_DOWN            0x5000
#define KB_SC_S_DOWN         0x50
#define KB_CH_S_DOWN         0x32
#define KB_S_DOWN            0x5032
#define KB_SC_C_DOWN         0x91
#define KB_CH_C_DOWN            0
#define KB_C_DOWN            0x9100

#define KB_SC_N_LEFT         0x4B
#define KB_CH_N_LEFT            0
#define KB_N_LEFT            0x4B00
#define KB_SC_S_LEFT         0x4B
#define KB_CH_S_LEFT         0x34
#define KB_S_LEFT            0x4B34
#define KB_SC_C_LEFT         0x73
#define KB_CH_C_LEFT            0
#define KB_C_LEFT            0x7300

#define KB_SC_N_RIGHT        0x4D
#define KB_CH_N_RIGHT           0
#define KB_N_RIGHT           0x4D00
#define KB_SC_S_RIGHT        0x4D
#define KB_CH_S_RIGHT        0x36
#define KB_S_RIGHT           0x4D36
#define KB_SC_C_RIGHT        0x74
#define KB_CH_C_RIGHT           0
#define KB_C_RIGHT           0x7400

#define KB_SC_N_PGUP         0x49
#define KB_CH_N_PGUP            0
#define KB_N_PGUP            0x4900
#define KB_SC_S_PGUP         0x49
#define KB_CH_S_PGUP         0x39
#define KB_S_PGUP            0x4939
#define KB_SC_C_PGUP         0x84
#define KB_CH_C_PGUP            0
#define KB_C_PGUP            0x8400

#define KB_SC_N_PGDN         0x51
#define KB_CH_N_PGDN            0
#define KB_N_PGDN            0x5100
#define KB_SC_S_PGDN         0x51
#define KB_CH_S_PGDN         0x33
#define KB_S_PGDN            0x5133
#define KB_SC_C_PGDN         0x76
#define KB_CH_C_PGDN            0
#define KB_C_PGDN            0x7600

#define KB_SC_N_HOME         0x47
#define KB_CH_N_HOME            0
#define KB_N_HOME            0x4700
#define KB_SC_S_HOME         0x47
#define KB_CH_S_HOME         0x37
#define KB_S_HOME            0x4737
#define KB_SC_C_HOME         0x77
#define KB_CH_C_HOME            0
#define KB_C_HOME            0x7700

#define KB_SC_N_END          0x4F
#define KB_CH_N_END             0
#define KB_N_END             0x4F00
#define KB_SC_S_END          0x4F
#define KB_CH_S_END          0x31
#define KB_S_END             0x4F31
#define KB_SC_C_END          0x75
#define KB_CH_C_END             0
#define KB_C_END             0x7500

#define KB_SC_N_INS          0x52
#define KB_CH_N_INS             0
#define KB_N_INS             0x5200
#define KB_SC_S_INS          0x52
#define KB_CH_S_INS          0x30
#define KB_S_INS             0x5230
#define KB_SC_C_INS          0x92
#define KB_CH_C_INS             0
#define KB_C_INS             0x9200

#define KB_SC_N_DEL          0x53
#define KB_CH_N_DEL             0
#define KB_N_DEL             0x5300
#define KB_SC_S_DEL          0x53
#define KB_CH_S_DEL          0x2E
#define KB_S_DEL             0x532E
#define KB_SC_C_DEL          0x93
#define KB_CH_C_DEL             0
#define KB_C_DEL             0x9300

#define KB_SC_N_PAD_5        0x4C
#define KB_CH_N_PAD_5           0
#define KB_N_PAD_5           0x4C00
#define KB_SC_S_PAD_5        0x4C
#define KB_CH_S_PAD_5        0x35
#define KB_S_PAD_5           0x4C35
#define KB_SC_C_PAD_5        0x8F
#define KB_CH_C_PAD_5           0
#define KB_C_PAD_5           0x8F00

#define KB_SC_N_PAD_STAR     0x37
#define KB_CH_N_PAD_STAR     0x2A
#define KB_N_PAD_STAR        0x372A
#define KB_SC_S_PAD_STAR     0x37
#define KB_CH_S_PAD_STAR     0x2A
#define KB_S_PAD_STAR        0x372A
#define KB_SC_C_PAD_STAR     0x96
#define KB_CH_C_PAD_STAR        0
#define KB_C_PAD_STAR        0x9600
#define KB_SC_A_PAD_STAR     0x37
#define KB_CH_A_PAD_STAR        0
#define KB_A_PAD_STAR        0x3700

#define KB_SC_N_PAD_MINUS    0x4A
#define KB_CH_N_PAD_MINUS    0x2D
#define KB_N_PAD_MINUS       0x4A2D
#define KB_SC_S_PAD_MINUS    0x4A
#define KB_CH_S_PAD_MINUS    0x2D
#define KB_S_PAD_MINUS       0x4A2D
#define KB_SC_C_PAD_MINUS    0x8E
#define KB_CH_C_PAD_MINUS       0
#define KB_C_PAD_MINUS       0x8E00
#define KB_SC_A_PAD_MINUS    0x4A
#define KB_CH_A_PAD_MINUS       0
#define KB_A_PAD_MINUS       0x4A00

#define KB_SC_N_PAD_PLUS     0x4E
#define KB_CH_N_PAD_PLUS     0x2B
#define KB_N_PAD_PLUS        0x4E2B
#define KB_SC_S_PAD_PLUS     0x4E
#define KB_CH_S_PAD_PLUS     0x2B
#define KB_S_PAD_PLUS        0x4E2B
#define KB_SC_C_PAD_PLUS     0x90
#define KB_CH_C_PAD_PLUS        0
#define KB_C_PAD_PLUS        0x9000
#define KB_SC_A_PAD_PLUS     0x4E
#define KB_CH_A_PAD_PLUS        0
#define KB_A_PAD_PLUS        0x4E00

#define KB_SC_N_PAD_SLASH    0xE0
#define KB_CH_N_PAD_SLASH    0x2F
#define KB_N_PAD_SLASH       0xE02F
#define KB_SC_S_PAD_SLASH    0xE0
#define KB_CH_S_PAD_SLASH    0x2F
#define KB_S_PAD_SLASH       0xE02F
#define KB_SC_C_PAD_SLASH    0x95
#define KB_CH_C_PAD_SLASH       0
#define KB_C_PAD_SLASH       0x9500
#define KB_SC_A_PAD_SLASH    0xA4
#define KB_CH_A_PAD_SLASH       0
#define KB_A_PAD_SLASH       0xA400

#define KB_SC_N_PAD_ENTER    0xE0
#define KB_CH_N_PAD_ENTER    0x0D
#define KB_N_PAD_ENTER       0xE00D
#define KB_SC_S_PAD_ENERR    0xE0
#define KB_CH_S_PAD_ENERR    0x0D
#define KB_S_PAD_ENERR       0xE00D
#define KB_SC_C_PAD_ENERR    0xE0
#define KB_CH_C_PAD_ENERR    0x0A
#define KB_C_PAD_ENERR       0xE00A
#define KB_SC_A_PAD_ENERR    0xA6
#define KB_CH_A_PAD_ENERR       0
#define KB_A_PAD_ENERR       0xA600

               
/*===========================================================================
	gray pad keys
*/
#define KB_SC_N_GRAY_UP      0x48
#define KB_CH_N_GRAY_UP      0xE0
#define KB_N_GRAY_UP         0x48E0
#define KB_SC_S_GRAY_UP      0x48
#define KB_CH_S_GRAY_UP      0xE0
#define KB_S_GRAY_UP         0x48E0
#define KB_SC_C_GRAY_UP      0x8D
#define KB_CH_C_GRAY_UP      0xE0
#define KB_C_GRAY_UP         0x8DE0
#define KB_SC_A_GRAY_UP      0x98
#define KB_CH_A_GRAY_UP         0

#define KB_SC_N_GRAY_DOWN    0x50
#define KB_CH_N_GRAY_DOWN    0xE0
#define KB_N_GRAY_DOWN       0x50E0
#define KB_SC_S_GRAY_DOWN    0x50
#define KB_CH_S_GRAY_DOWN    0xE0
#define KB_S_GRAY_DOWN       0x50E0
#define KB_SC_C_GRAY_DOWN    0x91
#define KB_CH_C_GRAY_DOWN    0xE0
#define KB_C_GRAY_DOWN       0x91E0
#define KB_SC_A_GRAY_DOWN    0xA0
#define KB_CH_A_GRAY_DOWN       0
#define KB_A_GRAY_DOWN       0xA000

#define KB_SC_N_GRAY_LEFT    0x4B
#define KB_CH_N_GRAY_LEFT    0xE0
#define KB_N_GRAY_LEFT       0x4BE0
#define KB_SC_S_GRAY_LEFT    0x4B
#define KB_CH_S_GRAY_LEFT    0xE0
#define KB_S_GRAY_LEFT       0x4BE0
#define KB_SC_C_GRAY_LEFT    0x73
#define KB_CH_C_GRAY_LEFT    0xE0
#define KB_C_GRAY_LEFT       0x73E0
#define KB_SC_A_GRAY_LEFT    0x9B
#define KB_CH_A_GRAY_LEFT       0
#define KB_A_GRAY_LEFT       0x9B00

#define KB_SC_N_GRAY_RIGHT   0x4D
#define KB_CH_N_GRAY_RIGHT   0xE0
#define KB_N_GRAY_RIGHT      0x4DE0
#define KB_SC_S_GRAY_RIGHT   0x4D
#define KB_CH_S_GRAY_RIGHT   0xE0
#define KB_S_GRAY_RIGHT      0x4DE0
#define KB_SC_C_GRAY_RIGHT   0x74
#define KB_CH_C_GRAY_RIGHT   0xE0
#define KB_C_GRAY_RIGHT      0x74E0
#define KB_SC_A_GRAY_RIGHT   0x9D
#define KB_CH_A_GRAY_RIGHT      0
#define KB_A_GRAY_RIGHT      0x9D00

#define KB_SC_N_GRAY_PGUP    0x49
#define KB_CH_N_GRAY_PGUP    0xE0
#define KB_N_GRAY_PGUP       0x49E0
#define KB_SC_S_GRAY_PGUP    0x49
#define KB_CH_S_GRAY_PGUP    0xE0
#define KB_S_GRAY_PGUP       0x49E0
#define KB_SC_C_GRAY_PGUP    0x84
#define KB_CH_C_GRAY_PGUP    0xE0
#define KB_C_GRAY_PGUP       0x84E0
#define KB_SC_A_GRAY_PGUP    0x99
#define KB_CH_A_GRAY_PGUP       0
#define KB_A_GRAY_PGUP       0x9900

#define KB_SC_N_GRAY_PGDN    0x51
#define KB_CH_N_GRAY_PGDN    0xE0
#define KB_N_GRAY_PGDN       0x51E0
#define KB_SC_S_GRAY_PGDN    0x51
#define KB_CH_S_GRAY_PGDN    0xE0
#define KB_S_GRAY_PGDN       0x51E0
#define KB_SC_C_GRAY_PGDN    0x76
#define KB_CH_C_GRAY_PGDN    0xE0
#define KB_C_GRAY_PGDN       0x76E0
#define KB_SC_A_GRAY_PGDN    0xA1
#define KB_CH_A_GRAY_PGDN       0
#define KB_A_GRAY_PGDN       0xA100

#define KB_SC_N_GRAY_HOME    0x47
#define KB_CH_N_GRAY_HOME    0xE0
#define KB_N_GRAY_HOME       0x47E0
#define KB_SC_S_GRAY_HOME    0x47
#define KB_CH_S_GRAY_HOME    0xE0
#define KB_S_GRAY_HOME       0x47E0
#define KB_SC_C_GRAY_HOME    0x77
#define KB_CH_C_GRAY_HOME    0xE0
#define KB_C_GRAY_HOME       0x77E0
#define KB_SC_A_GRAY_HOME    0x97
#define KB_CH_A_GRAY_HOME       0
#define KB_A_GRAY_HOME       0x9700

#define KB_SC_N_GRAY_END     0x4F
#define KB_CH_N_GRAY_END     0xE0
#define KB_N_GRAY_END        0x4FE0
#define KB_SC_S_GRAY_END     0x4F
#define KB_CH_S_GRAY_END     0xE0
#define KB_S_GRAY_END        0x4FE0
#define KB_SC_C_GRAY_END     0x75
#define KB_CH_C_GRAY_END     0xE0
#define KB_C_GRAY_END        0x75E0
#define KB_SC_A_GRAY_END     0x9F
#define KB_CH_A_GRAY_END        0
#define KB_A_GRAY_END        0x9F00

#define KB_SC_N_GRAY_INS     0x52
#define KB_CH_N_GRAY_INS     0xE0
#define KB_N_GRAY_INS        0x52E0
#define KB_SC_S_GRAY_INS     0x52
#define KB_CH_S_GRAY_INS     0xE0
#define KB_S_GRAY_INS        0x52E0
#define KB_SC_C_GRAY_INS     0x92
#define KB_CH_C_GRAY_INS     0xE0
#define KB_C_GRAY_INS        0x92E0
#define KB_SC_A_GRAY_INS     0xA2
#define KB_CH_A_GRAY_INS        0
#define KB_A_GRAY_INS        0xA200

#define KB_SC_N_GRAY_DEL     0x53
#define KB_CH_N_GRAY_DEL     0xE0
#define KB_N_GRAY_DEL        0x53E0
#define KB_SC_S_GRAY_DEL     0x53
#define KB_CH_S_GRAY_DEL     0xE0
#define KB_S_GRAY_DEL        0x53E0
#define KB_SC_C_GRAY_DEL     0x93
#define KB_CH_C_GRAY_DEL     0xE0
#define KB_C_GRAY_DEL        0x93E0
#define KB_SC_A_GRAY_DEL     0xA3
#define KB_CH_A_GRAY_DEL        0

/*===========================================================================
	special keys
*/
#define KB_SC_C_PRTSC        0x72
#define KB_CH_C_PRTSC           0
#define KB_C_PRTSC           0x7200

#define KB_SC_C_BREAK           0
#define KB_CH_C_BREAK           0
#define KB_C_BREAK           0x0000

#endif

