;[]-----------------------------------------------------------------[]
;|      GRAPH.MAC  --  Rules & Structures for assembler              |
;|                                                                   |
;|      Graphic Library                     Version 3.0              |
;|                                                                   |
;|      Copyright (c) 1991 by Andrzej Trzeciak.                      |
;|      All Rights Reserved.                                         |
;[]-----------------------------------------------------------------[]

        PAGE    60,132
        LOCALS

;[]------------------------------------------------------------[]
;|								|
;|	Conditional Assembly Directives				|
;|								|
;[]------------------------------------------------------------[]

;memory model aliases, for the convenience of building the library

IFDEF		__s__
__SMALL__ 	equ	1
ENDIF

IFDEF		__c__
__COMPACT__ 	equ	1
ENDIF

IFDEF		__m__
__MEDIUM__ 	equ	1
ENDIF

IFDEF		__l__
__LARGE__ 	equ	1
ENDIF

IFDEF		__h__
__HUGE__ 	equ	1
ENDIF

IFNDEF __TINY__
    IFNDEF __SMALL__
	IFNDEF __MEDIUM__
	    IFNDEF __COMPACT__
		IFNDEF __LARGE__
		    IFNDEF __HUGE__
			%OUT  You must supply a model symbol.
			.ERR
		    ENDIF
		ENDIF
	    ENDIF
	ENDIF
    ENDIF
ENDIF

IFDEF	__TINY__		; Small Code - Small Data
	LPROG		equ 0
	LDATA		equ 0
ENDIF

IFDEF	__SMALL__		; Small Code - Small Data
	LPROG		equ 0
	LDATA		equ 0
ENDIF

IFDEF	__MEDIUM__		; Large Code - Small Data
	LPROG		equ 1
	LDATA		equ 0
ENDIF

IFDEF	__COMPACT__		; Small Code - Large Data
	LPROG		equ 0
	LDATA		equ 1
ENDIF

IFDEF	__LARGE__		; Large Code - Large Data
	LPROG		equ 1
	LDATA		equ 1
ENDIF

IFDEF	__HUGE__		; Large Code - Large Data
	LPROG	    	equ 1
	LDATA	    	equ 1
ENDIF

IF	LDATA
	DPTR		equ <DWORD>
	DSEGname	equ <WIN_DATA>
ELSE
	DPTR		equ <WORD>
	DSEGname	equ <_DATA>
ENDIF

IF      LPROG
	DIST		equ <FAR>
	CPTR		equ <DD>
	CSEGname	equ <WIN_TEXT>
ELSE
	DIST		equ <NEAR>
	CPTR		equ <DW>
	CSEGname	equ <_TEXT>
ENDIF

	PAGE
;[]------------------------------------------------------------[]
;|								|
;|	Segment Declarations Macros				|
;|								|
;[]------------------------------------------------------------[]

;----------------------------------------------------------------------------
beginCSEG	MACRO		;; Open a Code Segment
CSEGname SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CSEGname
		ENDM

endCSEG		MACRO		;; Close a Code Segment
CSEGname ENDS
		ENDM

;----------------------------------------------------------------------------
beginDSEG	MACRO		;; Open a Data Segment	(initialized)
DSEGname SEGMENT WORD PUBLIC 'DATA'
		ENDM

endDSEG		MACRO		;; Close a Data Segment (initialized)
DSEGname ENDS
		ENDM

;----------------------------------------------------------------------------
header		MACRO
CSEGname SEGMENT BYTE PUBLIC 'CODE'
CSEGname ENDS
;;DSEGname SEGMENT WORD PUBLIC 'DATA'
;;DSEGname ENDS

;;IFDEF   __TINY__
;;	DGROUP	GROUP	CSEGname, DSEGname
;;ELSE
;;	DGROUP	GROUP	DSEGname
;;ENDIF

	ASSUME	CS:CSEGname;;, DS:DGROUP
		ENDM

;----------------------------------------------------------------------------
beginPROC	MACRO pname	;;Begin procedure MACRO.
pname&@ equ <_&pname>

assume cs:CSEGname
pname&@ proc DIST
public pname&@
		ENDM

;----------------------------------------------------------------------------
endPROC		MACRO pname	;;End procedure MACRO.
pname&@ endp
		ENDM

;----------------------------------------------------------------------------
enterPROC	MACRO loc	;;Entry procedure MACRO.

	push	bp
	mov	bp, sp
	IFNB	<loc>
		IF	loc EQ 1
		dec	sp
		ELSEIF	loc EQ 2
		dec	sp
		dec	sp
		ELSE
		sub	sp, loc
		ENDIF
	ENDIF
ENDM

;----------------------------------------------------------------------------
leavePROC	MACRO loc	;;Exit procedure MACRO.

	IFNB	<loc>
		mov	sp, bp
	ENDIF
	pop	bp
	ret
ENDM

