;----------------------------------------------------------------------------
; KBPLACE.ASM
; 
; 
; Version 1.0
; 
; (C) Copyright 1992
; All Rights Reserved
; 
; Andrew Trzeciak
; PO Box 1521
; Lombard IL 60148-8521
; 
; 
include	asm\rules.inc

header

beginCSEG

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
Where		DW ?
KeyCh		DW ?
KeySc		DW ?
param ENDS

buffer_head   equ 01AH
buffer_tail   equ 01CH
kb_buffer     equ 01EH
kb_buffer_end equ 03EH

;----------------------------------------------------------------------------
; unsigned int kb_place (int where, int ch, int sc);
;
;
beginPROC kb_place

	enterPROC
	push	ds
	pushf		   ; Save interrupt state.

	mov	ax,040h	   ; Segment address of BIOS data
	mov	ds,ax
	assume	ds:nothing

	cli		   ; Disable interrupts.

	cmp	Where[bp], 0
	jnz	@@try_at_tail
	;
	; TRY PUT AT THE HEAD
	;
	mov	bx,ds:[buffer_head]
	dec	bx		   ; Tentatively step head back.
	dec	bx
	cmp	bx,kb_buffer
	jae	@@1
				   ; Went past beginning of buffer,
	mov	bx, kb_buffer_end-2; so wrap to end.
@@1:
				   ; Now BX has new head pointer.
	cmp	bx, ds:[buffer_tail]
	je	no_room

	mov	al, byte ptr KeyCh[bp]
	mov	ah, byte ptr KeySc[bp]
	mov	[bx], ax	   ; Store value & scan code
				   ; at buffer head.
	mov	ds:[buffer_head], bx    ; New head pointer.

	jmp	short success

	;
	; TRY PUT AT THE TAIL
	;
@@try_at_tail:
	mov	bx, ds:[buffer_tail]
	mov	cx, bx
	inc	cx		   ; Tentatively advance new tail.
	inc	cx
	cmp	cx, kb_buffer_end
	jb	@@2
				   ; Went past end of buffer,
	mov	cx, kb_buffer	   ; so wrap to beginning.
@@2:
				   ; Now CX has new tail.
	cmp	cx, ds:[buffer_head]
	je	no_room

	mov	al, byte ptr KeyCh[bp]
	mov	ah, byte ptr KeySc[bp]
	mov	[bx], ax	   ; Store value & scan code
				   ; at buffer tail.
	mov	ds:[buffer_tail], cx    ; New tail pointer.

success:
	xor	ax, ax
	jmp	short exit

no_room:
	mov	ax, 1

exit:
	popf			   ; Restore interrupt state.
	pop	ds
	leavePROC

endPROC kb_place

endCSEG

end
