;----------------------------------------------------------------------------
; SCRLIB.ASM
; 
; 
; Version 1.0
; 
; (C) Copyright 1992
; All Rights Reserved
; 
; Andrew Trzeciak
; PO Box 1521
; Lombard IL 60148-8521
; 
; 
include	asm\rules.inc

header

beginCSEG

COLOR_STAT_REG	equ 03DAH

;
; bios variables at segment 0
;
video_hdw_off_	equ 0074 	; dw
video_hdw_seg_	equ 0076 	; dw
vid_g_tbl_off	equ 010C 	; dw
vid_g_tbl_seg	equ 010E 	; dw

equip_word	equ 0410h	; dw

video_mode	equ 0449h	; db
video_columns	equ 044Ah	; dw
video_buf_siz	equ 044Ch	; dw
video_segment	equ 044Eh	; dw
vid_curs_pos0	equ 0450h	; dw
vid_curs_pos1	equ 0452h	; dw
vid_curs_pos2	equ 0454h	; dw
vid_curs_pos3	equ 0456h	; dw
vid_curs_pos4	equ 0458h	; dw
vid_curs_pos5	equ 045Ah	; dw
vid_curs_pos6	equ 045Ch	; dw
vid_curs_pos7	equ 045Eh	; dw
vid_curs_mode	equ 0460h	; dw
video_page	equ 0462h	; db
@video_port	equ 0463h	; dw
video_mode_reg	equ 0465h	; db
video_color	equ 0466h	; db

video_rows	equ 0484h 	; db
video_pixels	equ 0485h 	; dw
video_options	equ 0487h 	; db
video_switches	equ 0488h	; db
video_1_reservd	equ 0489h 	; db
video_2_reservd	equ 048Ah 	; db

@video_parm_tbl	equ 04A8h 	; dd
@video_sav1area	equ 04ACh 	; dd
@video_text_tbl	equ 04B0h 	; dd
@vid_grph_tbl	equ 04B4h 	; dd
@video_sav2area	equ 04B8h 	; dd

;
; local data
;
sc_initflag        db 0
sc_issnow	   db 0
sc_mode		   db 3
sc_entrymode	   db 0
sc_entrypage	   db 0
sc_entrycursorpos  dw 0
sc_entrycursortype dw 0


;----------------------------------------------------------------------------
; void sc_buf2scr (unsigned int x, unsigned int y,
;			 void *srcptr, unsigned int len);
;
beginPROC sc_buf2scr

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
X		DW ?
Y		DW ?
IF	LDATA
SrcPtr		DD ?
ELSE
SrcPtr		DW ?
ENDIF
SrcLen		DW ?
param ENDS

	enterPROC
	push	ds si di

	cmp	SrcLen[bp],0
	jz	@@Exit

	IF	LDATA
	lds	si,SrcPtr[bp]
	ELSE
	mov	si,SrcPtr[bp]
	ENDIF

	xor	ax,ax
	mov	es,ax		; Bios data segment

	mov	al,018h		; es:[video_rows]
	cmp	ax,Y[bp]
	jb	@@Exit

	mov	ax,es:[video_columns]
	cmp	ax,X[bp]
	jb	@@Exit
	mov	di,ax		; di = video_columns
	mul	Y[bp]
	add	ax,X[bp]
	shl	ax,1
	add	ax,es:[video_segment]
	xchg	ax,di		; ax = video_columns, di = offset

	sub	ax,X[bp]
	cmp	ax,SrcLen[bp]
	jl	@@SkipLen
	mov	ax,SrcLen[bp]
@@SkipLen:
	mov	cx,ax

	mov	ax,0B000H
	cmp	byte ptr es:[video_mode],7
	je	@@IsBW

	mov	ax,0B800H
	cmp	byte ptr cs:sc_issnow,0
	jz	@@NoSnowMove

	mov	es,ax
	;
	; SLOW WRITE TO SCREEN ( CGA ONLY )
	;
	pushf
	mov	dx,COLOR_STAT_REG
	mov	bl,1
	cld
	sti
	push bp
@@WriteLoop:
	lodsw
	mov	bp,ax
@@WaitNotHoriz:
	in	al,dx
	rcr	al,1
	jc	@@WaitNotHoriz
	cli
@@Wait:
	in	al,dx
	rcr	al,1
	jnc	@@Wait
	xchg	ax,bp
	stosw
	sti
	loop	@@WriteLoop
	pop	bp
	popf
	jmp	@@Exit

	;
	; FAST WRITE TO SCREEN
	;
@@NoSnowMove:
@@IsBW:
	mov	es,ax
	cld
	rep	movsw

@@Exit:
	pop di si ds
	leavePROC

endPROC sc_buf2scr


;----------------------------------------------------------------------------
; void sc_scr2buf(unsigned int x, unsigned int y, 
;				void *trgptr, unsigned int len);
;
beginPROC sc_scr2buf

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
X		DW ?
Y		DW ?
IF	LDATA
TrgPtr		DD ?
ELSE
TrgPtr		DW ?
ENDIF
TrgLen		DW ?
param ENDS

	enterPROC
	push	ds si di

	cmp	TrgLen[bp],0
	jle	@@Exit

	IF	LDATA
	les	di,TrgPtr[bp]
	ELSE
	mov	di,TrgPtr[bp]
	mov	ax,ds
	mov	es,ax
	ENDIF

	xor	ax,ax
	mov	ds,ax		; Bios data segment

	mov	al,018h		; ds:[video_rows]
	cmp	ax,Y[bp]
	jb	@@Exit

	mov	ax,ds:[video_columns]
	cmp	ax,X[bp]
	jb	@@Exit
	mov	si,ax		; di = video_columns
	mul	Y[bp]
	add	ax,X[bp]
	shl	ax,1
	add	ax,ds:[video_segment]
	xchg	ax,si		; ax = video_columns, di = offset

	sub	ax,X[bp]
	cmp	ax,TrgLen[bp]
	jl	@@SkipLen
	mov	ax,TrgLen[bp]
@@SkipLen:
	mov	cx,ax

	mov	ax,0B000H
	cmp	byte ptr ds:[video_mode],7
	je	@@IsBW

	mov	ax,0B800H
	cmp	byte ptr cs:sc_issnow,0
	jz	@@NoSnowMove

	mov	ds,ax
	;
	; SLOW READ FROM SCREEN ( CGA ONLY )
	;
	pushf
	mov	dx,COLOR_STAT_REG
	add	cx,cx		; bytes
	mov	bl,1
	cld
@@ReadLoop:
@@WaitNotHoriz:
	in	al,dx
	rcr	al,1
	jc	@@WaitNotHoriz
	cli
@@Wait:
	in	al,dx
	rcr	al,1
	jnc	@@Wait
	movsb
	sti
	loop	@@ReadLoop
	popf
	jmp	@@Exit

	;
	; FAST READ FROM SCREEN
	;
@@NoSnowMove:
@@IsBW:
	mov	ds,ax
	cld
	rep	movsw

@@Exit:
	pop	di si ds
	leavePROC

endPROC sc_scr2buf

;----------------------------------------------------------------------------
; unsigned int sc_getscrsize (unsigned int *x, unsigned int *y);
;
beginPROC sc_getscrsize

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
IF	LDATA
XPtr		DD ?
YPtr		DD ?
ELSE
XPtr		DW ?
YPtr		DW ?
ENDIF
param ENDS

	enterPROC

	call	near ptr bios_getscreensize

	IF	LDATA
	les	si,YPtr[bp]
	mov	es:[si],ax
	ELSE
	mov	si,YPtr[bp]
	mov	[si],ax
	ENDIF

	mov	ax,dx
	IF	LDATA
	les	si,XPtr[bp]
	mov	es:[si],ax
	ELSE
	mov	si,XPtr[bp]
	mov	[si],ax
	ENDIF

	mov	ax,cx

	leavePROC

endPROC sc_getscrsize

;----------------------------------------------------------------------------
; unsigned int sc_getcursor(unsigned int *x,unsigned int *y);
;
beginPROC sc_getcursor

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
IF	LDATA
XPtr		DD ?
YPtr		DD ?
ELSE
XPtr		DW ?
YPtr		DW ?
ENDIF
param ENDS

	enterPROC

	call	near ptr bios_getcursor

	mov	al,dl
	sub	ah,ah
	IF	LDATA
	les	bx,XPtr[bp]
	mov	es:[bx],ax
	ELSE
	mov	bx,XPtr[bp]
	mov	[bx],ax
	ENDIF

	mov	al,dh
	IF	LDATA
	les	bx,YPtr[bp]
	mov	es:[bx],ax
	ELSE
	mov	bx,YPtr[bp]
	mov	[bx],ax
	ENDIF

	mov	ax,cx
	leavePROC

endPROC sc_getcursor

;----------------------------------------------------------------------------
; void sc_setcursize(unsigned int shape);
;
; 
beginPROC sc_setcursize

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
CURSIZE		DW ?
param ENDS

	enterPROC
	push	ds si di

	mov	ax,CURSIZE[bp]
	mov	cx,ax
	mov	ah,01H	; set test mode cursor size  [ ON / OFF ]
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_setcursize

;----------------------------------------------------------------------------
; void sc_setcurpos(unsigned int  x,unsigned int  y);
;
; 
beginPROC sc_setcurpos

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
X		DW ?
Y		DW ?
param ENDS

	enterPROC
	push	ds si di

	mov	dl,byte ptr X[bp]
	mov	dh,byte ptr Y[bp]
	xor	ax,ax
	mov	es,ax
	mov	bh,es:[video_page]
	mov	ah,02H		; set cursor position
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_setcurpos

;----------------------------------------------------------------------------
; void sc_setvideopage ( unsigned char newpage );
;
; 
beginPROC sc_setvideopage

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
NewPage		DW ?
param ENDS

	enterPROC
	push	ds si di

	mov	al,byte ptr NewPage[bp]
	mov	ah,05H
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_setvideopage

;----------------------------------------------------------------------------
; void sc_setvideomode ( unsigned char newmode );
;
; 
beginPROC sc_setvideomode

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
NewMode		DW ?
param ENDS

	enterPROC
	push	ds si di

	mov	al,byte ptr NewMode[bp]
	mov	ah,00H		; set video mode
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_setvideomode

;----------------------------------------------------------------------------
; unsigned char sc_getactivepage ( void );
;
;
beginPROC sc_getactivepage

	call	near ptr bios_getactivepage
	ret

endPROC sc_getactivepage


;----------------------------------------------------------------------------
; void sc_egablibkbit ( unsigned char option );
;
;
beginPROC sc_egablibkbit

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
OPTION		DW ?
param ENDS

	enterPROC
	push	ds si di

	mov	bl,byte ptr OPTION[bp]
	mov	ax,1003H
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_egablibkbit


;----------------------------------------------------------------------------
; void sc_setborder ( unsigned char color );
;
;
beginPROC sc_setborder

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
COLOR		DW ?
param ENDS

	enterPROC 
	push	ds si di

	mov	bh,byte ptr COLOR[bp]
	mov	ax,1001H
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_setborder


;----------------------------------------------------------------------------
; void sc_bell ( void );
;
;
beginPROC sc_bell

	enterPROC
	push	ds si di

	xor	ax,ax
	mov	es,ax
	mov	bh,es:[video_page]
	mov	bl,7
	mov	ax,0E07H
	int	10H

	pop	di si ds
	leavePROC

endPROC sc_bell


;----------------------------------------------------------------------------
; int sc_video ( void );
;
;
beginPROC sc_video

	enterPROC

	call	near ptr bios_video

	leavePROC

endPROC sc_video


;----------------------------------------------------------------------------
; void sc_init (unsigned int mode , int issnow);
;
; initialize screen type
;
beginPROC sc_init

param STRUC
CallerBP	DW ?
RetAddr		CPTR ?
;
; parameters
;
Mode		DW ?
InitIsSnow	DW ?
param ENDS

	enterPROC

	cmp	cs:sc_initflag,0
	jnz	@@exit

	mov	al,byte ptr InitIsSnow[bp]
	mov	cs:sc_issnow,al

	call	near ptr bios_getactivepage
	mov	cs:sc_entrypage,al

	call	near ptr bios_getcursor
	mov	ax,dx
	mov	cs:sc_entrycursorpos,ax

	mov	ax,cx
	mov	cs:sc_entrycursortype,ax

	cmp	al,20h
	jg	@@setcursor
	cmp	al,0h
	jle	@@setcursor
	cmp	ah,20h
	jg	@@setcursor
	cmp	ah,0h
	jle	@@setcursor
	jmp	short @@cursor_okay
@@setcursor:
	mov	ax,0607h
	push	ax
	call	DIST ptr _sc_setcursize
	inc	sp
	inc	sp
@@cursor_okay:

	mov	ax,Mode[bp]
	mov	cs:sc_mode,al
	mov	cs:sc_entrymode,al
	call	near ptr bios_getvideomode
	cmp	al,cs:sc_mode
	jz	@@skip_setmode
	mov	cs:sc_entrymode,al
	mov	al,cs:sc_mode
	sub	ah,ah
	push	ax
	call	DIST ptr _sc_setvideomode
	inc	sp
	inc	sp
@@skip_setmode:
	mov	cs:sc_initflag,1
@@exit:
	leavePROC

endPROC sc_init


;----------------------------------------------------------------------------
; int sc_exit (void);
;
;
beginPROC sc_exit

	enterPROC

	cmp	cs:sc_initflag,0
	jz	@@exit

	call	near ptr bios_getvideomode
	cmp	al,cs:sc_entrymode
	jz	@@mode_okay
	mov	al,cs:sc_entrymode
	sub	ah,ah
	push	ax
	call	DIST ptr _sc_setvideomode
	inc	sp
	inc	sp
@@mode_okay:

	call	near ptr bios_getactivepage
	cmp	al,cs:sc_entrypage
	jz	@@page_okay
	mov	al,cs:sc_entrypage
	sub	ah,ah
	push	ax
	call	DIST ptr _sc_setvideopage
	inc	sp
	inc	sp
@@page_okay:

	call	near ptr bios_getcursor
	cmp	cx,cs:sc_entrycursortype
	jz	@@curtype_okay
	mov	ax,cs:sc_entrycursortype
	push	dx
	push	ax
	call	DIST ptr _sc_setcursize
	inc	sp
	inc	sp
	pop	dx
@@curtype_okay:

	cmp	dx,cs:sc_entrycursorpos
	jz	@@curpos_okay
	mov	ax,cs:sc_entrycursorpos
	mov	dl,al
	sub	dh,dh
	mov	al,ah
	sub	ah,ah
	push	ax
	push	dx
	call	DIST ptr _sc_setcurpos
	add	sp,4
@@curpos_okay:
	mov	cs:sc_initflag,0
@@exit:
	leavePROC

endPROC sc_exit


;############################################################################


bios_getcursor proc near

	xor	ax,ax
	mov	es,ax

	mov	ax,es:[vid_curs_mode]
	mov	cx,ax

	mov	al,es:[video_page]
	sub	ah,ah
	add	ax,vid_curs_pos0
	mov	bx,ax
	mov	ax,es:[bx]
	mov	dx,ax
	ret

bios_getcursor endp


bios_getscreensize proc near

	xor	ax,ax
	mov	es,ax

	mov	ax,es:[video_buf_siz]
	mov	cx,ax
	mov	ax,es:[video_columns]
	dec	ax
	mov	dx,ax
	mov	al,018h		; es:[video_rows]
	sub	ah,ah
	ret

bios_getscreensize endp

bios_getactivepage proc near

	xor	ax,ax
	mov	es,ax

	mov	al,es:[video_page]
	xor	ah,ah
	ret

bios_getactivepage endp

bios_getvideomode proc near

	xor	ax,ax
	mov	es,ax

	mov	al,es:[video_mode]
	xor	ah,ah
	ret

bios_getvideomode endp


bios_video proc near

	xor	ax,ax
	mov	es,ax

	mov	ax,es:[equip_word]
	and	ax,030h
	shr	ax,1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	ret

bios_video endp

endCSEG

end


