// +--------------------------------------------------------------------------+
// |                                                                          |
// |                    Dialog box using a custom class                       |
// |                                  or                                      |
// |          "How I learned to keep CTL3D.DLL out of my business"            |
// |                                                                          |
// | If CTL3D is called with a NULL instance (task) handle, it subclasses any |
// | dialog / message box in the system as long as it has the WC_DIALOG class |
// | and then default window process address. Thus, to keep CTL3D away from   |
// | your dialogs, and there are times it's needed, you merely need to create |
// | a custom dialog class and use it instead of a standard dialog box. This  |
// | program demonstrates that technique by creating a new dialog box class   |
// | using existing dialog box class information.                             |
// |                                                                          |
// |        This program is public domain and may be freely distributed       |
// |                        Written by Mark Gamber                            |
// |                                                                          |
// +--------------------------------------------------------------------------+

#include "windows.h"


LRESULT WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );  //  Dialog prototype


// ------  Program Entry Point ------------------------------------------------

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, int nShow )
{
   WNDCLASS wc;

   if( ! GetClassInfo( NULL, WC_DIALOG, &wc ) ) //  Get class info for standard
      return( FALSE );                          //  dialog boxes or exit trying

   wc.style = 0;                               //  Don't want this as a global!
   wc.hInstance = hInstance;                            //  Point to our DGROUP
   wc.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( 1000 ) );
   wc.lpfnWndProc = (WNDPROC)MainDlgProc;          //  Point to our dialog proc
   wc.lpszClassName = (LPSTR)"MYDIALOG";             //  Apply a new class name

   if( ! RegisterClass( &wc ) )               //  Register the new dialog class
      return( FALSE );
                                                    //  Start custom dialog box
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, NULL );
   return( FALSE );
}


// +----- Custom Dialog Proc -------------------------------------------------+
// |                                                                          |
// |  Note that a custom dialog proc returns LRESULT instead of BOOL and must |
// |  call DefDlgProc() instead of just return( FALSE ) or DefWindowProc().   |
// |                                                                          |
// |  Also note that WM_CREATE is called instead of WM_INITDIALOG and the     |
// |  dialog box apaprently never gets WM_SETFONT if a font is defined in the |
// |  dialog box template in the resource file.                               |
// |                                                                          |
// +--------------------------------------------------------------------------+

LRESULT WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_CREATE:            //  Custom dialog gets this, not WM_INITDIALOG
         break;

      case WM_COMMAND:              //  The rest of the dialog is pretty normal
      {
         if( wParam == IDOK || wParam == IDCANCEL )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
      }
   }                            //  This gets called instead of DefWindowProc()
   return( DefDlgProc( hDlg, msg, wParam, lParam ) );
}

