#include <iostream.h>
#include <process.h>
#include <alloc.h>
#include <conio.h>

#include <mytable.h>

#include <pxengine.h>
#include <envdef.h>
#include <bengine.h>
#include <bcursor.h>
#include <bdatabas.h>

PXCODE PXError( char *module, int line, char *function, int retval ) ;

#define PXErr(parm) PXError( __FILE__, __LINE__, #parm, parm )

extern int GlobalPXErr ;

#define TABLENAME "mytable"
#define NUMBER 10

double values[NUMBER][3] = { { 23, 20, 0 }, { 1, 1, 0 }, { 11, 23, 0 },
			     { 123, 111, 0 }, { 21, 22, 33 }, { 300, 25, 6 },
			     { 88, 34, 0 }, { 170, 28, 68 }, { 3, 4, 5 },
			     { 405, 24, 44 } } ;

int main( void )
{

   clrscr() ;

   BEngine myEngine( pxLocal ) ;
   PXErr( myEngine.lastError ) ;
   if ( GlobalPXErr ) exit( 1 ) ;

   BDatabase myDataBase( &myEngine ) ;
   PXErr( myDataBase.lastError ) ;
   if ( GlobalPXErr ) exit( 1 );

   if ( myDataBase.tableExists( TABLENAME ) )
   {
      PXErr( myDataBase.lastError ) ;

      myDataBase.emptyTable( TABLENAME ) ;
      PXErr( myDataBase.lastError ) ;

      BCursor myCursor( &myDataBase, TABLENAME, 0, TRUE ) ;
      PXErr( myDataBase.lastError ) ;
      if ( GlobalPXErr ) exit( 1 ) ;

      mytable table( &myCursor ) ;
      PXErr( table.lastError ) ;
      if ( GlobalPXErr ) exit( 1 ) ;

      // Go to the start of the table, before the first record.

      myCursor.gotoBegin() ;
      PXErr( table.lastError ) ;
      if ( GlobalPXErr ) exit( 1 ) ;

      // Mark all fields as containing valid data ( i.e. not equal to
      // Null ).

      table.clearNull( "Exponent" ) ;
      table.clearNull( "Mantissa_1" ) ;
      table.clearNull( "Mantissa_2" ) ;

      // Add Values to the table. Notice that we do not need to use the
      // putField functions. The Custom Record takes care of that for us.

      for( int i = 0; i< NUMBER; i++ )
      {
	 table.Exponent   = values[i][0] ;
	 table.Mantissa_1 = values[i][1] ;
	 table.Mantissa_2 = values[i][2] ;
	 myCursor.insertRec( &table ) ;
	 PXErr( myCursor.lastError ) ;
	 if ( !GlobalPXErr )
	 {
	    cout << "Item #" << ( i + 1 ) << " added successfully." << endl ;
	 }
      }
   } else {
	cout << "Table does not exist: Run maketbl." << endl ;
   }

   return 0 ;
}
