//            mytable.cpp 

#include "envdef.h"
#include "mytable.H"
#include <stdlib.h> 
#include <string.h> 
#include <stdio.h> 
#include <malloc.h> 

CRFldMapdef *mytable::mytable_CRFldMap = 0;  // Declare & init static var 

#define loadDesc(fld,fname,ftype,fstype,flen,tnum)   {\
                   mytable_CRFldMap->desc[fld].fldNum = fld + 1; \
                   _fstrcpy(mytable_CRFldMap->desc[fld].fldName,fname); \
                   mytable_CRFldMap->desc[fld].fldType = ftype; \
                   mytable_CRFldMap->desc[fld].fldSubtype = fstype; \
                   mytable_CRFldMap->desc[fld].fldLen = flen; \
                   mytable_CRFldMap->tblFldNbr[fld] = tnum; } 

Retcode convertFld(void *, PXFieldType, int,     // Source pointer, type, length. 
                   void *, PXFieldType, int);    // Destination pointer, type, length. 

mytable::mytable(BCursor *cursor) : BRecord(cursor) 
{ 
  if (mytable_CRFldMap == 0) 
  { 
    mytable_CRFldMap = new CRFldMapdef; 
    mytable_CRFldMap->useCnt = 0; 
    mytable_CRFldMap->fieldCnt = 3; 
    mytable_CRFldMap->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) * 3); 
    mytable_CRFldMap->tblFldNbr = new FIELDNUMBER[3]; 
    loadDesc(0,"Exponent",fldDouble,fldstNone,0,1); 
    loadDesc(1,"Mantissa_1",fldDouble,fldstNone,0,2); 
    loadDesc(2,"Mantissa_2",fldDouble,fldstNone,0,3); 
  } 
  mytable_CRFldMap->useCnt++; 
  fldPtr =  new void *[3]; 
  fldPtr[0] = &Exponent; 
  fldPtr[1] = &Mantissa_1; 
  fldPtr[2] = &Mantissa_2; 
} 

mytable::~mytable() 
{ 
  delete [] fldPtr; 
  if ( --mytable_CRFldMap->useCnt == 0) 
  {				       
    delete [] mytable_CRFldMap->tblFldNbr; 
    _ffree(mytable_CRFldMap->desc);	  
    delete mytable_CRFldMap;		  
    mytable_CRFldMap = 0;		  
  }  				  
} 

Retcode mytable::clear() 
{ 
  for (int i=0; i < sizeof nullVec; i++) 
    nullVec[i] = 0xFF; 
  return(lastError = PXSUCCESS); 
} 

FIELDNUMBER mytable::getFieldNumber(const char *fldName) 
{ 
  lastError = PXSUCCESS; 
  for (int i=0; i < mytable_CRFldMap->fieldCnt; i++) 
    if ( ! _fstrcmp(mytable_CRFldMap->desc[i].fldName, (char far *) fldName)) 
      return(i+1); 
  lastError = PXERR_INVFIELDNAME; 
  return(0); 
} 

FIELDNUMBER mytable::getTblFieldNumber(FIELDNUMBER fldnbr) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
  { 
    lastError = PXERR_INVFIELDHANDLE; 
    return(0);   
  } 
  lastError = PXSUCCESS; 
  return(mytable_CRFldMap->tblFldNbr[fldnbr-1]);
}

int mytable::getFieldCount() 
{ 
  lastError = PXSUCCESS; 
  return(mytable_CRFldMap->fieldCnt); 
} 

Retcode mytable::getFieldDesc(FIELDNUMBER fldnbr, FieldDesc& desc) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt || fldnbr < 1) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  desc = mytable_CRFldMap->desc[fldnbr-1]; 
  return(lastError = PXSUCCESS); 
}

Retcode mytable::getFieldDesc(FIELDNUMBER     fldnbr,  
                          PXFieldType    &fldType, 
                          PXFieldSubtype &fldSubtype, 
                          int            &fldLen) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt || fldnbr < 1) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  fldType = mytable_CRFldMap->desc[fldnbr-1].fldType; 
  fldSubtype = mytable_CRFldMap->desc[fldnbr-1].fldSubtype; 
  fldLen  = mytable_CRFldMap->desc[fldnbr-1].fldLen; 
  return(lastError = PXSUCCESS); 
}

Retcode mytable::getField(FIELDNUMBER fldnbr, 
                      void *buf, int bufLen, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt || fldnbr < 1) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  switch (desc.fldType) 
  {
    case fldChar: 
      if (desc.fldLen > bufLen && 
         strlen((char *) fldPtr[fldnbr-1]) >= bufLen) 
      {
        strncpy((char *)buf,(char *)fldPtr[fldnbr-1],bufLen); 
        return(lastError = PXERR_BUFTOOSMALL);  
      }
      strcpy((char *)buf,(char *)fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	
    case fldShort:	   
      if (bufLen < sizeof(short)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((short *) buf) = *((short *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	 
    case fldLong:	   
      if (bufLen < sizeof(long)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((long *) buf) = *((long *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	 
    case fldDouble: 
      if (bufLen < sizeof(double)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((double *) buf) = *((double *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS); 
    case fldDate: 
      if (bufLen < sizeof(BDate)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((BDate *) buf) = *((BDate *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	
    default: 
      return(lastError = PXERR_TYPEMISMATCH); 
  } 
}

Retcode mytable::getField(FIELDNUMBER fldnbr, 
                      char *buf, int bufLen, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
                               (void *) buf, fldChar, bufLen)); 
} 

Retcode mytable::getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldDouble, sizeof(double)));
} 

Retcode mytable::getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldShort, sizeof(short)));
} 

Retcode mytable::getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldLong, sizeof(long)));
} 

Retcode mytable::getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
				   &val, fldDate, sizeof(BDate)));
} 

Retcode mytable::getField(char *fldName, char *buf, int bufLen, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, buf, bufLen,fNull)); 
} 

Retcode mytable::getField(char *fldName, void *buf, int bufLen, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, buf, bufLen,fNull)); 
} 

Retcode mytable::getField(char *fldName, double& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode mytable::getField(char *fldName, INT16& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode mytable::getField(char *fldName, INT32& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode mytable::getField(char *fldName, BDate& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode mytable::putField(FIELDNUMBER fldnbr, const void *buf) 
{
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  switch (desc.fldType) 
  { 
    case fldChar: 
      if (desc.fldLen < strlen((char *) buf)) 
        return(lastError = PXERR_BUFTOOSMALL);	
      strcpy((char *)fldPtr[fldnbr-1],(char *) buf); 
      return(lastError = PXSUCCESS); 
    case fldShort: 
      *((short *) fldPtr[fldnbr-1]) = *((short *) buf); 
      return(lastError = PXSUCCESS); 
    case fldLong: 
      *((long *) fldPtr[fldnbr-1]) = *((long *) buf); 
      return(lastError = PXSUCCESS); 
    case fldDouble: 
      *((double *) fldPtr[fldnbr-1]) = *((double *) buf); 
      return(lastError = PXSUCCESS);	
    case fldDate:  
      *((BDate *) fldPtr[fldnbr-1]) = *((BDate *) buf);
      return(lastError = PXSUCCESS); 
    default: 
      return(lastError = PXERR_TYPEMISMATCH);   
  }
}

Retcode mytable::putField(FIELDNUMBER fldnbr, const char *buf) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld((void *) buf, fldChar, strlen(buf), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode mytable::putField(FIELDNUMBER fldnbr, double val) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldDouble, sizeof(double), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode mytable::putField(FIELDNUMBER fldnbr, INT16 val) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldShort, sizeof(short), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode mytable::putField(FIELDNUMBER fldnbr, INT32 val) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldLong, sizeof(long), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode mytable::putField(FIELDNUMBER fldnbr, const BDate& val) 
{ 
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = mytable_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld((void *) &val, fldDate, sizeof(BDate), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode mytable::putField(char *fldName, const char *buf) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, buf)); 
} 

Retcode mytable::putField(char *fldName, const void *buf) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, buf)); 
} 

Retcode mytable::putField(char *fldName, double val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode mytable::putField(char *fldName, INT16 val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode mytable::putField(char *fldName, INT32 val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode mytable::putField(char *fldName, const BDate& val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

BOOL mytable::isNull(FIELDNUMBER fldnbr) 
{
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
  { 
    lastError = PXERR_INVFIELDHANDLE; 
    return(0);   
  } 
  return(nullVec[(fldnbr-1) / 8] & ((char) 1 << ((fldnbr-1) % 8))); 
}

BOOL mytable::isNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(0);  
  return(nullVec[(fld-1) / 8] & ((char) 1 << ((fld-1) % 8))); 
} 

Retcode mytable::setNull(FIELDNUMBER fldnbr)
{
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  nullVec[(fldnbr-1) / 8] |= ((char)1 << ((fldnbr-1) % 8)); 
  return(lastError = PXSUCCESS);
}

Retcode mytable::setNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  nullVec[(fld-1) / 8] |= ((char)1 << ((fld-1) % 8)); 
  return(lastError = PXSUCCESS);
} 

Retcode mytable::clearNull(FIELDNUMBER fldnbr)
{
  if (fldnbr > mytable_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  nullVec[(fldnbr-1) / 8] &= ~ ((char)1 << ((fldnbr-1) % 8)); 
  return(lastError = PXSUCCESS);
}

Retcode mytable::clearNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  nullVec[(fld-1) / 8] &= ~ ((char)1 << ((fld-1) % 8)); 
  return(lastError = PXSUCCESS);
} 

Retcode mytable::preprocess() 
{
  return(lastError = PXSUCCESS);
}

Retcode mytable::postprocess() 
{
  return(lastError = PXSUCCESS);
}

char * mytable::nameOf() const 
{
  return("mytable"); 
} 
