//*********************** Display.cpp ********************
//
// This file contains a routine which will display
// information about a table.
// Notice that field 4, which is of type BCD, is
// displayed as being a BLOb field. Custom Records treat
// user defined types as BLOb fields. Note, Custom
// Records do nothing to a BLOb field by default, but
// functionality can be added.
//

#include <all.h>
#pragma hdrstop

const char *FLDTYPE[] = { { "Unknown" }, { "Unknown" }, { "Date" } ,
			  { "BLOb" }, { "Unknown" }, { "Short" },
			  { "Long" }, { "Double" }, { "Unknown" },
			  { "Char" } } ;

void display_info( void )
{
       FIELDNUMBER fldNum ;
       FIELDNUMBER count = ( ( bcdfld::bcdfld_CRFldMap )->fieldCnt ) ;

       cout << endl ;
       cout << "Instances using this descriptor: "
	    << ( bcdfld::bcdfld_CRFldMap )->useCnt << endl ;
       cout << "Number of Fields in custom record _bcdfld_: "
            << count << endl << endl ;

       cout << "Number   Name            Type     Subtype"
	    << "   Length   Field in Table" << endl ;
       cout << "-----------------------------------------"
	    << "--------------------------" << endl ;
       for ( fldNum = 0 ; fldNum < count; fldNum++)
       {
	      cout << setw( 4 ) << setiosflags( ios::right )
		   << ( bcdfld::bcdfld_CRFldMap )->desc[fldNum].fldNum
		   << "     " << setw( 15 ) << setiosflags( ios::left )
		   << ( bcdfld::bcdfld_CRFldMap )->desc[fldNum].fldName
		   << " " << setw( 7 )
		   << FLDTYPE[( bcdfld::bcdfld_CRFldMap )->desc[fldNum].fldType]
		   << setw( 6 ) << setiosflags( ios::right )
		   << ( bcdfld::bcdfld_CRFldMap )->desc[fldNum].fldSubtype
		   << setw( 10 )
		   << ( bcdfld::bcdfld_CRFldMap )->desc[fldNum].fldLen
		   << setw( 12 )
		   << ( bcdfld::bcdfld_CRFldMap )->tblFldNbr[fldNum]
		   << endl ;
       }
}//**************************** end of Display *************************

