//            bcdfld.cpp 

#include "envdef.h"
#include "bcdfld.H"
#include <stdlib.h> 
#include <string.h> 
#include <stdio.h> 
#include <malloc.h> 

CRFldMapdef *bcdfld::bcdfld_CRFldMap = 0;  // Declare & init static var 

#define loadDesc(fld,fname,ftype,fstype,flen,tnum)   {\
                   bcdfld_CRFldMap->desc[fld].fldNum = fld + 1; \
                   _fstrcpy(bcdfld_CRFldMap->desc[fld].fldName,fname); \
                   bcdfld_CRFldMap->desc[fld].fldType = ftype; \
                   bcdfld_CRFldMap->desc[fld].fldSubtype = fstype; \
                   bcdfld_CRFldMap->desc[fld].fldLen = flen; \
                   bcdfld_CRFldMap->tblFldNbr[fld] = tnum; } 

Retcode convertFld(void *, PXFieldType, int,     // Source pointer, type, length. 
                   void *, PXFieldType, int);    // Destination pointer, type, length. 

bcdfld::bcdfld(BCursor *cursor) : BRecord(cursor) 
{ 
  if (bcdfld_CRFldMap == 0) 
  { 
    bcdfld_CRFldMap = new CRFldMapdef; 
    bcdfld_CRFldMap->useCnt = 0; 
    bcdfld_CRFldMap->fieldCnt = 4; 
    bcdfld_CRFldMap->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) * 4); 
    bcdfld_CRFldMap->tblFldNbr = new FIELDNUMBER[4]; 
    loadDesc(0,"Exponent",fldShort,fldstNone,0,1); 
    loadDesc(1,"Mantissa_1",fldLong,fldstNone,0,2); 
    loadDesc(2,"Mantissa_2",fldLong,fldstNone,0,3); 
    loadDesc(3,"data",fldBlob,fldstNone,0,0); 
  } 
  bcdfld_CRFldMap->useCnt++; 
  fldPtr =  new void *[4]; 
  fldPtr[0] = &Exponent; 
  fldPtr[1] = &Mantissa_1; 
  fldPtr[2] = &Mantissa_2; 
  fldPtr[3] = &data; 
} 

bcdfld::~bcdfld() 
{ 
  delete [] fldPtr; 
  if ( --bcdfld_CRFldMap->useCnt == 0) 
  {				       
    delete [] bcdfld_CRFldMap->tblFldNbr; 
    _ffree(bcdfld_CRFldMap->desc);	  
    delete bcdfld_CRFldMap;		  
    bcdfld_CRFldMap = 0;		  
  }  				  
} 

Retcode bcdfld::clear() 
{ 
  for (int i=0; i < sizeof nullVec; i++) 
    nullVec[i] = 0xFF; 
  return(lastError = PXSUCCESS); 
} 

FIELDNUMBER bcdfld::getFieldNumber(const char *fldName) 
{ 
  lastError = PXSUCCESS; 
  for (int i=0; i < bcdfld_CRFldMap->fieldCnt; i++) 
    if ( ! _fstrcmp(bcdfld_CRFldMap->desc[i].fldName, (char far *) fldName)) 
      return(i+1); 
  lastError = PXERR_INVFIELDNAME; 
  return(0); 
} 

FIELDNUMBER bcdfld::getTblFieldNumber(FIELDNUMBER fldnbr) 
{
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
  { 
    lastError = PXERR_INVFIELDHANDLE; 
    return(0);   
  } 
  lastError = PXSUCCESS; 
  return(bcdfld_CRFldMap->tblFldNbr[fldnbr-1]);
}

int bcdfld::getFieldCount() 
{ 
  lastError = PXSUCCESS; 
  return(bcdfld_CRFldMap->fieldCnt); 
} 

Retcode bcdfld::getFieldDesc(FIELDNUMBER fldnbr, FieldDesc& desc) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt || fldnbr < 1) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  desc = bcdfld_CRFldMap->desc[fldnbr-1];
  return(lastError = PXSUCCESS); 
}

Retcode bcdfld::getFieldDesc(FIELDNUMBER     fldnbr,  
                          PXFieldType    &fldType, 
                          PXFieldSubtype &fldSubtype, 
                          int            &fldLen) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt || fldnbr < 1) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  fldType = bcdfld_CRFldMap->desc[fldnbr-1].fldType; 
  fldSubtype = bcdfld_CRFldMap->desc[fldnbr-1].fldSubtype; 
  fldLen  = bcdfld_CRFldMap->desc[fldnbr-1].fldLen; 
  return(lastError = PXSUCCESS); 
}

Retcode bcdfld::getField(FIELDNUMBER fldnbr, 
                      void *buf, int bufLen, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt || fldnbr < 1)
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  switch (desc.fldType) 
  {
    case fldChar: 
      if (desc.fldLen > bufLen && 
         strlen((char *) fldPtr[fldnbr-1]) >= bufLen) 
      {
        strncpy((char *)buf,(char *)fldPtr[fldnbr-1],bufLen); 
        return(lastError = PXERR_BUFTOOSMALL);  
      }
      strcpy((char *)buf,(char *)fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	
    case fldShort:	   
      if (bufLen < sizeof(short)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((short *) buf) = *((short *) fldPtr[fldnbr-1]); // slater
      return(lastError = PXSUCCESS);	 
    case fldLong:	   
      if (bufLen < sizeof(long)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((long *) buf) = *((long *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);	 
    case fldDouble: 
      if (bufLen < sizeof(double)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((double *) buf) = *((double *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS); 
    case fldDate: 
      if (bufLen < sizeof(BDate)) 
        return(lastError = PXERR_BUFTOOSMALL); 
      *((BDate *) buf) = *((BDate *) fldPtr[fldnbr-1]); 
      return(lastError = PXSUCCESS);
    default:
      return(lastError = PXERR_TYPEMISMATCH);
  }
}

Retcode bcdfld::getField(FIELDNUMBER fldnbr, 
                      char *buf, int bufLen, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
                               (void *) buf, fldChar, bufLen)); 
} 

Retcode bcdfld::getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldDouble, sizeof(double)));
} 

Retcode bcdfld::getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldShort, sizeof(short)));
} 

Retcode bcdfld::getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
			           &val, fldLong, sizeof(long)));
} 

Retcode bcdfld::getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  fNull = isNull(fldnbr); 
  if (fNull) 
    return(lastError = PXSUCCESS); 
  return(lastError = convertFld(fldPtr[fldnbr-1], desc.fldType, desc.fldLen,
				   &val, fldDate, sizeof(BDate)));
} 

Retcode bcdfld::getField(char *fldName, char *buf, int bufLen, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, buf, bufLen,fNull)); 
} 

Retcode bcdfld::getField(char *fldName, void *buf, int bufLen, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, buf, bufLen,fNull)); 
} 

Retcode bcdfld::getField(char *fldName, double& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode bcdfld::getField(char *fldName, INT16& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode bcdfld::getField(char *fldName, INT32& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode bcdfld::getField(char *fldName, BDate& val, BOOL& fNull) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(getField(fld, val, fNull)); 
} 

Retcode bcdfld::putField(FIELDNUMBER fldnbr, const void *buf) 
{
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  switch (desc.fldType) 
  { 
    case fldChar: 
      if (desc.fldLen < strlen((char *) buf)) 
        return(lastError = PXERR_BUFTOOSMALL);	
      strcpy((char *)fldPtr[fldnbr-1],(char *) buf); 
      return(lastError = PXSUCCESS); 
    case fldShort: 
      *((short *) fldPtr[fldnbr-1]) = *((short *) buf); 
      return(lastError = PXSUCCESS); 
    case fldLong: 
      *((long *) fldPtr[fldnbr-1]) = *((long *) buf); 
      return(lastError = PXSUCCESS); 
    case fldDouble: 
      *((double *) fldPtr[fldnbr-1]) = *((double *) buf); 
      return(lastError = PXSUCCESS);	
    case fldDate:  
      *((BDate *) fldPtr[fldnbr-1]) = *((BDate *) buf);
      return(lastError = PXSUCCESS); 
    default: 
      return(lastError = PXERR_TYPEMISMATCH);   
  }
}

Retcode bcdfld::putField(FIELDNUMBER fldnbr, const char *buf) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld((void *) buf, fldChar, strlen(buf), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode bcdfld::putField(FIELDNUMBER fldnbr, double val) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldDouble, sizeof(double), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode bcdfld::putField(FIELDNUMBER fldnbr, INT16 val) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldShort, sizeof(short), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode bcdfld::putField(FIELDNUMBER fldnbr, INT32 val) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld(&val, fldLong, sizeof(long), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode bcdfld::putField(FIELDNUMBER fldnbr, const BDate& val) 
{ 
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  FieldDesc far &desc = bcdfld_CRFldMap->desc[fldnbr-1]; 
  clearNull(fldnbr); 
  return(lastError = convertFld((void *) &val, fldDate, sizeof(BDate), 
                            fldPtr[fldnbr-1], desc.fldType, desc.fldLen));
} 

Retcode bcdfld::putField(char *fldName, const char *buf) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, buf)); 
} 

Retcode bcdfld::putField(char *fldName, const void *buf) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, buf)); 
} 

Retcode bcdfld::putField(char *fldName, double val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode bcdfld::putField(char *fldName, INT16 val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode bcdfld::putField(char *fldName, INT32 val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

Retcode bcdfld::putField(char *fldName, const BDate& val) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  return(putField(fld, val)); 
} 

BOOL bcdfld::isNull(FIELDNUMBER fldnbr) 
{
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
  { 
    lastError = PXERR_INVFIELDHANDLE; 
    return(0);   
  } 
  return(nullVec[(fldnbr-1) / 8] & ((char) 1 << ((fldnbr-1) % 8))); 
}

BOOL bcdfld::isNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(0);  
  return(nullVec[(fld-1) / 8] & ((char) 1 << ((fld-1) % 8))); 
} 

Retcode bcdfld::setNull(FIELDNUMBER fldnbr)
{
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  nullVec[(fldnbr-1) / 8] |= ((char)1 << ((fldnbr-1) % 8)); 
  return(lastError = PXSUCCESS);
}

Retcode bcdfld::setNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  nullVec[(fld-1) / 8] |= ((char)1 << ((fld-1) % 8)); 
  return(lastError = PXSUCCESS);
} 

Retcode bcdfld::clearNull(FIELDNUMBER fldnbr)
{
  if (fldnbr > bcdfld_CRFldMap->fieldCnt) 
    return(lastError = PXERR_INVFIELDHANDLE); 
  nullVec[(fldnbr-1) / 8] &= ~ ((char)1 << ((fldnbr-1) % 8)); 
  return(lastError = PXSUCCESS);
}

Retcode bcdfld::clearNull(const char *fldName) 
{ 
  FIELDNUMBER fld;  
  if ((fld = getFieldNumber(fldName)) == 0) 
    return(lastError);  
  nullVec[(fld-1) / 8] &= ~ ((char)1 << ((fld-1) % 8)); 
  return(lastError = PXSUCCESS);
} 

Retcode bcdfld::preprocess() 
{
  return(lastError = PXSUCCESS);
}

Retcode bcdfld::postprocess() 
{
  return(lastError = PXSUCCESS);
}

char * bcdfld::nameOf() const 
{
  return("bcdfld"); 
} 
