/* VC.H - header file for the Visual Calculator                    */
/* Copyright (c) 1994 Coronado Enterprises                         */


struct vars{            /* variable storage                        */
   char varname[7];     /* variable name A-F & I-N                 */
   char outtype;        /* output format for variable              */
   double value;        /* value of the variable                   */
};                      /*                                         */

                        /*                                         */
struct lines{           /* dynamic structure for transcripts       */
   struct lines *dn;    /* next transcript line                    */
   struct lines *up;    /* last transcript line                    */
   char *lineloc;       /* point to dynamic location of line       */
   int linelngt;        /* length of line stored here              */
   char isvalue;        /* 1 = calculated value, 0 = none          */
   char marked;         /* 1 = line marked, 0 = not marked         */
   char strval[13];     /* string representation of variable       */
};                      /*                                         */


   /* Prototypes for files in VC.C                                 */
void readline(void);    /* read an input line from the keyboard    */
void parse(void);       /* parse the input line                    */
void errout(void);      /* output error message to display         */


   /* prototypes for files in DATA.C                               */
                        /* initialize data and fields              */
void initdata(struct vars *pnt);
void getnames(void);    /* get new variable names                  */
                        /* do the calculations                     */
void calcdata(double *newval);
                        /* do the four function calculations       */
void calcdat(double *number1, char *op1, double *number2);
double getnum(void);    /* get the value of the number             */
char getop(void);       /* get the math operator                   */
void errchk(int err);   /* check for error messages                */


   /* prototypes for functions in FILE.C                           */
void fileout(void);     /* store transcript in a file              */
void filein(void);      /* retrieve transcript from a file         */
                        /* store a transcript message              */
void strtrans(char line[], int type);
void transout(void);    /* display the current transcript          */
                        /* move the arrow up or down               */
void movarrow(int where);
