/*******************************************************************/
/* LISTF.C - working functions for LIST.EXE                        */
/* Copyright (c) 1994 Coronado Enterprises                         */
/*                                                                 */
/* This module contains the functions called by the LIST.C program */
/*  program.  They are very specific to that program rather than   */
/*  being generic in nature, so they are not considered reusable.  */
/*******************************************************************/

#include <stdio.h>           /* standard I/O header file           */
#include <string.h>          /* prototypes for strings             */

   /* The following group of #include's are not ANSI compatible,   */
   /*  so they may not work with your compiler.  They are a part   */
   /*  of the Microsoft Visual C++ compiler version 1.0. They are  */
   /*  used only in the get_file_date_time function in this file.  */
#include <dos.h>             /* used for get_file_date_time        */
#include <errno.h>           /* used for get_file_date_time        */
#include <fcntl.h>           /* used for get_file_date_time        */
#include <share.h>           /* used for get_file_date_time        */

#include "listf.h"           /* custom prototypes                  */
#define MAXLINES 55          /* maximum number of lines per page   */
#define MAXCHARS 255         /* maximum size of a line             */
#define MAXFILENAME 80       /* max length of path and filename    */
#define MAXPRINTLINE 72      /* max characters on one printer line */

int  line_number = 1;        /* line number initialized to one     */
int  page_number = 1;        /* page number initialized to one     */
int  lines_this_page = 0;    /* lines on this page so far          */
char oneline[MAXCHARS + 1];  /* input string buffer area           */
char filename[MAXFILENAME + 1];  /* filename from header or prompt */
char file_date_time[50];     /* formatted date and time storage    */
FILE *in_file;               /* pointer to file to be read         */
FILE *printer;               /* pointer to printer                 */



/**************************************************** open_in_file */
/* This function opens the input file named on the command line,   */
/*  if there was one defined.  Otherwise, it requests a file name  */
/*  to open and opens the requested file.  It continues to ask for */
/*  a file name until a valid filename is entered, up to 3 times   */
/*******************************************************************/
int open_in_file(int no, char *name)
{
int index, count;

   strcpy(filename, name);     /* copy name for printing header    */
   if (no == 2) {              /* 2nd field in command is filename */
      get_file_date_time();
      in_file = fopen(name, "r");   /* open requested file         */
      if (in_file == NULL)     /* NULL if file doesn't exist       */
         printf("Filename on command line doesn't exist!\n");
      else
         return 0;             /* file opened correctly, return    */
   }

   if (in_file == NULL) {      /* filename was not on command line */
         /* Give user three chances to enter a filename, then quit.*/
      for (index = 0 ; index < 3 ; index++) {
         printf("Enter filename -> ");

            /* There is no string input with a limited number of   */
            /*  characters, so we must write our own.  This loop   */
            /*  limits number of chars in the input filename.      */
         for (count = 0 ; count <= MAXFILENAME ; count++) {
            filename[count] = getchar(); /* get a char from keybrd */
            if (filename[count] == '\n') {
               filename[count] = 0;
               break;
            }
         }                                                           
                                /* We must guarantee a terminating */
         filename[count] = 0;   /* null if the loop completes      */
         
         get_file_date_time();
         in_file = fopen(filename, "r"); /* open file              */
         if (in_file == NULL)          /* NULL if file didn't open */
            printf("Filename doesn't exist, try again.\n");
         else
            return 0;       /* input file opened correctly, return */
      }
   } 
   printf("Three times is enough, aborting list program\n");
   return 1;                /* error return, file not opened       */
}



/**************************************************** open_printer */
/* This function opens the printer for ASCII output.               */
/*******************************************************************/
int open_printer(void)
{
   printer = fopen("PRN", "w"); /* open printer file               */
   if (printer == NULL) {
      printf("Printer not ready, aborting list program\n");
      return 1;                 /* error return, printer not ready */
   } else {
      return 0;                 /* return with the printer opened  */
   }
}



/********************************************** get_file_date_time */
/* This is a local function that is only called from inside this   */
/*  file.  It retrieves the date and time from the file under      */
/*  consideration and formats them for the header. It used some    */
/*  functions that are not ANSI compatible so it may be unusable   */
/*  with other compilers.                                          */
/*******************************************************************/
void get_file_date_time(void)
{
int file_handle;
unsigned f_date;
unsigned f_time;
int hour, minute;
int month, day, year;

   strcpy(file_date_time, "");     /* blank string if it fails     */
   
   if (_dos_open(filename, _O_RDONLY, &file_handle) == 0)
      _dos_getftime(file_handle, &f_date, &f_time);

      hour   = (f_time >> 11) & 0x1f;
      minute = (f_time >> 5)  & 0x3f;
      day    =  f_date        & 0x1f;
      month  = (f_date >> 5)  & 0xf;
      year   = (f_date >> 9)  + 1980;
      sprintf(file_date_time, "%d:%d %d/%d/%d", 
                                     hour, minute, month, day, year);

      _dos_close(file_handle);
}



/*************************************************** read_one_line */
/* This routine reads one line of text.  If fgets returns a zero,  */
/*  it has read the entire file, so it returns a value of zero to  */
/*  the calling program.  If fgets returns a valid pointer to the  */
/*  new line of text read in this function returns an int value    */
/*  of 1 to the calling program.                                   */
/*******************************************************************/
int read_one_line(void)
{
   oneline[0] = 0;   /* if nothing is read, this blanks the line   */
   if (fgets(oneline, MAXCHARS, in_file))
      return 1;  /* valid line of text found and stored in oneline */
   else
      return 0;  /* end of file or error condition found, no text  */
}



/***************************************************** top_of_page */
/* This routine checks to see if a header needs to be printed. It  */
/*  also checks for the end of a page and spaces the paper up.     */
/*******************************************************************/
void top_of_page(void)
{
int count;

   if (line_number == 1)     /* top of page 1, need a header       */
      ;                      /* continue and let the header print  */
   else {
      if (lines_this_page >= MAXLINES)  /* at bottom of page ?     */
         eject_page();
      else
         return;             /* no action needed, return           */
   }

      /* list the filename and page number on the monitor          */
   printf("   Source file %s  Page number %d\n",
                                              filename, page_number);

      /* print the header information                              */
      /* count will be set to the number of characters output      */
   count = fprintf(printer, "\n     Source file --> %s   %s", 
                                           filename, file_date_time);
   for (/* count is set */ ; count < 70 ; count++)
      fprintf(printer, " ");       /* print blanks until column 70 */
   fprintf(printer, "Page %d\n\n", page_number);
   page_number++;
   lines_this_page = 0;
}



/************************************************** print_one_line */
/* This routine prints a line of text using a maximum of 72 chars  */
/*  on a line.  Tabs are converted into three spaces, and lines    */
/*  that are too long will have no CR/LF, so one is output.        */
/*******************************************************************/
void print_one_line(void)
{
unsigned index;
unsigned char_count = 0;

   fprintf(printer, "%6d ", line_number); /* line number & 1 space */
   
   for (index = 0 ; index < strlen(oneline) ; index++) {
      if (char_count >= MAXPRINTLINE) {  /* if at edge of paper    */
         fprintf(printer, "\n       ");  /* start a new line       */
         lines_this_page++;              /* add to physical lines  */
         char_count = 0;                 /* reset char count       */
      }
      if (oneline[index] == '\t') {      /* if it is a tab         */
         fprintf(printer, "   ");        /* print 3 spaces         */
         char_count += 3;
      } else {
         fprintf(printer, "%c", oneline[index]);
         char_count++;
      }
   }

         /* this outputs a newline if there is not one in the line */
   if (oneline[strlen(oneline) - 1] != '\n')
      fprintf(printer, "%c", '\n');
      
   lines_this_page++;   
   line_number++;
}



/****************************************************** eject_page */
/* This routine ejects the page and sets the current page line     */
/*  count to zero.                                                 */
/*******************************************************************/
void eject_page(void)
{
const int FF = 12;    /* 12 = formfeed character                   */

   fprintf(printer, "%c", FF);
}



/************************************************ close_both_files */
/* This function simply closes both files.  Nothing to check.      */
/*******************************************************************/
void close_both_files(void)
{
   fclose(in_file);
   fclose(printer);
}
