/* VIDEO.H - header file for the Visual Calculator                 */
/* Copyright (c) 1994 Coronado Enterprises                         */

#define BLANK   (unsigned char)32
#define HORIZ   (unsigned char)205
#define VERT    (unsigned char)186
#define U_LEFT  (unsigned char)201
#define U_RIGHT (unsigned char)187
#define L_LEFT  (unsigned char)200
#define L_RIGHT (unsigned char)188
#define T_DOWN  (unsigned char)203
#define T_LEFT  (unsigned char)185
#define T_RIGHT (unsigned char)204
#define T_UP    (unsigned char)202


/* prototypes for functions in VIDEO.C                             */
void monitor(void);     /* determine the type of monitor           */
void bkgndvid(void);    /* display video background                */
                        /* display all values                      */
void valusvid(struct vars *allvars);
                        /* display the new changed variable        */
void disnew(int varinuse, struct vars *allvars);
void helpm(void);       /* display mathematics help messages       */
void helps(void);       /* display system help messages            */
void linedisp(int line);/* display a line to video (with attr)     */
                        /* display a line with value attr          */
void strngdis_val(int row, int col);
                        /* display a line with help attr           */
void strngdis_help(int row, int col);
                        /* display a line with trns attr           */
void strngdis_trns(int row, int col);
                        /* display a line (add attr)               */
void strngdis(int row, int col, int attr);
                        /* outputs blanks to a video line          */
void blnkline(int row, int col);
                        /* display single character with trns attr */
void chardis_trns(int row, int col, int ch);
                        /* display single character                */
void chardis(int row, int col, int attr, int ch);
void errdis(char str[]);/* display error message to screen         */
void clrscrn(void);     /* clear the video monitor                 */
                        /* position the cursor on the monitor      */
void poscurs(int row, int col);
int prtprblm(void);     /* printer problem check                   */
