// tabdlg.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "tabdlg.h"

#include "mainfrm.h"
#include "tabdoc.h"
#include "tabview.h"

#include "taboptns.h"

#include "ctabdlg.h"	// The dialog tab
#include "tstdlg1.h"	// The dialogs being placed on tabs
#include "tstdlg2.h"	// The dialogs being placed on tabs
#include "tabstate.h"	// The dialogs being placed on tabs
#include "tabgoto.h"	// The dialogs being placed on tabs


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTabdlgApp

BEGIN_MESSAGE_MAP(CTabdlgApp, CWinApp)
	//{{AFX_MSG_MAP(CTabdlgApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(IDM_TEST_TAB_DIALOG, OnTestTabDialog)
	ON_COMMAND(IDM_TAB_OPTIONS, OnTabOptions)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabdlgApp construction

CTabdlgApp::CTabdlgApp()
{
	m_bGlobalSetting = FALSE;	// Default, tabs can have separate parameter options
	
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTabdlgApp object

CTabdlgApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CTabdlgApp initialization

BOOL CTabdlgApp::InitInstance()
{
	EnableVBX();
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	AddDocTemplate(new CSingleDocTemplate(IDR_MAINFRAME,
			RUNTIME_CLASS(CTabdlgDoc),
			RUNTIME_CLASS(CMainFrame),     // main SDI frame window
			RUNTIME_CLASS(CTabdlgView)));


	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}
	
	CTabDialog		dlg(0, NULL, 0);		// Create a bogus instance of the class
		
	dlg.GetTopTabSetting(m_bBottomFill, m_bBottomUniform);
	dlg.GetTopTabSetting(m_bTopFill, m_bTopUniform);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CTabdlgApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CTabdlgApp commands


void CTabdlgApp::OnTestTabDialog()
{
	CTabDialog		dlg(IDD_TAB_FRAME_DLG, NULL, IDC_TABFRAME);		// 1st create a TabDlg object
	
	// Configure the tab using the users settings
	if (m_bGlobalSetting)
		dlg.SetTabSetting(m_bTopFill, m_bTopUniform);
	else
	{
		dlg.SetTopTabSetting(m_bTopFill, m_bTopUniform);
		dlg.SetBottomTabSetting(m_bBottomFill, m_bBottomUniform);
	}
	
	// Construct each CTabDialogItem derived dialog which is being placed on a tab.
	//  There may not be any duplicate control IDs between them in this version
	CTestDlg1	dlg1;
	CTestDlg2	dlg2;
	CTabState	dlg3;
	CTabGoto	dlg4;
	
	// Next add each dialog to a tab
	int iTab1 = dlg.AddDialogTab("Long Card&1", &dlg1);
	int iTab2 = dlg.AddDialogTab("Card1&a", &dlg2);
	int iTab3 = dlg.AddDialogTab("&Enable", &dlg3);
	int iTab4 = dlg.AddDialogTab("&Goto Card", &dlg4, CTabDialog::TAB_BOTTOM);
	
	// Tell the Enable test dialog the ID's of each TAB
	dlg3.m_iTab1 = iTab1;
	dlg3.m_iTab2 = iTab2;
	
	// Tell the Goto test dialog the ID's of each TAB
	dlg4.m_iTab1 = iTab1;
	dlg4.m_iTab2 = iTab2;
	dlg4.m_iTab3 = iTab3;
	
	// Finally, display the finished dialog
	if (dlg.DoModal() == IDOK)
	{
		// Retrive dialog data
	}
}

void CTabdlgApp::OnTabOptions()
{
	CTabOptions dlg;
	
	dlg.m_bBottomFill = m_bBottomFill;
	dlg.m_bBottomUniform = m_bBottomUniform;
	dlg.m_bTopFill = m_bTopFill;
	dlg.m_bTopUniform = m_bTopUniform;
	dlg.m_bGlobalSetting = m_bGlobalSetting;
	
	if (dlg.DoModal() == IDOK)
	{
		m_bBottomFill = dlg.m_bBottomFill;
		m_bBottomUniform = dlg.m_bBottomUniform;
		m_bTopFill = dlg.m_bTopFill;
		m_bTopUniform = dlg.m_bTopUniform;
		m_bGlobalSetting = dlg.m_bGlobalSetting;
	}
}
