// tabdlg.h : header file
//

#ifndef __CTABDLG_H__
#define __CTABDLG_H__

const int THICK_BORDER = 2;

// The default CTabDialog constructor uses these values to reference the dialog template and
//  the ID of the frame control for a tabbed dialog.  If your values are other than the defaults,
//  which is usually the case be sure to pass the values inthe CTabDialog constructor.
#define	IDD_TAB_FRAME_DLG	3000	/* The dialog resource */
#define	IDC_TABFRAME		3001	/* A frame object used to paint the tabbed dialogs into */
#define IDB_SCROLL_LEFT		32000	/* The ID of the left scroll button */
#define IDB_SCROLL_RIGHT	32001	/* The ID of the right scroll button */

#define TAB_CORNER_OFFSET	.66		/* The amount of the TAB that is visible (2/3rds) */

// Structures of stuff loaded into memory when building the dialogs which are located on a tab
#pragma pack(1)
struct DialogBoxHeader
{
	DWORD	lStyle;
	BYTE	bNumberOfItems;
	WORD	x;
	WORD	y;
	WORD	cx;
	WORD	cy;
	char	szMenuName;		// 1st character of menu name, others follow
//	char	szMenuName[];	// This is what the rest looks like
//	char	szCaption[];
//	WORD	wPointSize;		// Only if DS_SETFONT 
//	char	szFaceName[];	// Only if DS_SETFONT
};

struct ControlData
{
	RECT	rc;
	//WORD	x;
	//WORD	y;
	//WORD	cx;
	//WORD	cy;
	WORD	wID;
	DWORD	lStyle;
	BYTE	bclass;			// Either the class w/high bit set, or an szClass text
//	union
//	{
//		BYTE	class;
//		char	szClass[];
//	} ClassID;
//	szText;
};
#pragma pack()


//////////////////////////////////////////////////////////////////////////////
// CTabDialogItem - This is the base class used for any CDialog object which
//	will be placing itself on a tab in the CTabDialog box.  The virtual functions
//	are used to gain access to specific functions within the derived class.
//	The derived class should NOT create a dialog during the constructor since
//	this will be done by the CTabDialog object.  The CTabDialog will manage the
//  creation, size, position, state and finally deletion of the dialog.  Use of
//  DDX/DDV routines will function as expected.

// Replace the old base class (CDialog) with the new base class.  There will
//  be 3 places this must be done.  The 1st is in the header file where the class
//  is defined.  The 2nd is in the constructor.  Change the call to the base class.
//  The 3rd is in the implimentation file where BEGIN_MESSAGE_MAP() is defined.
// Changing the CDialog reference in the call to DoDataExchange() is optional
//  and should be done to complete the circle.

// If you add handlers (WM_PAINT or WM_LBUTTONDOWN) in this class please be sure that you
//   call the base class' On<message> handler so it may do it's thing as well.

class CTabDialog;		// Forward declaration
class CTab;				// Forward declaration

class CTabDialogItem : public CDialog
{
	// Member data
	private:
		UINT			m_uiDialogResourceID;
		CTabDialog		*m_pCTabDialog;
		
	public:
		CTabDialogItem(const UINT nidTemplate, CWnd *pParentWnd) : CDialog(nidTemplate, pParentWnd) {m_uiDialogResourceID = nidTemplate; }
		virtual ~CTabDialogItem() {}
		
		UINT GetDlgResource() const { return m_uiDialogResourceID; }
		BOOL InitChildDialog(CTabDialog *pTheCreator) { ASSERT(pTheCreator != NULL); m_pCTabDialog = pTheCreator; return (BOOL)SendMessage(WM_INITDIALOG); }
		
		virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
		
		// The following 2 functions are called when a tab is hidden, or reshown.  Overload this function
		//  to perform stuff on a per dialog instance (i.e. SetWindowText, Hide VBX controls which don't
		//  get hidden automatically).
		virtual void Hide() { TRACE0("HIDE\n"); }
		virtual void Show() { TRACE0("SHOW\n"); }
		
		int EnableTab(const int iTabId, const BOOL bEnable = TRUE);		// Called to modify the state of a tab
		int GetTabState(const int iTabId, BOOL & bEnable);				// Called to get the current state of a tab
		int SelectTab(const int iTabId);								// Called to change to another tab

		// Generated message map functions
		//{{AFX_MSG(CTabDialogItem)
			afx_msg void OnPaint();
			afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
		//}}AFX_MSG
		DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CTabDialog dialog

class CTabDialog : public CDialog
{                       
	// Member varaables
	private:
		UINT			m_iDialogFrame;		// The tab frame control's ID
		UINT			m_uiBorderWidth;	// The width of the border around the tabs
		UINT			m_uiTopCount;		// Number of tabs with TOP position
		UINT			m_uiBottomCount;	// Number of tabs with BOTTOM position
		CTab			*m_pActiveTab;		// The active (displayed) tab dialog
		CPtrList		m_DialogTabList;	// A list of dialogs placed on tabs
		CRect			m_rectFrame;		// Rectangle of frame used for alignment
		CSize			m_sizeTabTop;		// Size of tabs on the top
		CSize			m_sizeTabBottom;	// Size of tabs on the bottom
		
		// Variables for tab dialog options
		BOOL			m_bUniformTop;		// Tabs along the top have a uniform size. FALSE overrides FillTop
		BOOL			m_bUniformBottom;	// Tabs along the bottom have a uniform size. FALSE overrides FilBottom
		BOOL			m_bFillTop;			// Tabs along the top use the entire edge. Implies "Uniform Size"
		BOOL			m_bFillBottom;		// Tabs along the bottom use the entire edge. Implies "Uniform Size"
		
		static BOOL	CTabInitActive;			// TRUE if CTabDialog is executing within InitDialog
	
		// Dialog Data
		//{{AFX_DATA(CTabDialog)
			enum { IDD = IDD_TAB_FRAME_DLG };
		//}}AFX_DATA
		
	public:
		// Error which may be returned
		enum
		{
			TAB_DUPLICATED = -1,
			TAB_MEMORY_ERROR = -2,
			TAB_NON_PRESENT = -3,
			TAB_NOT_ENABLED = -4,
			TAB_ALREADY_SELECTED = -5,
			TAB_ILLEGAL_POSITION = -6,
			TAB_ILLEGAL_STATE = -7
		};
		
		enum
		{
			TAB_TOP = 0,
			TAB_BOTTOM
		};
		
	// Member functions
	public:
		CTabDialog(UINT uiTemplate = CTabDialog::IDD, CWnd *pParent = NULL, const int uiDialogFrame = IDC_TABFRAME, const UINT uiBorderWidth = THICK_BORDER);
		virtual ~CTabDialog();
		
		// Add a CTabDialogItem derived object to a tab
		int AddDialogTab(const CString &tabString, CTabDialogItem *pDlg, const UINT uiTabLoc = TAB_TOP, const BOOL bTabEnabled = TRUE);
		
		// You can set all tabs to the same orientation using these functions
		void GetTabSetting(BOOL & bFillSpace, BOOL & bUniform) { bFillSpace = m_bFillTop; bUniform = m_bUniformTop; }
		int SetTabSetting(const BOOL bFillSpace = TRUE, const BOOL bUniform = TRUE);
		
		// Or you can set the orientation of each tab group (top/bottom) individually
		void GetTopTabSetting(BOOL & bFillSpace, BOOL & bUniform) { bFillSpace = m_bFillTop; bUniform = m_bUniformTop; }
		int SetTopTabSetting(const BOOL bFillSpace = TRUE, const BOOL bUniform = TRUE);
			
		void GetBottomTabSetting(BOOL & bFillSpace, BOOL & bUniform) { bFillSpace = m_bFillBottom; bUniform = m_bUniformBottom; }
		int SetBottomTabSetting(const BOOL bFillSpace = TRUE, const BOOL bUniform = TRUE);

		// The next functions are called from the CTabDialogItem derived item to perform specific functions.
		//  They should not be called directly.
		void Paint(CPaintDC *pdc);												// Paint the tabs, and surrounding box
		void LButtonDown(UINT nFlags, CPoint point);							// Test for a mouse on a new tab
		BOOL IsTabKey(WPARAM wParam, LPARAM lParam);							// Test for tab accelerators
		LRESULT SendMessageToAll(UINT message, WPARAM wParam, LPARAM lParam);	// Send a message to all created dialogs
		
		int EnableTab(const int iTabId, const BOOL bEnable = TRUE);				// Called to modify the state of a tab
		int GetTabState(const int iTabId, BOOL & bEnable);						// Called to get the current state of a tab
		int SelectTab(const int iTabId);										// Called to change to another tab
		
	protected:
		virtual void DoDataExchange(CDataExchange* pDX);		// DDX/DDV support 
		
		void SelectDialogTab(CTab *selTab);						// Activate a tab, and it's dialog procedure
		int SetTabRectSize();
	
		// Generated message map functions
		//{{AFX_MSG(CTabDialog)
			virtual BOOL OnInitDialog();
		//}}AFX_MSG
		
		DECLARE_MESSAGE_MAP()
};


//////////////////////////////////////////////////////////////////////////////
// CTab - CTab objects are used by CTabDialog to manage dialogs which have
//	placed themselves on a tab. The CTab class keeps track of the size and
//	location of the tab (in reference to the frame), as well as the text for
//	the tab and the actual CDialog object as one of it's member variables.

class CTab
{
	// Member variables
	private:
		CTabDialogItem		*m_pCurrTabDlg;
		CString				m_TabText;
		UINT				m_TabLocation;
		char				m_cAccelChar;
		CRect				m_TabRect;
		BOOL				m_bCreated;			// TRUE if CDialog object has been created
		HLOCAL				m_hlCtrlhWnds;		// HLOCAL memory allocated to hold HWND pointer(s)
		HWND near			*m_pCtrlhWnds;		// Anchor HWND pointer of dialog controls
		HLOCAL				m_hlCtrlTexts;		// HLOCAL memory allocated to hold ATOM(s)
		ATOM near			*m_pCtrlTexts;		// Anchor ATOM pointer of dialog control texts
		HLOCAL				m_hlCtrlIDs;		// HLOCAL memory allocated to hold Control ID(s)
		UINT near			*m_pCtrlIDs;		// Anchor UINT pointer of dialog control ID(s)
		HWND				m_hWndFirst;		// The 1st Control in the users dialog (for initial focus)
		BOOL				m_bTabEnabled;		// TRUE if tab is enabled, FALSE tab is disabled
		
	// Member functions
	public:
		CTab(CTabDialogItem *pDlg, const CString &TabText, CRect TabRect, const UINT uiTabLoc = CTabDialog::TAB_TOP, const BOOL bTabEnabled = TRUE);
		virtual ~CTab();
		
		char GetAccelKey() const { return m_cAccelChar; }
		
		CTabDialogItem * GetTabCard() const { return m_pCurrTabDlg; }
		const CString & GetTabText() const { return m_TabText; }
		
		const CRect & GetTabRect() const { return m_TabRect; }
		void SetTabRect(CRect TabRect) { m_TabRect = TabRect; }
		
		BOOL GetCreateStatus() const { return m_bCreated; }
		void SetCreateStatus(BOOL bFlag = TRUE) { m_bCreated = bFlag; }
		
		UINT GetDlgResource() const { return m_pCurrTabDlg->GetDlgResource(); }
		
		HWND * GetAnchorControl() const { return m_pCtrlhWnds; }
		void SetAnchorControl(UINT uiSize = 0);
		
		ATOM * GetAnchorAtom() const { return m_pCtrlTexts; }
		void SetAnchorAtom(UINT uiSize = 0);
		
		UINT * GetAnchorItem() const { return m_pCtrlIDs; }
		void SetAnchorItem(UINT uiSize = 0);
		
		HWND GetFirstHwnd() const { return m_hWndFirst; }
		void SetFirstHwnd(const HWND hWnd) { ASSERT(hWnd != NULL); m_hWndFirst = hWnd; }
		
		UINT GetTabLocation() const { return m_TabLocation; }
		BOOL TabOnTop() const { return m_TabLocation == CTabDialog::TAB_TOP; }
		
		BOOL GetTabState() { return m_bTabEnabled; }
		void SetTabState(const BOOL bEnable) { m_bTabEnabled = bEnable; }
};           

#endif //__CTABDLG_H__
