// taboptns.cpp : implementation file
//

#include "stdafx.h"
#include "tabdlg.h"
#include "taboptns.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTabOptions dialog


CTabOptions::CTabOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CTabOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTabOptions)
	m_bBottomFill = FALSE;
	m_bBottomUniform = FALSE;
	m_bTopFill = FALSE;
	m_bTopUniform = FALSE;
	m_bGlobalSetting = FALSE;
	//}}AFX_DATA_INIT
}

void CTabOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTabOptions)
	DDX_Control(pDX, IDC_TOP_FILL, m_cTopFill);
	DDX_Control(pDX, IDC_TOP_UNIFORM_SIZE, m_cTopUniform);
	DDX_Control(pDX, IDC_USE_GLOBAL_SETTING, m_cGlobalSetting);
	DDX_Control(pDX, IDC_BOTTOM_UNIFORM_SIZE, m_cBottomUniform);
	DDX_Control(pDX, IDC_BOTTOM_FILL, m_cBottomFill);
	DDX_Check(pDX, IDC_BOTTOM_FILL, m_bBottomFill);
	DDX_Check(pDX, IDC_BOTTOM_UNIFORM_SIZE, m_bBottomUniform);
	DDX_Check(pDX, IDC_TOP_FILL, m_bTopFill);
	DDX_Check(pDX, IDC_TOP_UNIFORM_SIZE, m_bTopUniform);
	DDX_Check(pDX, IDC_USE_GLOBAL_SETTING, m_bGlobalSetting);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTabOptions, CDialog)
	//{{AFX_MSG_MAP(CTabOptions)
	ON_BN_CLICKED(IDC_USE_GLOBAL_SETTING, OnUseGlobalSetting)
	ON_BN_CLICKED(IDC_BOTTOM_FILL, OnBottomFill)
	ON_BN_CLICKED(IDC_TOP_FILL, OnTopFill)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTabOptions message handlers

void CTabOptions::OnUseGlobalSetting()
{
	m_cBottomFill.EnableWindow(m_cGlobalSetting.GetCheck() != 1);
	m_cBottomUniform.EnableWindow(m_cGlobalSetting.GetCheck() == 1 ? FALSE : m_cBottomFill.GetCheck() != 1);
}

BOOL CTabOptions::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	m_cBottomFill.EnableWindow(!m_bGlobalSetting);
	m_cBottomUniform.EnableWindow(m_bGlobalSetting ? FALSE : !m_bBottomFill);
	
	m_cTopUniform.EnableWindow(!m_bTopFill);
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTabOptions::OnBottomFill()
{
	m_cBottomUniform.SetCheck(m_cBottomFill.GetCheck());
	m_cBottomUniform.EnableWindow(m_cBottomFill.GetCheck() != 1);
}

void CTabOptions::OnTopFill()
{
	m_cTopUniform.SetCheck(m_cTopFill.GetCheck());
	m_cTopUniform.EnableWindow(m_cTopFill.GetCheck() != 1);
}
