# Makes all possible versions of swap().  Enter "make swap.mak" at
#  DOS command prompt.


##########################################################################
#  First:  Swap to all locations (SWAP?.OBJ)
##########################################################################

#  Small Memory model
swaps.obj:        swap.asm
            masm /DSmall /Dall /mx swap.asm, swaps.obj;

#  Medium Memory model
swapm.obj:        swap.asm
            masm /DMedium /Dall /mx swap.asm, swapm.obj;

#  Compact Memory model
swapc.obj:        swap.asm
            masm /DCompact /Dall /mx swap.asm, swapc.obj;

#  Large Memory model
swapl.obj:        swap.asm
            masm /DLarge /Dall /mx swap.asm, swapl.obj;

##########################################################################
#  Second:  Swap to Extended memory only (SWAPEXT?.OBJ)
##########################################################################

#  Small Memory model
swapxmss.obj:     swap.asm
            masm /DSmall /Dxms /mx swap.asm, swapxmss.obj;

#  Medium Memory model
swapxmsm.obj:        swap.asm
            masm /DMedium /Dxms /mx swap.asm, swapxmsm.obj;

#  Compact Memory model
swapxmsc.obj:        swap.asm
            masm /DCompact /Dxms /mx swap.asm, swapxmsc.obj;

#  Large Memory model
swapxmsl.obj:        swap.asm
            masm /DLarge /Dxms /mx swap.asm, swapxmsl.obj;

##########################################################################
#  Third:   Swap to Expanded memory only (SWAPEMS?.OBJ)
##########################################################################

#  Small Memory model
swapemss.obj:     swap.asm
            masm /DSmall /Dems /mx swap.asm, swapemss.obj;

#  Medium Memory model
swapemsm.obj:        swap.asm
            masm /DMedium /Dems /mx swap.asm, swapemsm.obj;

#  Compact Memory model
swapemsc.obj:        swap.asm
            masm /DCompact /Dems /mx swap.asm, swapemsc.obj;

#  Large Memory model
swapemsl.obj:        swap.asm
            masm /DLarge /Dems /mx swap.asm, swapemsl.obj;

##########################################################################
#  Fourth:  Swap to disk file only (SWAPDSK?.OBJ)
##########################################################################

#  Small Memory model
swapdsks.obj:     swap.asm
            masm /DSmall /Ddisk /mx swap.asm, swapdsks.obj;

#  Medium Memory model
swapdskm.obj:        swap.asm
            masm /DMedium /Ddisk /mx swap.asm, swapdskm.obj;

#  Compact Memory model
swapdskc.obj:        swap.asm
            masm /DCompact /Ddisk /mx swap.asm, swapdskc.obj;

#  Large Memory model
swapdskl.obj:        swap.asm
            masm /DLarge /Ddisk /mx swap.asm, swapdskl.obj;

##########################################################################
#  Fifth:   Swap to extended or expanded memory (SWAPMEM?.OBJ)
##########################################################################

#  Small Memory model
swapmems.obj:     swap.asm
            masm /DSmall /Dxms /Dems /mx swap.asm, swapmems.obj;

#  Medium Memory model
swapmemm.obj:        swap.asm
            masm /DMedium /Dxms /Dems /mx swap.asm, swapmemm.obj;

#  Compact Memory model
swapmemc.obj:        swap.asm
            masm /DCompact /Dxms /Dems /mx swap.asm, swapmemc.obj;

#  Large Memory model
swapmeml.obj:        swap.asm
            masm /DLarge /Dxms /Dems /mx swap.asm, swapmeml.obj;

##########################################################################
#  Sixth:   Swap to extended memory or disk (SWAPX-D?.OBJ)
##########################################################################

#  Small Memory model
swapx-ds.obj:     swap.asm
            masm /DSmall /Dxms /Ddisk /mx swap.asm, swapx-ds.obj;

#  Medium Memory model
swapx-dm.obj:        swap.asm
            masm /DMedium /Dxms /Ddisk /mx swap.asm, swapx-dm.obj;

#  Compact Memory model
swapx-dc.obj:        swap.asm
            masm /DCompact /Dxms /Ddisk /mx swap.asm, swapx-dc.obj;

#  Large Memory model
swapx-dl.obj:        swap.asm
            masm /DLarge /Dxms /Ddisk /mx swap.asm, swapx-dl.obj;

##########################################################################
#  Sixth:   Swap to expanded memory or disk (SWAPE-D?.OBJ)
##########################################################################

#  Small Memory model
swape-ds.obj:     swap.asm
            masm /DSmall /Dems /Ddisk /mx swap.asm, swape-ds.obj;

#  Medium Memory model
swape-dm.obj:        swap.asm
            masm /DMedium /Dems /Ddisk /mx swap.asm, swape-dm.obj;

#  Compact Memory model
swape-dc.obj:        swap.asm
            masm /DCompact /Dems /Ddisk /mx swap.asm, swape-dc.obj;

#  Large Memory model
swape-dl.obj:        swap.asm
            masm /DLarge /Dems /Ddisk /mx swap.asm, swape-dl.obj;


