	// cbdrdem2.cpp
	// Demo CopyBinder defaulting to C strings!
	
	#include <fstream.h>
	#include <iomanip.h>
	#include <cbinder.hpp>

	#define ID_CBDR_STRCMP  1

	#pragma argsused
	void display1(char * D, voiD M, int * A)
	{
		int i = strlen((char *)D);


		*A += i;
		cout << "length: " << setw(3) << i
			<< "   accumulated length: "
			<< setw(3)
			<< *A << "   string: "
			<< D << "\n";

	}

	void display2(char * D, unsigned * M)
	{
		cout << "node: " << setw(3)
			<< ++*M
			<< "   contents: "
			<< D << "\n";
	}

	main()
	{
		CopyBinder B;

		CopyBinder::registerClass();

		B.pushC("Now is the time");
		B.insQC("for all programmers");
		B.insQC("");  // empty string should Q and stream!		
		B.atInsC(B.Nodes(),"to stop reinventing");
		B.insQC("the linked list!");
		B.insQC("");  // empty string should Q and stream!

		cout << "\n\nOverloaded ++ and typecast: "
			<< "operators \n\n";

		while (B++)
			cout << (char *)(voiD)B << "\n";

		cout << "\n\nOverloaded [] subscript"
			<< " operator \n\n";

		for (unsigned i = 0; i < B.Nodes(); i++)
			cout << (char *)B[i] << "\n";

		cout << "\n\npress enter to continue ...";
		cin.get();

		i = 0;

		cout << "\n\nForEach iterator \n\n";

		B.forEach((BDRforEachBlocK)display1,0,&i);

		cout << "\n\npress enter to continue ...";
		cin.get();

		B.setComparE((BDRcomparE)strcmp);

		RegisterFunction(ID_CBDR_STRCMP,
			(GenericFnC)B.ComparE());

		ofstream oS("cbdrdem1.txt");
		if (oS)  {
			oS << (StreamablE) B;
			B.restream();
			oS.close();
			ifstream iS("cbdrdem1.txt");
			if (iS)  {
				StreamablE C;
				iS >> C;
				RestreamRegistry();
				if (C)
				{
				  cout << "\n\nStreamed and"
					<< " reloaded CopyBinder \n\n";
				  i = 0;
				  ((CBindeR)C)->forEach(
				  	(BDRforEachBlocK)
						display2,&i,0);
				  ((CBindeR)C)->sort();
				  cout << "\n\nStreamed and"
					<< " reloaded CopyBinder"
					<< " sorted on reloaded"
					<< " compare fnc! \n\n";
				  i = 0;
				  ((CBindeR)C)->forEach(
				  	(BDRforEachBlocK)
						display2,&i,0);
				  delete C;
				}
				else
				  cout << "\n\nUnable to reload"
				    << " CopyBinder \n\n";
			}
			else
				cout << "\n\nUnable to reopen"
				  << " stream for input of"
				  << " of CopyBinder \n\n";
		}

		cout << "\n\npress enter to continue ...";
		cin.get();

		cout << "\n\nCopyBinder streamed directly to"
			<< " cout \n\n";

		cout << (StreamablE) B;
		B.restream();


		cout << "\n\npress enter to quit ...";
		cin.get();

		return 0;
	}
