/*

	sbnode.cpp
	8-27-91
	Streamable Binder Nodes

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <sbnode.hpp>
#include <fstream.h>
#include <iomanip.h>
#include <string.h>


void SBNode::construct(voiD D, unsigned sizeofData,
	unsigned Did, int dup)
{
	this->Did = Did;
	if (((this->dup = dup) != 0) && D)  {
		this->D = new char [sizeofData];
		if (this->D)
			memcpy(this->D,D,
				this->sizeofData
				= sizeofData);
		else
			this->sizeofData = 0;
	}
	else if ((this->D = D) != voiD0)
		this->sizeofData = sizeofData;
	else
		this->sizeofData = 0;
}

ostream& SBNode::store(ostream& os)
{
	os << sizeofData << endm << Did << endm;
	if (!os)
		serror("unable to store SBNode"
			": sizeofData and Did");
	else if (sizeofData)  {
		os.write((const char *)D,sizeofData);
		if (!os)
			serror("unable to store"
				" SBNode data");
	}
	return os;
}

StreamablE SBNode::load(istream& is,
	StreamablE InstancE)
{
	unsigned sizeofData, Did;
	char * D = (char *) 0;

	if (!(is >> sizeofData >> nextm >> Did
		>> nextm))  {
		lserror("unable to load SBNode"
			": sizeofData and Did",
			CLASS_ID);
		return StreamablE0;
	}
	if (sizeofData) {
		if ((D = new char[sizeofData])
			!= (char *)0)  {
			is.read(D,sizeofData);
			if (!is)  {
				lserror("loading "
				  "SBNode data",
				  CLASS_ID);
			  delete D;
			  return StreamablE0;
			}
		}
		else  {
			lserror("unable to allocate "
				"memory for SBNode data",
				CLASS_ID);
			is.ignore(sizeofData);
			return StreamablE0;
		}
	}
	if (!InstancE)
		if ((InstancE =	(StreamablE)
			new SBNode
			(UNIQUE_STREAMABLE))
			== StreamablE0)  {
			lserror("unable to construct"
				" SBNode",CLASS_ID);
			delete D;
			return StreamablE0;
		}
	((SBN)InstancE)->
		construct(D,sizeofData,Did,0);
	((SBN)InstancE)->dup = 1;
	
	return InstancE;
}

void SBNode::restream()
	{ Streamable::restream(); }

SBNode::SBNode(char * s, int dup)
	: Streamable(UNIQUE_STREAMABLE,CLASS_ID)
{
	construct(s,(s?(strlen(s)+1):0),
		DID_String,dup);
}
