/*

	cbinder.hpp
	8-27-91
	copy binder

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef CBINDER_HPP
#define CBINDER_HPP

#ifndef BINDER_HPP
#include <binder.hpp>
#endif

#include <string.h>

#define ID_CopyBinder	2

#define CBDR_STRING	0

class CopyBinder : public Binder  {
	unsigned sizeofData;
	void construct(unsigned sizeofData)
		{ this->sizeofData = sizeofData; }
protected:
	virtual void Dstore(ostream& os, const voiD D);
	virtual voiD Dload(istream& is);
	virtual voiD Dclone(const voiD D);
	virtual voiD Dcopy(voiD D, const voiD S);
public:
	STREAMABLE(CopyBinder,ID_CopyBinder,Binder);
	CopyBinder(unsigned sizeofData = CBDR_STRING,
		unsigned maxNodes = BDR_MAXNODES,
		unsigned limit = BDR_LIMIT,
		unsigned delta = BDR_DELTA);
	virtual ~CopyBinder() {}
	voiD atInsC(unsigned n, const voiD D);
	voiD atCFree(unsigned n, voiD D);
	voiD atFreePutC(unsigned n, const voiD D);
	voiD atGetC(unsigned n, voiD D)
		{ return Dcopy(D,atGet(n)); }
	voiD topC(voiD D)  { return Dcopy(D,atGet(0)); }
	voiD currentC(voiD D)
		{ return Dcopy(D,atGet(CurNode())); }
	operator char *();
	voiD bottomC(voiD D)
		{ return Dcopy(D,atGet(Nodes()-1)); }
	voiD pushC(const voiD D);
	voiD popCFree(voiD D);
	voiD insQC(const voiD D);
	voiD rmQCFree(voiD D);
	voiD unQCFree(voiD D);
	voiD insC(const voiD D);
	voiD insSortC(const voiD D);
	voiD delCFree(voiD D);
	voiD nextC(voiD D);
	voiD prevC(voiD D);

};

typedef CopyBinder * CBindeR;


#endif

