/*

	cbinder.cpp
	8-27-91
	copy binder

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <cbinder.hpp>


/*  Copy Binder Primitives  */

void CopyBinder::Dstore(ostream& os, const voiD D)
{
	if (!D)
		return;
	if (sizeofData)  {
		os.write((const char *)D,sizeofData);
		if (!os)
			serror("unable to store CopyBinder "
				"node (fixed sized data)");
	}
	else  {
		unsigned i;
		os << (i = (unsigned) strlen((char *)D))
			<< endm;
		os.write((char *)D,i);
		if (!os)
			serror("unable to store CopyBinder "
				"node (string data)");
	}
}

voiD CopyBinder::Dload(istream& is)
{
	char * D;

	if (sizeofData) {
		if ((D = new char[sizeofData])
			!= (char *)0)  {
			is.read(D,sizeofData);
			if (!is)  {
				serror("loading CopyBinder "
					"node (fixed sized "
					"data)");
				delete D;
				D = (char *) 0;
			}
		}
		else
			serror("unable to allocate memory "
				"for CopyBinder node "
				"(fixed size data)");
	}
	else  {
		unsigned i;

		D = (char *) 0;
		if (!(is >> i >> nextm))
			serror("loading CopyBinder node "
				"(string data)");
		else if ((D = new char[i+1])
			!= (char *)0)  {
			is.read(D,i);
			if (!is)  {
				serror("loading CopyBinder "
					"node (string data)");
				delete D;
				D = (char *) 0;
			}
			else
				D[i] = '\0';
		}
		else
			serror("unable to allocate memory "
				"for CopyBinder node "
				"(string data)");
	}

	return (voiD) D;
}

voiD CopyBinder::Dclone(const voiD D)
{
	voiD cD;

	if (!D)
		return voiD0;
	if (sizeofData)  {
		if ((cD = (voiD) new char[sizeofData])
			!= voiD0) memcpy(cD,D,sizeofData);
	}
	else if ((cD = (voiD) new char[strlen((char *)D)+1])
		!= voiD0) strcpy((char *)cD,(char *)D);
	return cD;

}

voiD CopyBinder::Dcopy(voiD D, const voiD S)
{
	if (D && S)  {
		if (sizeofData)
			memcpy(D,S,sizeofData);
		else
			strcpy((char *)D,(char *)S);
		return D;
	}
	return voiD0;
}

ostream& CopyBinder::store(ostream& os)
{	/* Store CopyBinder sizeofData field then Binder! */
	if (!(os << sizeofData << endm))
		serror("unable to store CopyBinder");
	else
		Binder::store(os);
	return os;
}

StreamablE CopyBinder::load(istream& is, StreamablE InstancE)
{
	unsigned sizeofData;

	if (!(is >> sizeofData >> nextm))  {
		lserror("unable to load CopyBinder "
			"header data",CLASS_ID);
		return StreamablE0;
	}
	if (!InstancE)
		if ((InstancE = (StreamablE)
			new CopyBinder(UNIQUE_STREAMABLE))
			== StreamablE0)  {
			lserror("unable to construct "
				"CopyBinder",CLASS_ID);
			return StreamablE0;				
		}
	((CBindeR)InstancE)->construct(sizeofData);
	return Binder::load(is,InstancE);
}

void CopyBinder::restream()
	{ Binder::restream(); }

CopyBinder::CopyBinder(unsigned sizeofData,
	unsigned maxNodes, unsigned limit,
	unsigned delta)
	: Binder(Binder::ALL_FREE_DESTRUCT,maxNodes,
		limit,delta)
{
	construct(sizeofData);
	setID(CLASS_ID);
}

voiD CopyBinder::atInsC(unsigned n, const voiD D)
{
	voiD cD;

	if (!atIns(n,cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CopyBinder::atCFree(unsigned n, voiD D)
{
	return (Dcopy(D,atGet(n))?
		atFree(n), D : voiD0);
}



voiD CopyBinder::atFreePutC(unsigned n, const voiD D)
{
	voiD oldD, cD;

	if ((oldD = atGet(n)) == voiD0)
		return voiD0;
	if (!atPut(n,cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	Dfree(oldD);
	return cD;
}

CopyBinder::operator char *()
{
	return (char *) (sizeofData? 0 : current());
}



voiD CopyBinder::pushC(const voiD D)
{
	voiD cD;

	if (!push(cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CopyBinder::popCFree(voiD D)
{
	return (Dcopy(D,atGet(0))?
		atFree(0), D : voiD0);
}



voiD CopyBinder::insQC(const voiD D)
{
	voiD cD;

	if (!insQ(cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CopyBinder::rmQCFree(voiD D)
{
	return (Dcopy(D,atGet(0))?
		atFree(0), D : voiD0);
}

voiD CopyBinder::unQCFree(voiD D)
{
	return (Dcopy(D,bottom())?
		unQFree(), D : voiD0);
}


voiD CopyBinder::insC(const voiD D)
{
	voiD cD;

	if (!ins(cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CopyBinder::insSortC(const voiD D)
{
	voiD cD;

	if (!insSort(cD = Dclone(D)))  {
		if (cD)
			Dfree(cD);
		return voiD0;
	}
	return cD;
}

voiD CopyBinder::delCFree(voiD D)
{
	return (Dcopy(D,current())?
		delFree(), D : voiD0);
}

voiD CopyBinder::nextC(voiD D)
	{ return (D? Dcopy(D,next()) : voiD0); }

voiD CopyBinder::prevC(voiD D)
	{ return (D? Dcopy(D,prev()) : voiD0); }

