	// bdrdem4.cpp
	// Demo binder with streamable nodes
	
	#include <string.h>
	#include <fstream.h>
	#include <iomanip.h>
	#include <binder.hpp>

	#define ID_StreamableString		3

	class StreamableString : Streamable  {
		char * s;
		int slen;
	protected:
		void construct(char *s, int slenNotClone);
	public:
		STREAMABLE(StreamableString,
			ID_StreamableString,
			Streamable);
		StreamableString(char *s,
			int slenNotClone = 0)
			: Streamable(UNIQUE_STREAMABLE,
				CLASS_ID)
			{ construct(s,slenNotClone); }
		ostream& printOn(ostream& os);
		operator char *() { return s; }
		virtual ~StreamableString()
			{ delete s; }
	};
	typedef StreamableString * StreamableStrinG;


	ostream& StreamableString::store(ostream& os)
	{
		if (!(os << slen << endm))
			serror("unable to store"
				"string length, id: ");
		else if (slen)  {
			os.write(s,slen);
			if (!os)
				serror("unable to store"
				"string, id: ");
		}
		return os;
	}

	StreamablE StreamableString::load(istream& is,
		StreamablE InstancE)
	{

		int slen;
		char * s;

		if (!(is >> slen >> nextm))  {
			lserror("loading slen",
				CLASS_ID);
			return StreamablE0;
		}
		else if ((s = new char[slen+1])
			!= (char *)0)  {
			if (slen)  {
				is.read(s,slen);
				if (!is)  {
					lserror("loading "
						"string",
						CLASS_ID);
					delete s;
					return StreamablE0;
				}
			}
			s[slen] = '\0';			
		}
		else  {
			lserror("unable to allocate memory "
				"for string",CLASS_ID);
			return StreamablE0;
		}
		if (!InstancE) if ((InstancE = (StreamablE)
			new StreamableString
			(UNIQUE_STREAMABLE)) == StreamablE0)  {
			lserror("unable to construct"
				" StreamableString",
				CLASS_ID);
			delete s;
			return InstancE;
		}
		((StreamableStrinG)InstancE)
			->construct(s,slen);
		return InstancE;
	}
	
	void StreamableString::restream()
		{  Streamable::restream(); }


	void StreamableString::construct(char *s,
		int slenNotClone)
	{
		if (slenNotClone)  {
			this->s = s;
			slen = slenNotClone;
		}
		else if (s)
			if ((this->s = strdup(s))
				!= (char *)0)
				slen = strlen(s);
			else
				slen = 0;
		else  {
			this->s = (char *) 0;
			slen = 0;
		}
	}

	ostream& StreamableString::printOn(ostream& os)
	{
		if (s) if (strlen(s))
			return os << s << endl;
		else
			return os << "empty string" << endl;
		return os << "NULL string" << endl;
	}

	void display(StreamableStrinG S)
	{
		cout << "Address: " << S
			<< "   String:   ";
		S->printOn(cout);
	}



	main()
	{
		Binder::registerClass();
		StreamableString::registerClass();

		Binder B(Binder::STREAMABLE_NODES);

		B.push(new
			StreamableString("Now is the time"));
		B.insQ(new
			StreamableString("for all programmers"));
		B.atIns(B.Nodes(),new
			StreamableString("to stop reinventing"));
		B.insQ(new
			StreamableString("the linked list!"));
		B.insQ(((StreamablE)B.bottom())->link());
		B.insQ(new
			StreamableString("Line above for "
				"testing multiple linking!"));

		B.forEach((BDRforEachBlocK)display);

		cout << "\n\npress enter to continue ...";
		cin.get();


		ofstream oS("bdrdem4.txt");
		if (oS)  {

			oS << (StreamablE) B;
			B.restream();
			oS.close();
			ifstream iS("bdrdem4.txt");
			if (iS)  {
				StreamablE C;
				iS >> C;
				RestreamRegistry();
				if (C)
				{
				  cout << "\n\nStreamed and "
					<< "reloaded Binder "
					<< "with streamable nodes \n\n";
				  ((BindeR)C)->forEach(
				  	(BDRforEachBlocK)display);
				  delete C;
				}
				else
				  cout << "\n\nUnable to reload"
				    << " Binder \n\n";
			}
			else
				cout << "\n\nUnable to reopen"
				  << " stream for input of"
				  << " of Binder \n\n";
		}

		return 0;
	}