	// cbdrdem1.cpp
	// Demo CopyBinder for fixed size data.
	
	#include <fstream.h>
	#include <iomanip.h>
	#include <cbinder.hpp>

	#define ID_CBDR_INTCMP  1

	main()
	{
		CopyBinder B(sizeof(unsigned),5);

		CopyBinder::registerClass();
		
		for (unsigned i = 0;B.pushC(&i); i++);
		
		cout << "\n\nCopyBinder Stack of cloned "
			"unsigned integers:\n\n";
			
		while (B++)
			cout << "node: " << setw(6)
				<< B.CurNode() 
				<< "   contents:  " 
				<< *(int *)(voiD)B << endl;
			
		B.setCurNode(3);
		
		cout << "\n\nCurNode: " << B.CurNode()
			<< "  contains:  " 
			<< *(int *)(voiD)B 
			<< endl << endl;
		
			
		ofstream oS("cbdrdem1.txt");
		if (oS)  {
			oS << (StreamablE) B;
			B.restream();
			oS.close();
			ifstream iS("cbdrdem1.txt");
			if (iS)  {
				StreamablE C;
				iS >> C;
				RestreamRegistry();
				if (C)
				{ //***
				
				
			cout << "\n\nStreamed and"
				<< " reloaded CopyBinder "
				<< "of cloned integers\n\n";
			cout << "CurNode recorded in "
			  	<< "stream and reloaded: " 
				<< ((CBindeR)C)->CurNode()
				<< "  contains:  " 
				<< *(int *)(voiD)*(CBindeR)C 
				<< endl << endl;
			for (((CBindeR)C)->setCurNode();
				(*(CBindeR)C)++;
				cout << "node: " 
					<< setw(6)
					<< ((CBindeR)C)
						->CurNode() 
					<< "   contents:  " 
					<< *(int *)(voiD)
						*(CBindeR)C 
						<< endl);
			delete C;
				  
				  
				} //***
				else
				  cout << "\n\nUnable to "
				  	<< "reload"
				    << " CopyBinder \n\n";
			}
			else
				cout << "\n\nUnable to "
				  << "reopen"
				  << " stream for input of"
				  << " of CopyBinder \n\n";
		}

		return 0;
	}
