/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	char *
 *	strcpy (destination, source)
 *	char *destination, *source;
 *
 *	This is an implementation of the UNIX standard function of the
 *	same name.  The characters in source are copied to destination
 *	including the null terminator.	A pointer to the destination is
 *	returned.
 */

char *strcpy(destination, source)
register char *destination, *source;
{
	char *start_pointer;

					/* first stash away the original
					   address for the destination
					   since it has to be returned */
	start_pointer = destination;

					/* Now copy until the null terminator
					   is reached */
	while (*destination++ = *source++)
		;

					/* Return the pointer to the result */
	return (start_pointer);

} /* strcpy */


/*
 *	char *
 *	strncpy (destination, source, length)
 *	char *destination, *source;
 *	int length;
 *
 *	This is an implementation of the UNIX standard function of the
 *	same name.  length characters from source are copied to destination
 *	and the source is null padded or truncated depending on whether
 *	the length of the source is less than, or greater than length. In
 *	the case of length being less than the length of the source, the null
 *	terminator is not added to destination.
 */

char *strncpy(destination, source, length)
register char *destination, *source;
register int length;
{
	char *start_pointer;

					/* First save away the pointer to
					   the destination so that it can
					   be returned at the end */
	start_pointer = destination;

					/* Now copy exactly length characters
					   to the destination */
	while (length--)
		if ((*destination++ = *source++) == 0) {

					/* Woops! We reached the end of the
					   source, now null pad the rest */
			while (length--)
				*destination++ = 0;
			break;
		}

					/* Return a pointer to the result */
	return (start_pointer);

} /* strncpy */
