/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	char *
 *	strtrans (source, table)
 *	char *source, *table;
 *
 *	This routine translates all of the elements of source according
 *	to the 256 byte translation table pointed to by table.	The
 *	contents of table are the codes that all of the 256 ASCII codes
 *	should be translated into.
 */

char *strtrans (source, table)
register char *source, *table;
{
	char *start_pointer;

					/* Save the original source pointer
					   so that it can be returned */
	start_pointer = source;

					/* Step through the source string */
	do {

					/* Do the translation */
		*source = table[*source];

	} while (*++source);

					/* Return the pointer to the result */
	return (start_pointer);

} /* strtrans */

/*
 *	char *
 *	strntrans (source, table, length)
 *	char *source, *table;
 *	int length;
 *
 *	This routine translates all of the elements of source according
 *	to the 256 byte translation table pointed to by table.	The
 *	contents of table are the codes that all of the 256 ASCII codes
 *	should be translated into.  For this routine, at most length
 *	bytes will be translated.
 */

char *strntrans (source, table, length)
register char *source, *table;
register int length;
{
	char *start_pointer;

					/* Save the original source pointer
					   so that it can be returned */
	start_pointer = source;

					/* Step through the source string
					   doing at most length translations */
	while (0 < length--) {

					/* Do the translation */
		*source = table[*source];

					/* If we reach the end of source,
					   then return */
                if (*++source== '\0')
			break;
	}

					/* Return the pointer to the result */
	return (start_pointer);

} /* strntrans */
