/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	strcmp (s, t)
 *	char *s, *t;
 *
 *	This function lexicographically compares string s to string t, and
 *	returns an integer equal to 0 if they are identical, less than 0
 *	if s is alphabetically before t, and greater than 0 otherwise.
 */

strcmp(s, t)
register char *s, *t;
{
	int i;

					/* Compare s to t keeping track
					   of the first difference */
	while ((i = *s - *t++) == 0 && *s++)
		;
					/* Return the difference (if any) */
	return (i);

} /* strcmp */

/*
 *	strncmp (s, t, len)
 *	char *s, *t;
 *	int len;
 *
 *	This function lexicographically compares string s to string t, and
 *	returns an integer equal to 0 if they are identical, less than 0
 *	if s is alphabetically before t, and greater than 0 otherwise.
 *	At most len characters are compared.
 */

strncmp(s, t, len)
register char *s, *t;
register int len;
{
	int i = 0;

					/* Compare s to t keeping track
					   of the first difference */
	while (len-- && (i = *s - *t++) == 0 && *s++)
		;

					/* Return the difference (if any) */
	return (i);

} /* strncmp */
