/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	char *
 *	right (dest, str, n)
 *	char *dest, *str;
 *	int n;
 *
 *	This function returns a pointer to a string  (dest) containing the
 *	rightmost n characters from str.  Note that it is assumed that
 *	dest will be large enought to hold the entire result.
 *	Note that the external declaration is necessary for some compilers
 *	(including Lattice C large model) that have different sizes for
 *      int's and char *'s.
 */

char *right (dest, str, n)
register char *dest, *str;
register int n;
{
	extern char *strcpy ();
	int str_size;


					/* First determine the length of str
					   and save it since we will need
					   it at least once more, and
					   possibly twice more */
	str_size = strlen (str);

					/* Now copy the characters into the
					   new string.	Notice that we do
					   strcpy starting at  the strlen (str)
                                           minus n 'th character.  The special
					   case is when str is less than n
					   characters, and we just copy the
					   entire string */
	dest = strcpy (dest,
			     &str[(str_size > n) ? (str_size - n) : 0]);

					/* Return the pointer to the result */
	return (dest);

} /* right */
