//
// Extremely simple ProjectClient derived class to automatically
// delete <prjname>.CSM when closing a project.
//
// Add this as an additional target to the IDEHK.ZIP example from
// library 2 in BCPPWIN.
//
// Written by Matthias Hansen, 100014,766.
//
#pragma hdrstop

#include "idehook.h"
#include <string.h>
#include <dir.h>
#include <io.h>

// ---- LocalProjClient ------------------------------------------------------------------
//     =================
//
//	We watch the Project Open/Close events and save the IDE filename on open. On close
//	we delete the CSM file of the same name if it exists.
//
class _HOOKCLASS LocalProjClient : public ProjectClient
{

  private:

	char			LastPrjName[ 260 ];

  public:

	LocalProjClient();

	virtual void _HOOKEP OpenNotify( const char * name );
	virtual void _HOOKEP CloseNotify();
	virtual void _HOOKEP NodeDeleteNotify(ProjectNode) {}
	virtual void _HOOKEP DependencyQueryResponder(ProjectNode,const char * ) {}
};

// ----LocalProjClient--------------------------------------------------------------------

LocalProjClient::LocalProjClient()
{
   ProjectReq 	ps;

   ps->RegisterProjectClient(this);
}

// ----OpenNotify-------------------------------------------------------------------------

void _HOOKEP LocalProjClient::OpenNotify( const char *name )
{

	//	Save the PrjName in our local buffer
	//
	strcpy( LastPrjName, name );

}

// ----CloseNotify------------------------------------------------------------------------

void _HOOKEP LocalProjClient::CloseNotify()
{
	char 		_drive[ MAXDRIVE ];
	char 		_dir  [ MAXDIR   ];
	char 		_file [ MAXFILE  ];


	//	Change extension to .CSM
	//
	fnsplit( LastPrjName, _drive, _dir, _file, NULL   );
	fnmerge( LastPrjName, _drive, _dir, _file, ".CSM" );

	//	Does the file exist?
	//
	if ( access( LastPrjName, 0 ) == 0 ) {

		//	Yes, delete it!
		//
		unlink( LastPrjName );

		}

}

static LocalProjClient LocalProjClient;

// End of file
