/*$mmod s */
/*$ilib struct */

/*==============================================================================
|      Name:   DICTION							       |
|      Desc:								       |
|									       |
| Processes:								       |
| Processes:   int add_dict (char *);					       |
|	       int add_dict_u (char *); 				       |
|	       int lookup (char *);					       |
|	       int write_dict (char *); 				       |
|	       int read_dict (char *);					       |
|									       |
|     Input:								       |
|									       |
|    Output:								       |
|									       |
| Side eff.:								       |
|									       |
| Narrative:								       |
|									       |
|									       |
|									       |
==============================================================================*/
#include <stdio.h>
#include <string.h>

#ifndef ANSI
      void *   chain_to       ( );
      void *   push_chain     ( );

      void *   get_1st_chain  ( );
      void *   get_next_chain ( );
      void *   get_pred_chain ( );
      void *   get_last_chain ( );

      void *   insert_chain   ( );
      void *   pop_chain      ( );
      int      drop_chain     ( );
      int      free_chain     ( );
      int      write_chain    ( );
      int      read_chain     ( );
      int      chain_count    ( );
#else
      void *   chain_to       (void * *,int );
      void *   push_chain     (void * *,int );

      void *   get_1st_chain  (void *);
      void *   get_next_chain (void *);
      void *   get_pred_chain (void *);
      void *   get_last_chain (void *);

      void *   insert_chain   (int, void *, int);
      void *   pop_chain      (void *);
      int      drop_chain     (void *);
      int      free_chain     (void * *);
      int      write_chain    (void **anchor, FILE * outp);
      int      read_chain     (void **anchor, FILE * inp);
      int      chain_count    (void *);

#endif

   /*Ŀ
      Member structure of the dictionary. Contains a uniqe number followed    
      by the test string.						       
   */
   typedef struct member_str {
       int     num;		       /* id number			     */
       char    value[1];	       /* char string, allocated for strlen+1*/
       } ;

   typedef struct member_str   member;
   typedef struct member_str * mem_ptr;

   static  mem_ptr book = (mem_ptr) NULL;
   static  unsigned int base_unique_number = 1;
   static  int	   next_number = 100;
   extern  int	   errno;


   /*Ŀ
      Coding shorthand 						       
   */
#define VALUE  (mp -> value)
#define NUM    (mp -> num)

   /*Ŀ
      If set to 1 - match against full book entry			       
   		 0 - match against length of supplied literal		       
   */
#define MATCH_BOOK_LEN	0

   /*Ŀ
      This global allows you to tell if you adde or matched an existing entry 
   */
   int diction_new_entry;	       /* 0 = old entry 1 = new entry	     */

/*ͻ
  LOOKUP								       
  Simple lookup for a match in the existing BOOK for a match of the supplied  
  literal.  Matching to the length of the 'literal'.                          
  Returns id if matched, else 0 if not found.				       
*/
int
lookup ( literal )
char *literal;
  {
   mem_ptr mp;
   int len;

   if (book == NULL)  return (0);

#if MATCH_BOOK_LEN == 0
   len = strlen (literal);	       /* match to length of literal	     */
#endif

   mp = get_1st_chain (book);
   while (mp != NULL)  {

#if    MATCH_BOOK_LEN == 1
       len = strlen (VALUE);	       /* match full length of BOOK value    */
#endif

       if (strncmp (VALUE , literal, len) == 0)  {
	   if (strlen (VALUE) == len) return (NUM);
	   }
       mp = get_next_chain (mp);
       }
   return (0);			       /* no match			     */
   }


/*ͻ
  ADD_DICT								       
  Unconditionally adds the literal supplied to the BOOK.		       
  Returns the id value assigned.					       
*/
int
add_dict (literal)
char *literal;
  {
   mem_ptr mp;
   int i;

   mp = chain_to (&book, strlen(literal) + sizeof(member));
   strcpy (VALUE, literal);
   NUM = next_number++;
   return (NUM);
   }

/*ͻ
  ADD_DICT_U								       
  Adds unique entries to dictionary BOOK.  If literal already exists, the     
  id already assigned is returned, else a new member is placed in the BOOK    
  and the new id is returned.	The first id issued is 100.		       
  The global 'diction_new_entry' is set to true (1) if this is a new entry.   
*/
int
add_dict_u (literal)
char *literal;
  {
   mem_ptr mp;
   int i;

   diction_new_entry  = 0;
   if ((i = lookup (literal)) != 0 ) return (i);

   /*Ŀ
      No existing entry -- add new one.				       
   */
   diction_new_entry  = 1;
   mp = chain_to (&book, strlen(literal) + sizeof(member));
   strcpy (VALUE, literal);
   NUM = next_number++;
   return (NUM);
   }


/*ͻ
  WRITE_DICT								       
  Write the dictionary book to disk using the supplied name (fn).  This will  
  overwrite an existing file.	This also writes out a 'base unique number'    
  that is restored upon read.	The named file is closed, and the member       
  count is returned.							       
*/
int
write_dict (fn)
char * fn;
  {
   static  FILE * dict_file;
   int w_cnt;
   if ((dict_file = fopen ( fn, "wb" ))== NULL)  {
       return (-1);
       }
/* printf ("Writing dictionary <%s>\n", fn); */

   /*Ŀ
      First the unique number						       
   */
   fwrite (&base_unique_number ,sizeof (unsigned int), 1, dict_file);

   /*Ŀ
      Now the chain							       
   */
   w_cnt = write_chain (&book, dict_file) ;
   fclose (dict_file);
   return (w_cnt);
   }

/*ͻ
  READ_DICT								       
  Read in a dictionary from the named file. Also obtain the unique number     
  and store that.  Prepare for insertions by obtaining the number of the      
  last chain member, and incrementing it.  Returns the count of members in    
  the book.								       
*/
int
read_dict (fn)
char * fn;
  {
   static  FILE * dict_file;
   mem_ptr mp;
   int r_cnt;

   if ((dict_file = fopen ( fn, "rb" ))== NULL)  {
       return (-1);
       }

   fread (&base_unique_number, sizeof (unsigned int) , 1, dict_file);

   book = NULL;
   r_cnt = read_chain (&book, dict_file) ;
   fclose (dict_file);
   mp = get_last_chain (book);
   next_number = NUM +1;
   return (r_cnt);
   }

/*ͻ
  PRINT the dictionary  to the open file passed.			       
*/
int
print_dict (fd)
FILE * fd;
  {
   mem_ptr mp;

   if (book == NULL)  return (0);

   mp = get_1st_chain (book);
   while (mp != NULL)  {
       /*	     id  =  literal					    */
       fprintf (fd, "%4d = <%s>\n", NUM, VALUE);
       mp = get_next_chain (mp);
       }
   return (0);

   }

/*ͻ
  DEFINE_T								       
  Given an ID, return the associated literal. If the ID is not defined        
  return pointer to static string = "Undefined?".                             
*/
char *
define_t (n)
int n;
  {
   static char *UI ="Undefined?";

   mem_ptr mp;

   if (book == NULL)  return (UI);

   mp = get_1st_chain (book);
   while (mp != NULL)  {
       if (NUM == n)  return (VALUE);
       mp = get_next_chain (mp);
       }
   return (UI); 		       /* no match			     */
   }


/*ͻ
  NEXT_UNIQUE_NUM							       
  This returns a one up unsigned integre starting at 1.    If the dictionary  
  is written out, this value is saved and restored, in association with the   
  file.  This is a utility routine, and not directly needed by the dictionary.
*/
unsigned int
next_unique_num ( )
  {
   return (base_unique_number ++);
   }
