/*$ilib chain2 */
/*$mmod l */

/*#define WANTMAIN yes*/ /*remove these comment marks to generate example pgm */

/*ͻ
  Modification date   9-13-88						       
*/

/*ͻ
      Name:   CHAINTO							       
      Desc:   maintain chains of allocated memory			       
									       
 Processes:	>> add to end of chain					       
	       char *chain_to	    (char * *,int );			       
									       
		>> add to top of chain					       
	       char *push_chain     (char * *, int );			       
									       
		>> get pointer to 1st entry in chain			       
	       char *get_1st_chain  (char *);				       
									       
		>> get pointer to sucessor to this entry		       
	       char *get_next_chain (char *);				       
									       
		>> get pointer to 1st entry - remove from chain 	       
	       char *pop_chain	    (char * *); 			       
									       
		>> remove a member from a chain 			       
	       void  drop_chain     (char * );				       
									       
		>> deallocate all memory in chain			       
	       int  free_chain	    (char * *); 			       
									       
     char *   chain_to       (struct chain_root_data * *,int );	       
     char *   push_chain     (struct chain_root_data * *,int );	       
									       
     char *   get_1st_chain  (struct chain_root_data *);		       
     char *   get_next_chain (struct chain_member *);			       
     char *   get_pred_chain (struct chain_member *);			       
									       
     char *   insert_chain   (int, struct chain_member *, int);	       
     char *   pop_chain      (struct chain_root_data *);		       
     int      drop_chain     (struct chain_member *);			       
     int      free_chain     (struct chain_root_data * *);		       
									       
     int      chain_count    (struct chain_root_data *);		       
									       
									       
									       
									       
	       extern int chain_member_size;				       
									       
     Input:								       
									       
    Output:   pointer to member or NULL				       
	       will exit() when out of memory.				       
									       
 Side eff.:   memory gets eaten					       
									       
 Narrative:   Build and maintain a chain of allocated memory (possibly        
	       different in size) and linked to an anchor entry. Forward       
	       linkage only.  A small header is maintained for each member.    
									       
*/

#include <stdio.h>
#include <malloc.h>
#include "chain2.h"

/*Ŀ
  Action upon error - could be 'return' or 'exit()'.                          
  You may set this macro to what ever you need.			       
*/
#define TERMINATE exit(-1)
/* #define TERMINATE free (t_memb_p); return((char*) -1); */

/*Ŀ
  These are used to extend chain					       
*/
#define TOP 1
#define END 2

/*Ŀ
  These are used to insert into existing chains			       
*/
#define FIRST  0x01
#define LAST   0x02


/*Ŀ
  Definition of a member in the chain					       
*/
struct chain_member{
   unsigned int 	root_id;       /* security id			     */
   struct chain_member *next;	       /* next member			     */
   struct chain_member *pred;	       /* prior member			     */
   unsigned int 	member_size;   /* size of this member data	     */
   /*	 additional memory as request in the command  goes here  */
   };

   typedef struct chain_member	chain_mem;
   typedef struct chain_member *chain_ptr;
   #define MEMBER_KEY  54321

/*Ŀ
  Definition of the chain control block				       
*/
struct chain_root_data	{
   unsigned int   root_id;
   void 	* user_anchor;
   chain_ptr	  first;
   chain_ptr	  last;
   unsigned int   count;
   };

   typedef struct chain_root_data   chain_root;
   typedef struct chain_root_data  *chain_root_ptr;
#define ROOT_KEY  12345

/*Ŀ
  This is my only plug for Authorship.  Please leave it in.		       
*/
   static char __Original_author__ [] =
       "Original CHAIN_TO code by - Rip Toren\nColumbia, MD\n10-1-88\n";
/*Ŀ
  Global access to the size of the member				       
*/
   int chain_member_size;

/*Ŀ
  STATIC pointers							       
*/
   static  chain_root_ptr  t_root_p;
   static  chain_ptr	   t_memb_p;


/*Ŀ
  Forward reference							       
*/
   chain_root_ptr	   up_chain (chain_ptr);



/*ͻ
  ADD to list at end							       
    This adds a member to the end of the chain anchored at ROOT	       
*/
void *
chain_to ( root, entry_size)
int  entry_size;
chain_root_ptr *root;
  {
   void * extend_chain();
   return (extend_chain (root,entry_size,END));
   }

/*ͻ
  ADD to list at beginning						       
    This adds a member at the top of the chain anchored at ROOT	       
*/
void *
push_chain ( root,entry_size)
int  entry_size;
chain_root_ptr *root;
  {
   void * extend_chain();
   return (extend_chain (root,entry_size,TOP));
   }



/*ͻ
  EXTEND_CHAIN 							       
   This does the real work for 'chain_to' and 'push_chain'                    
									       
*/
static
void *
extend_chain (root, entry_size, mode)
int  entry_size;
int  mode;
chain_root_ptr *root;
  {

   /*Ŀ
      Get space for the new entry					       
   */
   t_memb_p = (chain_ptr) calloc (1,entry_size+ sizeof (chain_mem) );
   if (t_memb_p == NULL)  {
       fprintf (stdout,"CHAINING ERROR ! out of memory for member");
       chain_member_size = 0;
       TERMINATE;
       }

   /*Ŀ
      Initialize entries  -- just in case				       
   */
   t_memb_p -> next = NULL;
   t_memb_p -> pred = NULL;
   t_memb_p -> root_id = MEMBER_KEY;
   t_memb_p -> member_size = entry_size;
   chain_member_size = entry_size;


   /*Ŀ
      Now examine the pointer passed as ROOT				       
   */
   if (*root != NULL)  {
       /*Ŀ
          ROOT pointer points at something -- is it a control block ?	       
       */
       t_root_p = *root;
       if (t_root_p -> root_id != ROOT_KEY)  {
	   fprintf (stdout,"CHAIN (extend_chain) -- Invalid root pointer\n");
	   chain_member_size = 0;

	   TERMINATE;
	   }
       }

   else  {
       /*Ŀ
          NULL root -- allocate a new one				       
       */
       /*Ŀ
          Allocate a control block for this guy			       
       */
       t_root_p = (chain_root_ptr) calloc (1, sizeof (chain_root) );
       if (t_root_p == NULL)  {
	   fprintf (stdout,"CHAINING ERROR ! out of memory");
	   chain_member_size = 0;
	   TERMINATE;
	   }
       /*Ŀ
          Init control block						       
       */
       t_root_p -> user_anchor = root; /* addr of users anchor pointer	     */
       t_root_p -> first = NULL;
       t_root_p -> last  = NULL;
       t_root_p -> count = 0;
       t_root_p -> root_id = ROOT_KEY;
       /*Ŀ
          Set the callers variable to point back here. 		       
       */
       *root = t_root_p;
       }

   /*Ŀ
      Add the new member to the ??? of the chain			       
   */
   if (t_root_p -> first == NULL)  {	/* 1st entry in chain		      */
       t_root_p -> first = t_root_p -> last = t_memb_p;
       t_memb_p -> pred  = (chain_ptr) t_root_p;
       }

   else  {			   /* at least second entry		 */
       if (mode == END )  {
	   t_memb_p -> pred = t_root_p -> last;
	   t_root_p -> last -> next = t_memb_p;
	   t_root_p -> last = (chain_ptr) t_memb_p;
	   }
       else  { /* mode == TOP */
	   t_memb_p -> next = t_root_p -> first;
	   t_memb_p -> pred = (chain_ptr) t_root_p;
	   t_root_p -> first -> pred = t_memb_p;
	   t_root_p -> first = t_memb_p;
	   }
       }

   t_root_p -> count ++;		    /* maintain the count of members	  */
   return ((char*)(t_memb_p+1));
   }



/*ͻ
  FREE CHAIN								       
   remove all elements from the lists specified by the root		       
   control block is also 'free'ed                                             
*/
void
free_chain (root)
chain_root_ptr *root;
  {

   register chain_ptr wk3;

   t_root_p = *root;
   if (t_root_p != NULL)  {
       for ( t_memb_p = t_root_p -> first; t_memb_p != NULL; t_memb_p = wk3) {
	   wk3 = t_memb_p -> next;
	   free (t_memb_p);
	   }
       }
   free (t_root_p);
   *root = NULL;		       /* reset users pointer to NULL	     */
   }



/*ͻ
  GET_1ST_CHAIN ()							       
    return pointer to 1st entry in chain  (data portion )		       
*/
void *
get_1st_chain (root)
chain_root_ptr root;
  {

   /*Ŀ
      Check   NULL root / INVALID root / NO entries			       
   									       
   */
   if ( root == NULL)	{	       /* no chain at all		     */
       chain_member_size = 0;
       return (NULL);
       }
   if (root -> root_id != ROOT_KEY)  {
       fprintf (stdout,"CHAIN (get_1st) -- Invalid root pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }
   if ( root -> first == NULL)	 {     /* no members in the chain	     */
       chain_member_size = 0;
       return (NULL);
       }

   t_memb_p = root -> first;
   chain_member_size = t_memb_p -> member_size;
   return ((char*) (t_memb_p+1));
   }


/*ͻ
  GET_LAST_CHAIN ()							       
    return pointer to last entry in chain  (data portion)		       
*/
void *
get_last_chain (root)
chain_root_ptr root;
  {

   /*Ŀ
      Check   NULL root / INVALID root / NO entries			       
   									       
   */
   if ( root == NULL)	{
       chain_member_size = 0;
       return (NULL);
       }
   if (root -> root_id != ROOT_KEY)  {
       fprintf (stdout,"CHAIN (get_1st) -- Invalid root pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }
   if ( root -> last == NULL)	{
       chain_member_size = 0;
       return (NULL);
       }

   t_memb_p = root -> last;
   chain_member_size = t_memb_p -> member_size;
   return ((char*) (t_memb_p+1));
   }


/*ͻ
  GET_NEXT_CHAIN							       
   Return pointer to the data portion of the sucessor of the member pointed   
   to by 'member'.  Return NULL if no more entries.                           
*/
void *
get_next_chain (member)
chain_ptr member;
  {
   register chain_ptr t_memb_p;

   /*Ŀ
      Check   NULL root / INVALID root / NO entries			       
   									       
   */
   if ( member == NULL)   {
       fprintf (stdout,"CHAIN (get_next) -- NULL member pointer\n");
       chain_member_size = 0;
       return (NULL);
       }

   t_memb_p =  member -1;

   if (t_memb_p -> root_id != MEMBER_KEY)  {
       fprintf (stdout,"CHAIN (get_next) -- Invalid member pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }

   t_memb_p =  t_memb_p -> next;
   if ( t_memb_p == NULL)   {
       chain_member_size = 0;
       return (NULL);
       }

   chain_member_size = t_memb_p -> member_size;
   return ( (char*) (t_memb_p +1));

   }



/*ͻ
  GET_PRED_CHAIN							       
    Get member prior to the one pointed to by 'member'.                       
    Return NULL at top of chain.					       
*/
void *
get_pred_chain (member)
chain_ptr member;
  {
   chain_ptr t_memb_p;

   /*Ŀ
      Check   NULL root / INVALID root / NO entries			       
   									       
   */
   if ( member == NULL)   {
       fprintf (stdout,"CHAIN (get_pred) -- NULL member pointer\n");
       chain_member_size = 0;
       return (NULL);
       }

   t_memb_p =  member -1;

   if (t_memb_p -> root_id != MEMBER_KEY)  {
       fprintf (stdout,"CHAIN (get_pred) -- Invalid member pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }

   t_memb_p =  t_memb_p -> pred;
   if ( t_memb_p == NULL)   {
       fprintf (stdout,"CHAIN (get_pred) -- Null pred pointer\n");
       chain_member_size = 0;
       return (NULL);
       }

   if ( t_memb_p  -> root_id == ROOT_KEY)  {
       chain_member_size = 0;
       return (NULL);
       }

   chain_member_size = t_memb_p -> member_size;
   return ( (char*) (t_memb_p +1));

   }



/*ͻ
  POP_CHAIN () 							       
      Return pointer to first chain member, remove it from the chain.	       
      Caller is responsible to 'free' the memory.                             
*/
char *
pop_chain (root)
chain_root_ptr root;
  {
   char *ch1 ;

   if ( root == NULL)	{
       fprintf (stdout,"CHAIN (pop_chain) -- NULL root pointer\n");
       chain_member_size = 0;
       return (NULL);
       }

   if ((t_memb_p=(chain_ptr)get_1st_chain(root)) == NULL)  {
       chain_member_size = 0;
       return (NULL);
       }

   /*Ŀ
      There is a first member						       
   */
   t_memb_p --;

   chain_member_size = t_memb_p -> member_size;

   root -> first = t_memb_p -> next;
   if (root -> last == t_memb_p ) root -> last = NULL;
   root -> count -= 1;

   /*Ŀ
      Now make a copy for the user, and free the chain structure	       
   */
   ch1 = malloc (chain_member_size);
   if (ch1 == NULL)  {
       fprintf (stdout, "CHAIN (pop_chain) -- no memory for copy\n");
       chain_member_size = 0;
       TERMINATE;
       }
   /*Ŀ
      Move the data  into the newly allocated space.			       
   */
   memcpy (ch1,(char*)(t_memb_p+1),chain_member_size);

   free (t_memb_p);
   return (ch1);
   }



/*ͻ
  DROP_CHAIN() 							       
      Remove a member from a chain					       
									       
*/
void
drop_chain (member)
chain_ptr member;
  {
   char  state;

   if ( member == NULL)   {
       fprintf (stdout,"CHAIN (drop_chain) -- NULL member pointer\n");
       chain_member_size = 0;
       return ;
       }

   /*Ŀ
      Convert to control info pointer					       
   */
   member--;

   chain_member_size = t_memb_p -> member_size;

   t_root_p = up_chain (member);
   /*Ŀ
      't_root_p' = pointer to anchor control block                            
      'member'   = pointer to member control block                            
   									       
   	 -- 4 possible situations --					       
   	  first entry							       
   	  last entry							       
   	  first & last entry						       
   	  middle entry							       
   									       
   */
   state = 0;			       /* empty at first		     */

   if (t_root_p -> first == member) state |= 0x01;
   if (t_root_p -> last  == member) state |= 0x02;

   switch (state)  {
       case 0x00:		       /* Middle of chain		     */
		   member -> pred -> next = member -> next;
		   member -> next -> pred = member -> pred;
		   break;
       case 0x01:		       /* 1st entry in chain		     */
		   t_root_p -> first = member -> next;
		   member -> next -> pred = (chain_ptr) t_root_p;
		   break;
       case 0x02:		       /* Last entry in chain		     */
		   t_root_p -> last = member -> pred;
		   member -> pred -> next = NULL;
		   break;
       case 0x03:		       /* Only entry in chain		     */
		   t_root_p -> last = t_root_p -> first = NULL;
		   break;
       default:    ;
       }
   t_root_p -> count --;
   free (member);
   }


/*ͻ
  INSERT (action, pointer, size)					       
      Insert a member into the chain ether after or before given member       
      Actions are   3:= after member pointed to			       
		     4:= before "                                              
									       
*/
void *
insert_chain (action , member, entry_size)
int	  action;
chain_ptr member;
int	  entry_size;
  {
   char  state;
   chain_root_ptr  my_root_p;
   chain_ptr	   pred_ptr;

   if ((action != AFTER) && (action != BEFORE)) {
       fprintf (stdout,"CHAIN (insert) -- invalid action (%d)\n",action);
       TERMINATE;
       }

   if ( member == NULL)   {
       fprintf (stdout,"CHAIN (insert) -- NULL member pointer\n");
       chain_member_size = 0;
       return (NULL);
       }

   /*Ŀ
      Convert to control info pointer					       
   */
   member--;
   if (member	-> root_id != MEMBER_KEY)  {
       fprintf (stdout,"CHAIN (insert) -- Invalid member pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }

   my_root_p = up_chain (member);
   /*Ŀ
      'my_root_p' = pointer to anchor control block                           
      'member'   = pointer to member control block                            
   									       
   	 -- 4 possible situations --					       
   				  before		  after 	       
   	  first entry		  extend(top)		  insert	       
   	  last entry		  insert		  extend end	       
   	  first & last entry	  extend(top)		  extend(end)	       
   	  middle entry		  insert		  insert	       
   */
   state = 0;			       /* empty at first		     */

   if (my_root_p -> first == member) state |= FIRST;
   if (my_root_p -> last  == member) state |= LAST;

   if ((action == BEFORE) && ((state & FIRST) == FIRST) )  {
       return (extend_chain (&my_root_p,entry_size,TOP));
       /*NOTREACH*/
       }
   if ((action == AFTER ) && ((state & LAST) == LAST ) )  {
       return (extend_chain (&my_root_p,entry_size,END));
       /*NOTREACH*/
       }
   /*Ŀ
      Working somewhere in the middle					       
   	set up pointer that this new member is to follow.		       
   */
   if (action == BEFORE)  pred_ptr = member -> pred;
      else		 pred_ptr = member;

   if (pred_ptr -> root_id != MEMBER_KEY)  {
       fprintf (stdout,"CHAIN (insert) -- Invalid pred pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }
   /*Ŀ
      Now insert after the 'pred_pointer'.                                    
   */
   t_memb_p = (chain_ptr) calloc (1,entry_size+ sizeof (chain_mem) );

   if (t_memb_p == NULL)  {
       fprintf (stdout,"CHAINING ERROR ! out of memory for member");
       chain_member_size = 0;
       TERMINATE;
       }

   t_memb_p -> root_id = MEMBER_KEY;
   t_memb_p -> member_size = entry_size;
   t_memb_p -> pred = pred_ptr;        /* back pointer			     */
   t_memb_p -> next = pred_ptr -> next;/* forward pointer		     */
   pred_ptr -> next -> pred = t_memb_p;/* back ptr for sucessor 	     */
   pred_ptr -> next	    = t_memb_p;/* forward ptr for predecessor	     */

   t_root_p -> count ++;	       /* member count			     */
   return ( (char*) (t_memb_p +1));
   }


/*ͻ
  CHAIN_COUNT								       
   simple count of members in the anchored chain			       
*/
int
chain_count (root)
chain_root_ptr root;
  {
   if ( root == NULL)	{
       fprintf (stdout,"CHAIN (count) -- NULL root pointer\n");
       chain_member_size = 0;
       return (NULL);
       }
   if (root -> root_id != ROOT_KEY)  {
       fprintf (stdout,"CHAIN (count) -- Invalid root pointer\n");
       chain_member_size = 0;
       TERMINATE;
       }
   return (root -> count);
   }


/*ͻ
  FIND anchor (internal routine to locate root of chain )		       
    member pointer already points to the control section of the member.       
									       
*/
static
chain_root_ptr
up_chain (member)
chain_ptr member;
  {
   register chain_ptr cp;

   for (cp = member; cp -> root_id == MEMBER_KEY  ; cp = cp -> pred);
   if (cp -> root_id == ROOT_KEY)  {
       return ((chain_root_ptr) cp);
       }
   fprintf (stdout,"CHAIN (up_chain) -- Clobbered chain structure\n");
   exit (-1);
   }

/*ͻ
  FIND anchor								       
    return the address of the users anchor for this chain		       
									       
*/
void *
find_anchor (member)
chain_ptr member;
  {
   if ( member == NULL)   {
       fprintf (stdout,"CHAIN (find_anchor) -- NULL member pointer\n");
       chain_member_size = 0;
       return (NULL);
       }
   /*Ŀ
      Convert to control info pointer					       
   */
   member--;

   t_root_p = up_chain (member);
   return (t_root_p -> user_anchor);
   }

#ifdef WANTMAIN
/*ͻ
									       
  **********************  MAIN *************************************	       
									       
*/
   char *a1, *a2, *a3;		       /* anchors for chains		     */
   char *m1, *m2, *m3;		       /* pointer to member storage	     */
   char *g1, *g2;		       /* general pointers		     */
   int	i,j,k;
main ()
  {

   /*Ŀ
      Be sure the anchors are NULL;					       
   */
   a1 = a2 = a3 = NULL;

   /*Ŀ
      Fill 1st chain with ASCII form of number 			       
   */
   for (i=1; i<10; i++)  {
       m1 = chain_to(&a1,10);	       /* members 10 bytes long 	     */
       itoa (i,m1,10);		       /* ascii digit (base 10) 	     */
       printf (" %d ",chain_count(a1));
       }
   printf ("\n");

   print_the_chain();

   /*Ŀ
      Push on some more items						       
   */
   printf ("\nPushing entries 20 - 28 on chain\n");
   for (i=20; i<29; i++)  {
       m1 = push_chain(&a1,10); 	 /* members 10 bytes long	       */
       itoa (i,m1,10);		       /* ascii digit (base 10) 	     */
       printf (" %d ",chain_count(a1));
       }
   printf ("\n");

   print_the_chain();

   /*Ŀ
      Insert into the chain						      
   */
   printf ("\nInserting 100 AFTER 9th entry\n");
   g1 = get_1st_chain (a1);
   for (i=0; i< 8; i++){	       /* move down to 8th entry	     */
       g1 = get_next_chain (g1);
       }
   printf ("   9th entry is <%s>\n",g1);
   m1 = insert_chain (AFTER, g1,10);
   itoa (100,m1,10);			/* ascii digit (base 10)	      */

   print_the_chain();

   /*Ŀ
   									       
   */
   printf ("\nInserting 101 BEFORE 9th entry\n");
   g1 = get_1st_chain (a1);
   for (i=0; i< 8; i++){	       /* move down to 8th entry	     */
       g1 = get_next_chain (g1);
       }
   printf ("   9th entry is <%s>\n",g1);
   m1 = insert_chain (BEFORE, g1,10);
   itoa (101,m1,10);			/* ascii digit (base 10)	      */

   print_the_chain();
   /*Ŀ
      let's fint the anchor of the last entry inserted                        
   */
   puts ("\nLocate the anchor of a member, these two values should match");
   g1 = find_anchor ( m1);
   printf (" the anchor of 'm1' chain is %Fp, 'a1' = %Fp\n\n",
	   (void far * )g1,(void far * )&a1 );
   /*Ŀ
      Try out poping the chain 					       
   */
   puts ("Poping the chain until count = 0\n");
   do  {
       g1 = pop_chain (a1);
       printf (" member value is <%s>, entries left are %d\n",g1,chain_count(a1));
       free (g1);
       } while (chain_count(a1) != 0);
   puts ("");
   /*Ŀ
      Try to screw up the chains					       
   */
   puts ("Next from null anchor");
   g1 = get_next_chain (a2);
   puts ("1st from an uninited chain");
   g1 = get_1st_chain (g1);
   }


print_the_chain ()  {
   printf ("Members of chain are:\n");
   g1 = get_1st_chain (a1);
   while (g1 != NULL)  {
       printf ("  <%s>\n",g1);
       g1 = get_next_chain (g1);
       }
   }

#endif
