/*$ilib resc1 */
/*$mmod s */
/*$objs +chain2 */

 #define WANTMAIN 0

/*ͻ
      Name:   Q_INSERT                                                        
      Desc:   insert a member into the based Q in priority order              
              priority is an unsigned long in the 1st 4 bytes.                
                                                                              
 Processes:                                                                   
                                                                              
     Input:                                                                   
            void * q_insert  (void **anchor, unsigned long pri, int size)     
    Output:                                                                   
                                                                              
 Side eff.:                                                                   
                                                                              
 Narrative:                                                                   
            The fact that this is a QUEUE in concept does not preclude        
            normal chaining operations (peeking at the top of the list?).     
                                                                              
*/
      #include <stdio.h>
      #include <string.h>
      #include "chain2.h"

/*ͻ
                                                                              
*/
void * q_insert
       (void **anchor, unsigned long pri, int size)
  {
   union  {
       void * v;                       /* pointer to member record           */
       unsigned long * l;              /* pointer to priority entry          */
                                       /*   1st 8 bytes                      */
       } work;

   void * last_entry;

   work.v = get_1st_chain (*anchor);   /* get 1st member                     */

   if (work.v == NULL)  {              /* chain is empty                     */
                                       /* simple insert                      */
       work.v = chain_to (anchor, size);
       if (work.v != NULL)             /* if worked, copy in priority        */
           memcpy (work.v, &pri, sizeof (unsigned long));
       return (work.v);
       }

   last_entry = NULL;
   /*Ŀ
      Loop thru chain looking for enty larger, or end                         
   */
   while ((work.v != NULL) && (*work.l <= pri))  {
       last_entry = work.v;            /* save this entry pointer            */
                                       /* now get next entry                 */
       work.v = get_next_chain (work.v);
       }

   /*Ŀ
      Insert after last valid (or smaller) entry                              
   */
   if (last_entry != NULL)             /* found at least one entry <=        */
                                       /*  insert after that one             */
       work.v = insert_chain (AFTER, last_entry, size);
   else                                /* found no entry <=                  */
                                       /*  insert prior to 1st entry         */
       work.v = insert_chain (BEFORE, work.v, size);

   if (work.v != NULL)                 /* if insert worked                   */
                                       /*  copy in the data                  */
       memcpy (work.v, &pri, sizeof (unsigned long));

   return (work.v);
   }

