/* DEMO.CPP:  Demo of basic mouse operations */
/* Translated by Kevin Brooks from C routines written Ken Porter */

/* INCLUDES */
#include <stdio.h>
#include <dos.h>
#include <stream.hpp>

#include "mouse.hpp"

/* GLOBALS */
union REGS inreg, outreg;

/* LOCAL FUNCTIONS */
void  clrScr (void);
void  gotoxy (int col, int row);


/* --------------------------------------------------------------- */
main ()
{
  Mouse      theMouse;
  locRec     *its;                           /* from mouse inquiries */
  int        col, row;
  char       input [80];

  clrScr ();                                       /* clear screen */
  gotoxy(0, 0);
  theMouse.Reset();                             /* reset mouse */
  if (theMouse.exists) {             /* do following if it exists */

/* Software mouse cursor */
    puts ("Software cursor:");
    printf ("Demo of a mouse with %d buttons\n", theMouse.nButtons);
    puts ("Move the mouse around and click the left button");
    puts ("Click the right button for hardware demo\n");
    theMouse.TextCursor(SOFTWARE, 0x0000, 0x0718);      /* set s/w cursor */
    theMouse.Show();                                        /* turn it on */
    do {
      theMouse.Released(Left);                 /* check left button */
      if (theMouse.opCount > 0) {
        theMouse.Hide ();                  /* cursor off in case of scroll */
        printf ("\nMouse is at col %d, row %d", theMouse.column,
                theMouse.row);                      /* position report */
        theMouse.Show();                                /* cursor back on */
      }
      theMouse.Released(Right);                /* check right button */
    } while (theMouse.opCount == 0);          /* repeat until operated */

/* Now do hardware mouse cursor demo */
    clrScr ();                                     /* clear screen */
    gotoxy(0, 0);
    puts ("Hardware cursor:");
    puts ("Move the mouse, click left button");
    puts ("Type something and press Enter");
    puts ("Click right button to end demo");
    theMouse.Reset();                           /* reset mouse */
    theMouse.TextCursor(HARDWARE, 2, 5);                /* set h/w cursor */
    theMouse.Show();                                         /* cursor on */
    do {
      theMouse.Released(Left);                 /* check left button */
      if (theMouse.opCount > 0) {                 /* if operated . . . */
        col = theMouse.column / 8;            /* compute text position */
        row = theMouse.row / 8;
        gotoxy (col, row);                             /* go there */
        putchar ('?');                                   /* prompt */
        gets (input);
        theMouse.Moveto (theMouse.column, theMouse.row);       /* restore position */
      }
      theMouse.Released(Right);                /* check right button */
    } while (theMouse.opCount == 0);          /* repeat until operated */

/* Clean up and end of job */
    theMouse.TextCursor (HARDWARE, 6, 7);      /* use 11, 12 if mono board */
    theMouse.Reset ();                                     /* reset cursor */
    clrScr ();                                     /* clear screen */
  } else
    puts ("Mouse not present in system. Demo can't run.");
} /* ------------------------ */

void  clrScr (void)                           /* clears the screen */
            /* Uses ROM BIOS int 10h to reset video mode to itself */
{
union REGS  inreg, outreg;
   inreg.h.ah = 6;
   inreg.h.al = 0;
   inreg.h.ch = 0;
   inreg.h.cl = 0;
   inreg.h.dh = 24;
   inreg.h.dl = 79;
   inreg.h.bh = (char)((0<<4) | 7);
   int86(0x10, &inreg, &outreg);

} /* ------------------------ */

void  gotoxy (int col, int row)            /* position text cursor */
                                          /* Uses ROM BIOS int 10h */
{
union REGS  inreg;

  inreg.h.ah = 2;                    /* function 2 sets cursor pos */
  inreg.h.bh = 0;                        /* video page 0 is active */
  inreg.h.dh = (char)row;
  inreg.h.dl = (char)col;
  int86 (0x10, &inreg, &inreg);
} /* ------------------------ */


