/* Translated by Kevin Brooks from C routines written Ken Porter */
/* December 11, 1990 */

#ifndef MOUSE_HPP
#define MOUSE_HPP 1

#include <dos.h>

extern
const int HARDWARE;                                /* cursor types */
extern
const int SOFTWARE;

enum Button {Left, Right};

/* STRUCTURES USED BY THESE FUNCTIONS */
class resetRec {
public:
  resetRec() {}
  resetRec(int _exists, int _nButtons) {
     exists = _exists; nButtons = _nButtons; }

  int exists,                             /* TRUE if mouse is present */
      nButtons;                           /* # of buttons on mouse */
};	                                  /* returned by mReset */

class locRec {
public:
  locRec() {}
  locRec(int _buttonStatus, int _opCount, int _column, int _row) {
     buttonStatus = _buttonStatus; opCount = _opCount; 
     column = _column; row= _row; }

  int buttonStatus,       /* bits 0-2 on if corresp button is down */
      opCount,                  /* # times button has been clicked */
      column, row;                                     /* position */
};                        /* returned by mPos, mPressed, mReleased */

class moveRec {
public:
  moveRec() {}
  moveRec(int _hCount, int _vCount) {
     hCount = _hCount; vCount = _vCount; }

  int hCount,                           /* net horizontal movement */
  vCount;                               /* net vertical movement */
};                                      /* returned by mMotion */

class Mouse : public resetRec, locRec, moveRec {
private:
   union REGS  inreg, 
  	       outreg;

protected:
/* Define int for mouse device driver */
   inline void callMDD() { int86(0x33, &inreg, &outreg); }

/* Define sorting macros used locally */
   inline int lower (int x, int y) const { return (x < y) ? x : y; }
   inline int upper (int x, int y) const { return (x > y) ? x : y; }

public:
   Mouse() {}
   ~Mouse() {}
	
   resetRec& Reset();
   void Show();
   void Hide();
   locRec& Pos();
   void  Moveto(int newCol, int newRow);
   locRec& Pressed(Button button);	       
   locRec& Released(Button button);
   void SetColRange(int hmin, int hmax);
   void SetRowRange(int vmin, int vmax);
   void GraphCursor(int hHot, int vHot, unsigned maskSeg,
                    unsigned maskOfs);
   void TextCursor(int curstype, unsigned arg1, unsigned arg2);
   moveRec& Motion();
   void InstTask(unsigned mask, unsigned taskSeg, unsigned taskOfs);
   void LpenOn();
   void LpenOff();
   void Ratio(int horiz, int vert);
};

#endif // MOUSE_HPP
