// =========================================================================
//			      CPAR OUTPUT FILE
// =========================================================================
//
//                                 APP.C
//
// =========================================================================
// This is sample code for a very simple-minded multitasker. The
// programmer adds a few macro-like things in the source code, and
// the CPAR preprocessor expands these into labels and conditional
// jumps that allow routines to be parallelized with a simple loop
// in main(). See CPAR.DOC for more details.

#include "stdio.h"
#include "conio.h"
#include "stdlib.h"

int finished_tasks = 0;

struct big_data
    {
    int state, task_id;
    double x, y, z;
    };

// =============================================================
// There may be several processes running simultaneously that are all
// instances of a single routine, each process with its own set of data
// and program counter location. You can put all the data and the state
// variable in a struct, and pass the routine a struct pointer. Then
// main() will need to maintain a separate physical struct for each
// running process.

#define CPAR
#define STATE (p->state)

void task1(struct big_data *p)
    {
    void (* * * z) (void) = NULL;
	if (STATE != 0) goto L1;
    /* totally irrelevant, but an interesting test */

    for (p->x = 0.0; p->x < 12.0; p->x += 2.7)
        for (p->y = 0.0; p->y < 3.0; p->y += 0.5)
            {  STATE = 1; return; L1: if (STATE != 1) goto L2; p->z = 3.14159 * (p->x + p->y); }
    printf("** Floating point task (%d) done\n", p->task_id);
    finished_tasks++;
    STATE = 2; return; L2: ;
	}

// =============================================================
// For multiple instances of a very simple routine, it may be simpler
// to specify pointers to data and state variable explicitly.

#undef STATE
#define STATE *state

void task2(int *state, int *j, int *k)
    {
	if (STATE != 0) goto L1;
    for (*j = 0; *j < 5;  (*j)++) {  STATE = 1; return; L1: if (STATE != 1) goto L2;  }
    for (*k = 0; *k < 10; (*k)++) {  STATE = 2; return; L2: if (STATE != 2) goto L3;  }
    printf("** Integer task done\n");
    finished_tasks++;
    STATE = 3; return; L3: ;
	}

// =============================================================
// If there is only one instance of a task, then its state and locals
// can be internally defined static variables. This will ease the
// housekeeping burden on main().

#undef STATE
#define STATE state

void task3(void)
    {
    static int state = 0;
	if (STATE != 0) goto L1;

    while (1)
        {  STATE = 1; return; L1: if (STATE != 1) goto L2; printf("Endless dumb loop\n"); }
    STATE = 2; return; L2: ;
	}
#undef CPAR

// =============================================================

int state2, j, k;
struct big_data x, y, z;

#define priority(I,N,D)  (((I) % (D)) < (N))

void main(void)
    {
    int i;

    // Set up initial states
    state2 = 0;
    x.state = 0;
    y.state = 0;
    z.state = 0;
    x.task_id = 1;
    y.task_id = 2;
    z.task_id = 3;

    finished_tasks = 0;
    // The task loop
    for (i = 0; 1; i++)
        {
        task1(&x);
        if (i > 15) task1(&y);  // delayed start
        if (priority(i, 3, 5)) task1(&z);  // slightly low priority
        if (priority(i, 1, 4)) task2(&state2, &j, &k); // lower priority
        if (priority(i, 1, 7)) task3();
        printf("%6d %10lf %10lf %10lf %6d %6d\n",
            i, x.z, y.z, z.z, j, k);
        if (finished_tasks == 4) return;
        }
    }
