===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-24-93 (00:35)             Number: 87
From: BOB STOUT                    Refer#: 226
  To: BRIAN DESSENT                 Recvd: NO  
Subj: Fastest way to check exis      Conf: (36) C Language
---------------------------------------------------------------------------
Brian...

  I investigated this a bit further and thought you might appreciate seeing the
results. Following is test code using several different methods for both existin
g and non-existing files (since this was a quick hack, excuse the compiler speci
ficities and MFL-isms). The timings follow.

----8<------------------------------------------------------------------------
/*
**  timtst.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <sys\types.h>
#include <dos.h>
#include <mfltime.h>

char *names[] = {
      "timtst.c",             /* This file (i.e. it exists) */
      "abc.xyz",              /* Bogus noexistant file      */
      NULL
      };

int main(void)
{
      char **p;
      uclock_t start, end;
      int fp, retval;
      FILE *fd;
      struct find_t ff;
      union REGS regs;

      for (p = names; *p; ++p, puts(""))
      {
            start = usec_clock();
            fp = open(*p, O_RDONLY);
            end = usec_clock();
            close(fp);
            printf("open(%s) returned %d and took %d.%d msec.\n", *p, fp,
                  (int)(usec_difftime(start, end) / 1000L),
                  (int)(usec_difftime(start, end) % 1000L));

            start = usec_clock();
            fd = fopen(*p, "r");
            end = usec_clock();
            fclose(fd);
            printf("fopen(%s) returned %p and took %d.%d msec.\n", *p, fd,
                  (int)(usec_difftime(start, end) / 1000L),
                  (int)(usec_difftime(start, end) % 1000L));

            start = usec_clock();
            retval = _dos_findfirst(*p, 0xff, &ff);
            end = usec_clock();
            printf("findfirst(%s) returned %d and took %d.%d msec.\n", *p,
                  retval, (int)(usec_difftime(start, end) / 1000L),
                  (int)(usec_difftime(start, end) % 1000L));

            regs.x.ax = 0x4300;
            regs.x.dx = (unsigned)(*p);
            start = usec_clock();
            intdos(&regs, &regs);
            end = usec_clock();
            printf("DOS function 0x43(%s) returned %d and took %d.%d msec.\n",
                  *p, regs.x.cflag, (int)(usec_difftime(start, end) / 1000L),
                  (int)(usec_difftime(start, end) % 1000L));
      }
}
----8<------------------------------------------------------------------------
open(timtst.c) returned 5 and took 16.584 msec.
fopen(timtst.c) returned 035A and took 16.939 msec.
findfirst(timtst.c) returned 0 and took 8.47 msec.
DOS function 0x43(timtst.c) returned 0 and took 8.16 msec.

open(abc.xyz) returned -1 and took 8.385 msec.
fopen(abc.xyz) returned 0000 and took 8.627 msec.
findfirst(abc.xyz) returned 18 and took 8.196 msec.
DOS function 0x43(abc.xyz) returned -1 and took 8.5 msec.
----8<------------------------------------------------------------------------

  This suggests using find first or DOS function 0x43 rather than trying to open
 the file although everything's comparable when the file doesn't exist. For refe
rence, this was run on a 10 MHz 286 under DOS 3.3, compiled in tiny model with Z
TC++ 3.1. Given the difference in compiler libraries, DOS function 0x43 might be
 your best bet.


--- QM v1.00
 * Origin: MicroFirm : Down to the C in chips (1:106/2000.6)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
