===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 04-20-93 (23:10)             Number: 255
From: BOB STOUT                    Refer#: NONE
  To: BRUCE PARR                    Recvd: NO  
Subj: ASCII to BINARY CONVERSIO      Conf: (36) C Language
---------------------------------------------------------------------------
In a message of <Apr 19 17:18>, Bruce Parr (1:129/179@fidonet) writes:

 >Does anyone know of an ASCII to BINARY conversion program for text
 >conversion? I am trying to make one and am having immense headaches, so
 >if one does exist, it will save much time and energy. Please let me know!

  From SNIPPETS:

----[ Rdxcnvrt.C ]------------------------------------------------------------
/*
**  RDXCNVRT.C - Convert between number bases
**
**  public domain demo by Bob Stout
*/

#include <stdlib.h>
#ifdef TEST
 #include <stdio.h>
#endif

/*
**  Calling parameters: 1 - Number string to be converted
**                      2 - Buffer for the  converted output
**                      3 - Radix (base) of the input
**                      4 - Radix of the output
**
**  Returns: Pointer to converted output
*/

char *radix_convert(const char *in, char *out, int rin, int rout)
{
      long n;
      char *dummy;

      n = strtol(in, &dummy, rin);
      return ltoa(n, out, rout);
}

#ifdef TEST

int main(int argc, char *argv[])
{
      int rin, rout;
      char buf[40];

      if (4 > argc)
      {
            puts("Usage: RDXCNVRT <number> <base_in> <base_out>");
            return(-1);
      }
      rin  = atoi(argv[2]);
      rout = atoi(argv[3]);
      printf("%s (base %d) = %s (base %d)\n", argv[1], rin,
            radix_convert((const char *)argv[1], buf, rin, rout), rout);
      return 0;
}

#endif
----[ Bstr_I.C ]--------------------------------------------------------------
/*
**  Make an ascii binary string into an integer.
**
**  Public domain by Bob Stout
*/

#include <string.h>

unsigned int bstr_i(char *cptr)
{
      unsigned int i, j = 0;

      while (cptr && *cptr && strchr("01", *cptr))
      {
            i = *cptr++ - '0';
            j <<= 1;
            j |= (i & 0x01);
      }
      return(j);
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
      char *arg;
      unsigned int x;

      while (--argc)
      {
            x = bstr_i(arg = *++argv);
            printf("Binary %s = %d = %04Xh\n", arg, x, x);
      }
      return EXIT_SUCCESS;
}

#endif /* TEST */
------------------------------------------------------------------------------


--- QM v1.00
 * Origin: MicroFirm : Down to the C in chips (1:106/2000.6)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 280/1
SEEN-BY: 390/1 396/1 5 15 2270/1 2440/5 3603/20
