===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 06-07-93 (18:22)             Number: 165
From: MARK CORGAN                  Refer#: NONE
  To: ALL                           Recvd: NO  
Subj: Optimization again...          Conf: (36) C Language
---------------------------------------------------------------------------
Hello All!

A few months ago I posted some code that generates the Mandelbrot fractal set in
 the hopes that someone could speed up the algorithm. Someone, whose name I have
 now forgotten, helped me very much and made the routine almost 50% faster!
I have some more code that I would like optimized for speed. It generates the Ma
ndelbrot fractal set as well as its correspnding Julia set. I have hard-coded th
e parameters in the following code for test purposes only. Of course, they would
 be user-selectable. I know I need to take out as many floating-point calculatio
ns from within the for() loops but I do not have a profiler to determine where t
he biggest bottlenecks are. Also, does anyone have a substitute for kbhit()? It
is in one of the for() loops and it REALLY slows things down by continually chec
king the keyboard through each loop iteration. I would appreciate any help. :)

/* JANDELIA.C
 *
 * A program to display Mandelbrot and Julia Sets.
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>
#include <math.h>
#include <time.h>

int niter;                /* maximum number of iterations */
int px, py;               /* current pixel */
int nx, ny;               /* number of pixels */
int nc;                   /* number of colors to use */
int i, j;                 /* counters for miscellaneous use */
int keepon;               /* 1 = keep going, 0 = abort */
int jul;                  /* 1 = Julia Set,  0 = Mandelbrot */
float x, y;               /* last point on orbit */
float xx, yy;             /* next point on orbit */
float xsquared, ysquared; /* used to speed up computations */
float dx, dy;             /* theoretical size of pixels */
float cx, cy;             /* number to add each iteration */
float xO, yO;             /* starting x,y */
float xI, yI;             /* ending x,y */

void main(void)
{
   time_t start, end;

   /* request auto detection */
   int gdriver = DETECT, gmode, errorcode;

   /* initialize graphics mode */
   initgraph(&gdriver, &gmode, "\\tc\\bgi");

   /* read result of initialization */
   errorcode = graphresult();

   if (errorcode != grOk)  /* an error occurred */
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);             /* return with error code */
   }

   cx = 0.5;               /* hard-coded for testing */
   cy = 0.5;               /* cx and cy are used only when jul = 1 */
   xO = -2.0;
   yO = 1.25;
   xI = 1.0;
   yI = -1.25;
   niter = 16;
   px = 0, py = 0;
   nx = 200;
   ny = 200;
   nc = 16;
   keepon = 1;
   jul = 0;

   start = time(NULL);

   dx = (xI - xO) / nx;          /* compute size of pixels */
   dy = (yI - yO) / ny;
   for (px = 0; (px < nx) && (keepon); px++)  /* main loop */
      for (py = 0; (py < ny) && (keepon); py++)
      {
         x = xO + px * dx,       /* start julia set on pixel */
         y = yO + py * dy;
         if (jul == 0)           /* start mandelbrot set on 0,0 */
            cx = x, cy = y,
         x = 0.0, y = 0.0;       /* and use pixel for c */
         xsquared = 0, ysquared = 0;
         for (i = 0; (i < niter) && (xsquared + ysquared < 4.0); i++)
         {
            xsquared = x * x;
            ysquared = y * y;
            xx = xsquared - ysquared + cx;
            yy = cos(x * y * 2.0) + cy;
            x = xx, y = yy;
         }
         if (i == niter) i = 0;  /* hit limit, color 0 */
         else i = (i % 256);      /* color determined by i */
         putpixel(px, py, i);    /* lite up the pixel */
         if (kbhit() && (getch() == 27))
            keepon = 0;         /* stop if user hit Esc */
      }
   end = time(NULL);
   printf("\7");                 /* beep when done */
   outtextxy(0, 300, "Press almost any key for completion time . . .");
   getch();
   restorecrtmode();
   printf("Time for completion was %ld seconds.", end - start);
   printf("\n\nPress almost any key to quit . . .");
   getch();                      /* wait for a keypress */
   closegraph();                 /* shut down graphics */
}


Mark

--- GoldED 2.40
 * Origin: -*- Sound and Image -*-  (1:213/810)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/110 159/100 125 430 575 950 203/23 209/209
SEEN-BY: 261/1023 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
