===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-24-93 (05:42)             Number: 109
From: BOB STOUT                    Refer#: 129
  To: BOB CALBRIDGE                 Recvd: NO  
Subj: Malloc                         Conf: (36) C Language
---------------------------------------------------------------------------
In a message of <May 23 12:58>, Bob Calbridge (1:124/6300@fidonet) writes:

 >How about changing the memory model to one that uses far pointers by
 >default?  This should make the string functions fall into line.  However,
 >it shouldn't be too difficult to write your own function that takes two
 >far pointers.

  Quite true. For example, from SNIPPETS:

/*
**  FMEMOPS.C - Emulate MSC's far memory functions in BC++ & ZTC++
**
**  Original Copyright 1988-1992 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  This subset version is hereby donated to the public domain.
*/

#include <stdlib.h>
#include <string.h>
#include <dos.h>

#if defined(__TURBOC__) || defined(__ZTC__)

#ifdef __TURBOC__
 #define FAR far
#else
 #define FAR _far
#endif

typedef unsigned char FAR *FarBytePtr;

void FAR * _fmemcpy(void FAR *dest, void FAR *src, size_t count)
{
      movedata(FP_SEG(src), FP_OFF(src), FP_SEG(dest), FP_OFF(dest), count);
      return dest;
}

void FAR * _fmemmove(void FAR *dest, void FAR *src, size_t count)
{
      void FAR *target =  dest;
      FarBytePtr to = (FarBytePtr)dest, from = (FarBytePtr)src;

      if (src >= dest)
            _fmemcpy(dest, src, count);
      else  for (to += count, from += count; count; --count)
                  *--to = *--from;
      return target;
}

void FAR * _fmemset(void FAR *dest, int ch, size_t count)
{
      void FAR *target =  dest;
      FarBytePtr to = (FarBytePtr)dest;

      for ( ; count; --count)
            *to++ = (unsigned char) ch;
      return target;
}

#endif


--- QM v1.00
 * Origin: MicroFirm : Down to the C in chips (1:106/2000.6)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
