===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-23-93 (19:12)             Number: 62
From: BOB STOUT                    Refer#: 158
  To: BRUCE BRISTOL                 Recvd: NO  
Subj: Reverse Read                   Conf: (36) C Language
---------------------------------------------------------------------------
In a message of <May 21 19:54>, Bruce Bristol (1:102/1006@fidonet) writes:

 >Problem: Read the last record of a flat ASCII file delimited by
 >         CR/LF.

 >I'm curious if there is a function in C to read a file in reverse order.

  From SNIPPETS:

/*
** figets like fgets only works backward from filepos pos instead of
** forward from the current filepointer
**
** returns fileposition of the begin of line read
**
** by Jan Vroonhof
*/

#include <stdio.h>
#include <string.h>

#define MAXLEN 90

long figets(FILE *file, char *buffer, long pos)
{
      char *ptr;
      long aap;

      aap = (pos - MAXLEN > 0 ? pos-MAXLEN : 0L);
      fseek(file, aap, SEEK_SET);
      fread(buffer + 100, 1, MAXLEN, file);
      buffer[pos - aap + 100] = 0;
      ptr = strrchr(buffer + 100, '\n');
      if (ptr)
      {
            *ptr = 0;
            ptr = strrchr(buffer + 100, '\n');
            if (ptr)
            {
                  strcpy(buffer, ptr + 1);
                  return aap + (ptr - buffer - 100) + 1;
            }
            else
            {
                  strcpy(buffer, buffer + 100);
                  return (aap ? -1L : 0L);
            }
      }
      else
      {
            strcpy(buffer, buffer + 100);
            return -1L;
      }
}

#ifdef TEST

void main(void)
{
      char buf[256];
      FILE *fp;
      long pos;

      fp = fopen("figets.c", "r");
      fseek(fp, 0L, SEEK_END);
      pos = ftell(fp);
      do {
            pos = figets(fp, buf, pos);
            puts (buf);
      } while (pos);
}

#endif /* TEST */


--- QM v1.00
 * Origin: MicroFirm : Down to the C in chips (1:106/2000.6)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
