===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 04-24-93 (14:12)             Number: 98
From: BOB STOUT                    Refer#: 160
  To: MIKE WARDLE                   Recvd: NO  
Subj: File Copy Function             Conf: (36) C Language
---------------------------------------------------------------------------
  From an upcoming SNIPPETS:

/*
**  FLOPCOPY.C
**
**  Copy a floppy to a hard disk directory with directory recursion
**  Public domain, uses functions from SNIPPETS.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <io.h>
#include <fcntl.h>

#if defined(__TURBOC__)
 #include <dir.h>
 #include <dos.h>
 #define _dos_findfirst(f,a,b) findfirst(f,b,a)
 #define _dos_findnext(b) findnext(b)
 #define find_t ffblk
 #define _A_SUBDIR FA_DIREC
 #define attrib ff_attrib
 #define name ff_name
#else
 #include <direct.h>
 #ifdef __ZTC__
  #include <dos.h>
  #ifndef _A_SUBDIR
   #define _A_SUBDIR FA_DIREC
  #endif
 #else                   /* assume MSC/QC                                */
  #include <dos.h>
  #include <errno.h>
  #include <sys\types.h>
 #endif
#endif

#include <sys\stat.h>

#ifndef SUCCESS
 #define SUCCESS 0
#endif

int file_copy(char *,char *);
void do_dir(char *, char *);

/*
**  Copy a floppy to an HD subdirectory
*/

int main(int argc, char *argv[])
{
      char fdrv[3] = "A:";

      if (3 > argc)
      {
            puts("Usage: FLOPCOPY drive_letter subdir");
            puts("where: drive_letter is \"A\" or \"B\" (colon optional)");
            puts("       subdir is drive:dir target, e.g. \"C:\\FLOPSTUF\"");
            return EXIT_FAILURE;
      }
      *fdrv = *argv[1];

      do_dir(fdrv, argv[2]);
}

/*
**  Copy a file (SNIPPETS: Wb_Fcopy.C)
*/

int file_copy(char *from,char *to)
{       int fdfrom,fdto;
        int bufsiz;

        fdfrom = open(from,O_RDONLY|O_BINARY,0);
        if (fdfrom < 0)
                return 1;
        fdto=open(to,O_BINARY|O_CREAT|O_TRUNC|O_RDWR,S_IREAD|S_IWRITE);
        if (fdto < 0)
            goto err;

        /* Use the largest buffer we can get    */
        for (bufsiz = 0x4000; bufsiz >= 128; bufsiz >>= 1)
        {   register char *buffer;

            buffer = (char *) malloc(bufsiz);
            if (buffer)
            {   while (1)
                {   register int n;

                    n = read(fdfrom,buffer,bufsiz);
                    if (n == -1)                /* if error             */
                        break;
                    if (n == 0)                 /* if end of file       */
                    {   free(buffer);
                        close(fdto);
                        close(fdfrom);
                        return 0;               /* success              */
                    }
                    if (n != write(fdto,buffer,(unsigned) n))
                        break;
                }
                free(buffer);
                break;
            }
        }
err2:   close(fdto);
        remove(to);                             /* delete any partial file */
err:    close(fdfrom);
        return 1;
}

/*
**  Process a directory (SNIPPETS: Treedir.C, modified)
*/

void do_dir(char *from, char *to)
{
      char search[FILENAME_MAX], new[FILENAME_MAX], newto[FILENAME_MAX];
      struct find_t ff;

      strcat(strcpy(search, from), "\\*.*");
      if (SUCCESS == _dos_findfirst(to, 0xff, &ff))
      {
            if (0 == (ff.attrib & _A_SUBDIR))
            {
                  printf("*** %s Exists and is not a directory!\n", to);
                  return;
            }
      }
      else  mkdir(to);
      if (SUCCESS == _dos_findfirst(search, 0xff, &ff)) do
      {
            if (ff.attrib & _A_SUBDIR && '.' != *ff.name)
            {
                  strcat(strcat(strcpy(new, from), "\\"), ff.name);
                  strcat(strcat(strcpy(newto, to), "\\"), ff.name);
                  do_dir(new, newto);
            }
            else
            {
                  char file1[FILENAME_MAX], file2[FILENAME_MAX];

                  if ((ff.attrib & (_A_SUBDIR | _A_VOLID)) || '.' == *ff.name)
                        continue;
                  strcat(strcat(strcpy(file1, from), "\\"), ff.name);
                  strcat(strcat(strcpy(file2, to), "\\"), ff.name);
