===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 06-04-93 (13:45)             Number: 50
From: UENAL MUTLU                  Refer#: NONE
  To: ALL                           Recvd: NO  
Subj: MKENUM: Cycling through a      Conf: (37) C++ Langua
---------------------------------------------------------------------------
//--------------------------------------------------------------------
#if 0  /*
   ENUMROT.CPP - Enum Rotator v1.00
   Written 930603 by Uenal Mutlu

   Iterating over all possible values of an enum using a macro and an
   auto-created int-array therein. The enum is fully type-safe and also
   auto-created in the macro.

   Example for enums with max 10 'members' N0..N9 with Values V0..V9
   (some manual work is still neeeded for other count of elems :-( )
   Tip: Use all args (fill up) but set Nelems to the actual count.
        For iterating etc. use
          Name##_Elems    nr of elems
          Name##_Tbl[i]   int array (use only 0..Name##_Elems - 1)
        (both are auto-created in MKENUM)

   Sample Usage:

     // this macro creates the enum MyEnum with 3 values
     MKENUM(MyEnum, 3,  red,300, green,100, blue,400,   /* 3 vals */
                        N3,0, N4,0, N5,0, N6,0, N7,0,   /* filler */
                        N8,0, N9,0);                    /* filler */

     // usages
     MyEnum Color = green;
     MyEnum Bad   = 5;   // BC++3.1 correctly warns such bad usage

     printf("MyEnum has %d user values \n", MyEnum_Nelems);

     // iterating over all values (original sort order)
     for (int i = 0; i < MyEnum_Nelems; i++)
       printf("EnumVal%d == %d \n", i, MyEnum_Tbl[i]);

     // Output:
     //   EnumVal0 == 300
     //   EnumVal1 == 100
     //   EnumVal2 == 400

   Improvements: one could avoid the static array and create it via a
   dyamically (hick :-) defined class template (hick :-) with member-
   initializers etc. So the instance could be created on the stack and
   at need only... Perhaps then var-args could be implemented too...

   BTW: this method also prevents from a compiler (perhaps language)
        bug! Look at the following bad behaviour of my compiler:

        enum TENUM
          {
            Fruehling = -10,
            Sommer    =  10,
            Herbst    =  20,
            Winter    =  30
          } EA, EB = Herbst;  // default initval IS 0 !!!

       Here, EA has the value 0! Though it's not a valid value!
       Is this a compiler-bug or lack in the language? IMO the
       default initializator should be the first value, here -10...

    History:
    --------
    930603ThUm v1.00 posted to comp.lang.cpp
               (Thread: "Cycling through an enum's states")
    930604FrUm posted to C_PLUSPLUS on FidoNet

-
Sysop of RCI-BBS Munich/D.        Bbs/FidoEMail/Fax: +49-89-8002175
EMail : Uenal_Mutlu@p0.f17.n246.z2.{ fido.de, fidonet.org }
FidoID: Uenal Mutlu 2:246/17
A "Gastarbeiter" living 20 years in GERMANY has still ZERO-RIGHTS!!!
-
*/
#endif

//--------------------------------------------------------------------
// THE 'MAGIC' MACRO  "MKENUM":
//--------------------------------------------------------------------
#define MKENUM_MAX_ELEMS   10

#define MKENUM(Name, Nelems,  N0,V0, N1,V1, N2,V2, N3,V3, N4,V4,  \
                              N5,V5, N6,V6, N7,V7, N8,V8, N9,V9)  \
enum Name { N0 = V0, N1 = V1, N2 = V2, N3 = V3, N4 = V4,          \
            N5 = V5, N6 = V6, N7 = V7, N8 = V8, N9 = V9,          \
            Name##_Nelems = Nelems };  /* use this for actual nelems */ \
static int const Name##_Tbl[MKENUM_MAX_ELEMS] = { N0, N1, N2, N3, N4,   \
                                                  N5, N6, N7, N8, N9 }

// since all enum values, nelem and the table_name is known one can
// iterate simply over all possible values.

//--------------------------------------------------------------------
// TEST PART:
//--------------------------------------------------------------------
#if 1

#include <stdio.h>

// sample usage:
MKENUM(MyEnum, 3,  red,300, green,100, blue,400,               /* 3 used */
                   N3,0, N4,0, N5,0, N6,0, N7,0, N8,0, N9,0);  /* filler */

int main()
  {
    MyEnum eColor = green;
    MyEnum eBad   = 5;   // BC++3.1 correctly warns such bad usage (s.b.)

    // iterating
    printf("MyEnum has %d user values \n", MyEnum_Nelems);
    for (int i = 0; i < MyEnum_Nelems; i++)
      printf("Val%d == %d \n", i, MyEnum_Tbl[i]);


    // dummy to shut-up the compiler warnings "eColor, eBad  not used"...
    int rc = eColor == eBad;

    return rc;
  }

#endif

//--------------------------------------------------------------------
// COMPILE AND RUN:
//--------------------------------------------------------------------
/*
Compile: bcc -ml enumrot.cpp
--------
Borland C++  Version 3.1 Copyright (c) 1992 Borland International
enumrot.cpp:
Warning enumrot.cpp 89: Initializing MyEnum with int in function main()
Turbo Link  Version 5.1 Copyright (c) 1992 Borland International

Run:
----
MyEnum has 3 user values
Val0 == 300
Val1 == 100
Val2 == 400
*/

//--------------------------------------------------------------------

--- DB 1.53/001602
 * Origin: RCI-BBS Munich/D [+49-89-8002175] (2:246/17)
SEEN-BY: 1/211 11/2 4 13/13 101/1 109/25 114/5 123/19 124/1 153/752 154/40
SEEN-BY: 154/77 157/110 159/100 125 140 180 270 430 575 950 203/23 209/209
SEEN-BY: 261/1023 280/1 390/1 396/1 5 15 2440/5 3603/20
