===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 04-28-93 (18:45)             Number: 165
From: WAYNE MATSON                 Refer#: NONE
  To: CHRIS DOWNS                   Recvd: NO  
Subj: get disk free space   1/2      Conf: (36) C Language
---------------------------------------------------------------------------
CD>How can I get the amount of free space on a hard disk?  I tried calling DOS
  >with function 1B.  But that (or the code afterwards) sent the program into
  >never never land.  Could someone please provide a helpful little snippet?
  >Thanks,

Chris
    Here is a small program I whip up for you to show how this can be
    done.  The main code you want is GetDiskSpace(), but I have created
    a complete working program to make sure it use properly debugged.

snip-------------------------->------------------------------------------------
/******************************************************************************
 ** DiskFree.C                                                               **
 **     Display disk total, used and free space.                             **
 **                                                                          **
 ** Author: Wayne Matson                                                     **
 **   Date: 04/27/93                                                         **
 **                                                                          **
 ******************************************************************************/
#include <stdio.h>
#include <dos.h>

typedef unsigned long   Ulong;

#define DosInt21        0x21
#define GetFreeSpace    0x36

static char     *CommaDelimStr(char *str);
static int      GetDiskSpace(int drv, Ulong *ttlDrv, Ulong *ttlFree);

int main(int argc, char **argv) {
char            *usage = "\tUsage: DiskFree drv:";
char            totalBytesStr[13];
char            totalFreeStr[13];
char            totalUsedStr[13];
char            formatStr[10];
int             drvNum = 0;
Ulong           totalBytesNum;
Ulong           totalFreeNum;

    if (argc > 2) {
        puts(usage);
        exit(1);
    }

    if (argc == 2)
        drvNum = toupper(*argv[1]) - 'A' + 1;

    if (GetDiskSpace(drvNum, &totalBytesNum, &totalFreeNum)) {
        printf("\tInvalid Drive Letter %s", argv[1]);
        exit(2);
    }

    sprintf(totalBytesStr, "%lu", totalBytesNum);
    sprintf(totalFreeStr, "%lu", totalFreeNum);
    sprintf(totalUsedStr, "%lu", totalBytesNum-totalFreeNum);

    CommaDelimStr(totalBytesStr);
    CommaDelimStr(totalFreeStr);
    CommaDelimStr(totalUsedStr);

    sprintf(formatStr, "  %%%ds  %%s\n",strlen(totalBytesStr));

    printf(formatStr, totalBytesStr, "bytes total disk space");
    printf(formatStr, totalUsedStr,  "bytes used");
    printf(formatStr, totalFreeStr, "bytes free");

    return 0;
}

static char *CommaDelimStr(char *str) {
/******************************************************************************
 ** Make a numeric string into a comma delimited numeric string.             **
 **                                                                          **
 ** Syntax:                                                                  **
 ** char *CommaDelimStr(char *str)                                           **
 **     str     = char pointer to numeric string which has enough space to   **
 **               add the necessary commas. so if you pass '99999' then the  **
 **               str pointer must be large enough the accomodate the comma  **
 **               like '99,999'.                                             **
 **                                                                          **
 ** returns a pointer str if success or NULL if str is a zero length string. **
 ******************************************************************************/
char            *dynStr = NULL;
char            *dynPtr;
char            *strPtr;
int             strLen;
int             strCommas;
int             i,x;

    strLen      = strlen(str);
    if (NULL == str || 0 == strLen)
    return NULL;
>>> Continued to next message
--- RAMail 3.3
 * Origin: ABACUS BBS - Chaparral,NM. (505) 824-0049 HST DS (1:381/85)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 280/1
SEEN-BY: 390/1 396/1 5 15 2270/1 2440/5 3603/20
