===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 06-06-93 (23:07)             Number: 253
From: DAVID GERSIC                 Refer#: 141
  To: MICHAEL INGRAM                Recvd: NO  
Subj: Re: Arcivers "ID" strings      Conf: (36) C Language
---------------------------------------------------------------------------
/* Quoting MICHAEL INGRAM on 06-03-93  01:45... */

 MI> I am messing around with some different arciver programs on the PC,
 MI> and was wondering if anyone out there had any specs for "ID" strings
 MI> of certian arciver programs.  I beleive PKzip uses "PK" as the first
 MI> two characters in the file.  I am looking for the "ID" strings for:

Bob Stout just posted this a few days ago, but:

#include <stdio.h>
#include <string.h>

#define TEST

int WhichArc(char *pName);

#ifdef TEST

int
main(int argc,char *argv[])
{
    char *arc_types[]={"UNKNOWN",
                       "ARC",
                       "ZOO",
                       "ARJ",
                       "LHARC",
                       "LHA",
                       "ZIP",
                       "PAK",
                       "PAK",
                       "ARC6",
                       "SFXARC",
                       "SFXARJ",
                       "SFXLHARC",
                       "SFXLHA",
                       "SFXZIP",
                       "SFXARC6",
                       "SFXPAK",
                       "EXE"};

    printf("Archive type is %s\n",arc_types[WhichArc(argv[1])]);
    return(0);
}

#endif

/* --------------------------------------------------------------------
   Module:     WHICHARC.C
   Subject:    tries to determine the archiver used to compress files
   Author:     Heinz Ozwirk
               free for all participants of the C_ECHO
   Started:    28.09.1991   13:35:57
   Modified:   13.10.1991   14:15:57
   Modified:   5 January, 1992 11:50am by David Gersic
                   Added return codes for self extracting archive files.
   Modified:   16 January, 1992, 4:15pm by David Gersic
                   Added Pak and ARC ver. 6 with information from Richard
                   Vanhouten @1:272/38. I'm not sure that this code works
                   perfectly for those formats, as his message seems to
                   indicate that the entire archive has to be scanned for
                   headers to check before the type can be perfectly
                   determined. It seems to work for test archives produced
                   here, but may not work for all archives.
   --------------------------------------------------------------------
   Prototype:  int WhichArc(char *pName)
      pName    address of full path name of file to examine
      Result   -1:      file not found
               UNKNOWN: unknown packer
               ARC:     ARC or PKARC
               ARJ:     ARJ
               LHA:     LHARC or LHA
               ZIP:     PKZIP
               ZOO:     Zoo
               PAK:     Pak
               ARC6:    ARC ver. 6 or higher
               SFXARC:  Self Extracting PKARC
               SFXARJ:  Self Extracting ARJ
               SFXLHARC:Self Extracting LHARC
               SFXLHA:  Self Extracting LHA
               SFXZIP:  Self Extracting ZIP
               SFXPAK:  Self Extracting Pak
               SFXARC6: Self Extracting ARC ver. 6 or higher
               EXE:     MS DOS executable of unknown type

   LHARC/LHA
      No archive header. WhichArc examines the checksum of the first
      file header. If the checksum is valid and if the string -lh?-
      is found, LHA or LHARC is assumed.

   ARJ
      If a file starts with 0x60, 0xEA, ARJ is assumed.

   ZIP
      If the file begins with "PK", PKZIP is assumed.

   ZOO
      Zoo'ed archives always start with "ZOO x.xx Archive". WhichArc
      only looks for "ZOO".

   ARC
      No header. Files starting with 0x1A are assumed to be ARCed.

   PAK
      Similar to ARC files, but if the second byte of the header is 0x0a or
      0x0b, it was created by Pak.

    ARC6
      Similar to ARC, but if the second byte of the header is 0x14 or
      higher, it was created by Arc version 6 or higher.

   SFX*
      All of the SFX files start with a small decompressor. Seek past
      the decompressor and repeat the above checks.
   -------------------------------------------------------------------- */


typedef unsigned char BYTE;

#define UNKNOWN 0
#define ARC     1
#define ZOO     2
#define ARJ     3
#define LHARC   4
#define LHA     5
#define ZIP     6
#define PAK     7
#define ARC6    8
#define SFXARC  9
#define SFXARJ  10
#define SFXLHARC 11
#define SFXLHA  12
#define SFXZIP  13
#define SFXARC6 14
#define SFXPAK  15
#define EXE     16

int WhichArc(char *pName)
{
   FILE  *fp;
   BYTE  header[128];
   int   c, i, n;

    memset(header, 0, sizeof(header));
    fp = fopen(pName, "rb");
    if (fp == NULL)
         return -1;     /* error opening file */
    n = fread(header, sizeof(BYTE), sizeof(header) - sizeof(BYTE), fp);
    fclose(fp);
